﻿DROP TABLE IF EXISTS `catalogue_cats`;
CREATE TABLE IF NOT EXISTS `catalogue_cats` (
  `cat_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat_parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `cat_show_order` int(10) unsigned NOT NULL DEFAULT '0',
  `cat_path` varchar(255) NOT NULL DEFAULT '',
  `cat_name` varchar(255) NOT NULL DEFAULT '',
  `cat_anons` text NOT NULL,
  `cat_description` longtext NOT NULL,
  `cat_hidden` enum('true','false') NOT NULL DEFAULT 'false',
  `cat_picture` varchar(255) DEFAULT NULL,
  `cat_meta_title` varchar(255) NOT NULL,
  `cat_meta_descriptions` varchar(255) NOT NULL,
  `cat_meta_keywords` varchar(255) NOT NULL,
  `cat_url` varchar(255) NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cat_id`,`cat_path`),
  KEY `cat_parent_id` (`cat_parent_id`),
  KEY `cat_show_order` (`cat_show_order`),
  KEY `cat_hidden` (`cat_hidden`),
  KEY `cat_picture` (`cat_picture`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

DROP TABLE IF EXISTS `catalogue_cats_params`;
CREATE TABLE IF NOT EXISTS `catalogue_cats_params` (
  `cat_id` int(10) unsigned NOT NULL DEFAULT '0',
  `param_id` int(10) unsigned NOT NULL DEFAULT '0',
  `show_order` int(10) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`cat_id`,`param_id`),
  KEY `show_order` (`show_order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `catalogue_cats_pgroups`;
CREATE TABLE IF NOT EXISTS `catalogue_cats_pgroups` (
  `group_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `cat_id` int(11) NOT NULL DEFAULT '0',
  `param_id` int(10) unsigned NOT NULL DEFAULT '0',
  `show_order` int(10) unsigned NOT NULL DEFAULT '0',
  `good_list` enum('true','false') NOT NULL DEFAULT 'false',
  `group_name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`group_id`),
  KEY `group_parent_id` (`group_parent_id`),
  KEY `param_id` (`param_id`),
  KEY `good_list` (`good_list`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

DROP TABLE IF EXISTS `catalogue_cats_rels`;
CREATE TABLE IF NOT EXISTS `catalogue_cats_rels` (
  `cat_id` int(10) unsigned NOT NULL DEFAULT '0',
  `cat_ancestor_id` int(10) unsigned NOT NULL DEFAULT '0',
  `cat_ancestor_pos` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cat_id`,`cat_ancestor_id`),
  KEY `cat_ancestor_id` (`cat_ancestor_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `catalogue_cats_thumbnails`;
CREATE TABLE IF NOT EXISTS `catalogue_cats_thumbnails` (
  `cat_id` int(10) unsigned NOT NULL DEFAULT '0',
  `thumb_id` int(10) unsigned NOT NULL DEFAULT '0',
  `cat` tinyint(4) NOT NULL DEFAULT '0',
  `good` tinyint(4) NOT NULL DEFAULT '0',
  `newest` tinyint(4) NOT NULL DEFAULT '0',
  `specs` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cat_id`,`thumb_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `catalogue_goods`;
CREATE TABLE IF NOT EXISTS `catalogue_goods` (
  `good_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat_id` int(10) unsigned NOT NULL DEFAULT '0',
  `good_show_order` int(10) unsigned NOT NULL DEFAULT '0',
  `good_path` varchar(255) NOT NULL DEFAULT '',
  `good_name` varchar(255) NOT NULL DEFAULT '',
  `good_short_descr` text NOT NULL,
  `good_full_descr` longtext NOT NULL,
  `good_newest` enum('true','false') NOT NULL DEFAULT 'false',
  `good_spec` enum('true','false') NOT NULL DEFAULT 'false',
  `good_hidden` enum('true','false') NOT NULL DEFAULT 'true',
  `good_picture` varchar(255) DEFAULT NULL,
  `good_price` FLOAT(20) NOT NULL DEFAULT '0',
  `catalogue_producer_id` int(11) NOT NULL DEFAULT '0',
  `good_meta_title` varchar(255) NOT NULL,
  `good_meta_keywords` varchar(255) NOT NULL,
  `good_meta_descriptions` varchar(255) NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  `goods_assoc` text NOT NULL,
  PRIMARY KEY (`good_id`,`good_path`),
  KEY `cat_id` (`cat_id`),
  KEY `good_newest` (`good_newest`),
  KEY `good_spec` (`good_spec`),
  KEY `good_hidden` (`good_hidden`),
  KEY `good_picture` (`good_picture`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `catalogue_goods_files`;
CREATE TABLE IF NOT EXISTS `catalogue_goods_files` (
  `file_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `good_id` int(10) unsigned NOT NULL DEFAULT '0',
  `filedescr` varchar(255) NOT NULL DEFAULT '',
  `filename` varchar(255) NOT NULL DEFAULT '',
  `fileext` varchar(255) NOT NULL DEFAULT '',
  `filesize` int(10) unsigned NOT NULL DEFAULT '0',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`file_id`,`good_id`),
  KEY `filesize` (`filesize`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `catalogue_goods_pics`;
CREATE TABLE IF NOT EXISTS `catalogue_goods_pics` (
  `picture_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `good_id` int(10) unsigned NOT NULL DEFAULT '0',
  `show_order` int(10) unsigned NOT NULL DEFAULT '0',
  `good_picture` varchar(255) NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`picture_id`),
  KEY `good_id` (`good_id`),
  KEY `show_order` (`show_order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `catalogue_goods_response`;
CREATE TABLE IF NOT EXISTS `catalogue_goods_response` (
  `catalogue_goods_response_id` int(11) NOT NULL AUTO_INCREMENT,
  `good_id` int(11) NOT NULL,
  `catalogue_goods_response_user_name` varchar(255) NOT NULL,
  `catalogue_goods_response_publish` enum('Y','N') NOT NULL DEFAULT 'N',
  `catalogue_goods_response_text` text NOT NULL,
  PRIMARY KEY (`catalogue_goods_response_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

DROP TABLE IF EXISTS `catalogue_links`;
CREATE TABLE IF NOT EXISTS `catalogue_links` (
  `node_id` int(10) unsigned NOT NULL DEFAULT '0',
  `view` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`node_id`,`view`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `catalogue_options`;
CREATE TABLE IF NOT EXISTS `catalogue_options` (
  `option_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `option_key` varchar(255) NOT NULL DEFAULT '',
  `option_name` varchar(255) NOT NULL DEFAULT '',
  `option_value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_key` (`option_key`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

INSERT INTO `catalogue_options` (`option_id`, `option_key`, `option_name`, `option_value`) VALUES (1, 'admin_email', 'E - mail администратора', '');
INSERT INTO `catalogue_options` (`option_id`, `option_key`, `option_name`, `option_value`) VALUES (2, 'delivery_price', 'Стоимость срочной доставки', '700 рублей');

DROP TABLE IF EXISTS `catalogue_params`;
CREATE TABLE IF NOT EXISTS `catalogue_params` (
  `param_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `param_type` int(10) unsigned NOT NULL DEFAULT '1',
  `param_name` varchar(255) NOT NULL DEFAULT '',
  `param_data` text NOT NULL,
  PRIMARY KEY (`param_id`),
  KEY `param_type` (`param_type`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

DROP TABLE IF EXISTS `catalogue_params_types`;
CREATE TABLE IF NOT EXISTS `catalogue_params_types` (
  `type_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_sys` varchar(255) NOT NULL DEFAULT '',
  `type_name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

INSERT INTO `catalogue_params_types` (`type_id`, `type_sys`, `type_name`) VALUES (1, 'string', 'Строка');
INSERT INTO `catalogue_params_types` (`type_id`, `type_sys`, `type_name`) VALUES (2, 'number', 'Число');
INSERT INTO `catalogue_params_types` (`type_id`, `type_sys`, `type_name`) VALUES (3, 'list', 'Список');

DROP TABLE IF EXISTS `catalogue_params_values`;
CREATE TABLE IF NOT EXISTS `catalogue_params_values` (
  `good_id` int(10) unsigned NOT NULL DEFAULT '0',
  `param_id` int(10) unsigned NOT NULL DEFAULT '0',
  `param_value` text NOT NULL,
  PRIMARY KEY (`good_id`,`param_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `catalogue_preferences`;
CREATE TABLE IF NOT EXISTS `catalogue_preferences` (
  `photogallery` enum('true','false') NOT NULL DEFAULT 'false',
  `newest_count` int(10) unsigned NOT NULL DEFAULT '3',
  `specs_count` int(10) unsigned NOT NULL DEFAULT '3',
  `empty_cat_message` longtext NOT NULL,
  `empty_spec_pic` varchar(255) NOT NULL DEFAULT '',
  `empty_newest_pic` varchar(255) NOT NULL DEFAULT '',
  `empty_cat_pic` varchar(255) NOT NULL DEFAULT '',
  `empty_good_pic` varchar(255) NOT NULL DEFAULT '',
  `empty_good_item_pic` varchar(255) NOT NULL DEFAULT '',
  `show_goods_from_subcats` enum('true','false') NOT NULL,
  `filters` enum('true','false') NOT NULL DEFAULT 'false',
  `good_response_publish` enum('Y','N') NOT NULL DEFAULT 'N'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `catalogue_preferences` (`photogallery`, `newest_count`, `specs_count`, `empty_cat_message`, `empty_spec_pic`, `empty_newest_pic`, `empty_cat_pic`, `empty_good_pic`, `empty_good_item_pic`, `show_goods_from_subcats`, `filters`, `good_response_publish`) VALUES ('false', 3, 3, '<P>На данный момент в категории "{$cat_name}" товары отсутствуют. Приносим свои извинения за предоставленные неудобства.</P>', '', '', '', '', '', 'true', 'true', 'Y');

DROP TABLE IF EXISTS `catalogue_preferences_thumbnails`;
CREATE TABLE IF NOT EXISTS `catalogue_preferences_thumbnails` (
  `thumb_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `thumb_name` varchar(255) NOT NULL DEFAULT '',
  `hsize` int(10) unsigned NOT NULL DEFAULT '0',
  `vsize` int(10) unsigned NOT NULL DEFAULT '0',
  `show_order` int(10) unsigned NOT NULL DEFAULT '1',
  `default_for_cat` enum('true','false') NOT NULL DEFAULT 'false',
  `default_for_good` enum('true','false') NOT NULL DEFAULT 'false',
  `default_for_newest` enum('true','false') NOT NULL DEFAULT 'false',
  `default_for_specs` enum('true','false') NOT NULL DEFAULT 'false',
  PRIMARY KEY (`thumb_id`),
  KEY `show_order` (`show_order`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

INSERT INTO `catalogue_preferences_thumbnails` (`thumb_id`, `thumb_name`, `hsize`, `vsize`, `show_order`, `default_for_cat`, `default_for_good`, `default_for_newest`, `default_for_specs`) VALUES (1, 'Уменьшенное изображение товара', 100, 100, 1, 'true', 'false', 'true', 'true');
INSERT INTO `catalogue_preferences_thumbnails` (`thumb_id`, `thumb_name`, `hsize`, `vsize`, `show_order`, `default_for_cat`, `default_for_good`, `default_for_newest`, `default_for_specs`) VALUES (2, 'Среднее изображение товара', 200, 200, 2, 'false', 'true', 'false', 'false');

DROP TABLE IF EXISTS `catalogue_producers`;
CREATE TABLE IF NOT EXISTS `catalogue_producers` (
  `catalogue_producer_id` int(11) NOT NULL AUTO_INCREMENT,
  `catalogue_producer_title` varchar(255) NOT NULL DEFAULT '',
  `catalogue_producer_logo` varchar(255) NOT NULL DEFAULT '',
  `catalogue_producer_site` varchar(255) NOT NULL DEFAULT '',
  `catalogue_producer_anons` text NOT NULL,
  `catalogue_producer_text` longtext NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  `catalogue_producer_publish` enum('Y','N') NOT NULL DEFAULT 'N',
  `catalogue_producer_url` varchar(255) NOT NULL,
  PRIMARY KEY (`catalogue_producer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

