-- --------------------------------------------------------

-- 
-- Структура таблицы `alphabet`
-- 

DROP TABLE IF EXISTS `alphabet`;
CREATE TABLE IF NOT EXISTS `alphabet` (
  `alphabet_id` int(11) NOT NULL auto_increment,
  `alphabet_title` varchar(1) NOT NULL,
  PRIMARY KEY  (`alphabet_id`)
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=utf8 AUTO_INCREMENT=30 ;

-- 
-- Дамп данных таблицы `alphabet`
-- 

INSERT INTO `alphabet` VALUES (1, 'В');
INSERT INTO `alphabet` VALUES (2, 'А');
INSERT INTO `alphabet` VALUES (3, 'Ы');
INSERT INTO `alphabet` VALUES (4, '1');
INSERT INTO `alphabet` VALUES (5, 'A');
INSERT INTO `alphabet` VALUES (6, 'C');
INSERT INTO `alphabet` VALUES (7, 'D');
INSERT INTO `alphabet` VALUES (8, 'E');
INSERT INTO `alphabet` VALUES (9, 'F');
INSERT INTO `alphabet` VALUES (10, 'Н');
INSERT INTO `alphabet` VALUES (11, 'G');
INSERT INTO `alphabet` VALUES (12, 'I');
INSERT INTO `alphabet` VALUES (13, 'H');
INSERT INTO `alphabet` VALUES (14, 'L');
INSERT INTO `alphabet` VALUES (15, 'M');
INSERT INTO `alphabet` VALUES (16, 'N');
INSERT INTO `alphabet` VALUES (17, 'O');
INSERT INTO `alphabet` VALUES (18, 'P');
INSERT INTO `alphabet` VALUES (19, 'R');
INSERT INTO `alphabet` VALUES (20, 'S');
INSERT INTO `alphabet` VALUES (21, 'T');
INSERT INTO `alphabet` VALUES (22, 'U');
INSERT INTO `alphabet` VALUES (23, 'Y');
INSERT INTO `alphabet` VALUES (24, 'Z');
INSERT INTO `alphabet` VALUES (25, 'Б');
INSERT INTO `alphabet` VALUES (26, 'Г');
INSERT INTO `alphabet` VALUES (27, 'Д');
INSERT INTO `alphabet` VALUES (28, 'З');
INSERT INTO `alphabet` VALUES (29, 'И');

-- --------------------------------------------------------

-- 
-- Структура таблицы `arm_administrators`
-- 

DROP TABLE IF EXISTS `arm_administrators`;
CREATE TABLE IF NOT EXISTS `arm_administrators` (
  `administrator_id` int(10) unsigned NOT NULL auto_increment,
  `administrator_owner_id` int(10) unsigned NOT NULL default '0',
  `creation_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `force_refresh` enum('false','true') NOT NULL default 'false',
  `force_relogin` enum('false','true') NOT NULL default 'false',
  `changed` enum('true','false') NOT NULL default 'false',
  `change_date` datetime default NULL,
  `change_administrator_id` int(10) unsigned NOT NULL default '0',
  `administrator_login` varchar(50) NOT NULL default '',
  `administrator_psw` varchar(32) NOT NULL default '',
  `administrator_email` varchar(255) NOT NULL default '',
  `administrator_email_notify` enum('true','false') NOT NULL default 'true',
  `administrator_name` varchar(50) NOT NULL default '',
  `administrator_secondname` varchar(255) NOT NULL,
  `administrator_surname` varchar(255) NOT NULL,
  `administrator_notes` text NOT NULL,
  `administrator_active` enum('true','false') NOT NULL default 'true',
  `administrator_ip` varchar(255) NOT NULL default '',
  `administrator_last_visit` datetime default NULL,
  `administrator_last_activity` datetime default NULL,
  `lang_version_id` int(10) unsigned NOT NULL default '0',
  `administrator_ext_install` enum('false','true') NOT NULL default 'false',
  `hash` varchar(255) NOT NULL,
  `owner_id` tinyint(4) default '0',
  PRIMARY KEY  (`administrator_id`),
  UNIQUE KEY `administrator_login` (`administrator_login`,`administrator_active`),
  KEY `administrator_owner_id` (`administrator_owner_id`),
  KEY `lang_version_id` (`lang_version_id`),
  KEY `administrator_active` (`administrator_active`),
  KEY `administrator_email` (`administrator_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

-- 
-- Дамп данных таблицы `arm_administrators`
-- 

INSERT INTO `arm_administrators` VALUES (1, 0, '2007-08-15 12:30:01', 'true', 'true', 'false', NULL, 0, '{$LOGIN}', '{$PASSWORD}', '{$EMAIL}', 'true', '{$NAME}', '', '', '', 'true', '', '2010-10-19 22:21:53', '2010-10-19 23:12:07', 0, 'true', '', 0);

-- --------------------------------------------------------

-- 
-- Структура таблицы `arm_administrators_extra`
-- 

DROP TABLE IF EXISTS `arm_administrators_extra`;
CREATE TABLE IF NOT EXISTS `arm_administrators_extra` (
  `administrator_id` int(10) unsigned NOT NULL default '0',
  `lastname` varchar(255) NOT NULL default '',
  `fathername` varchar(255) NOT NULL default '',
  `administrator_notes` text NOT NULL,
  `work_company` varchar(255) NOT NULL default '',
  `work_area_name` varchar(255) NOT NULL default '',
  `work_profession` varchar(255) NOT NULL default '',
  `work_sphere_name` varchar(255) NOT NULL default '',
  `work_phone_number` varchar(255) NOT NULL default '',
  `work_fax_number` varchar(255) NOT NULL default '',
  `work_country_name` varchar(255) NOT NULL default '',
  `work_city_name` varchar(255) NOT NULL default '',
  `work_street_name` varchar(255) NOT NULL default '',
  `work_zip_code` varchar(255) NOT NULL default '',
  `work_notes` text NOT NULL,
  `private_company` varchar(255) NOT NULL default '',
  `private_profession` varchar(255) NOT NULL default '',
  `private_www` varchar(255) NOT NULL default '',
  `private_phone_number` varchar(255) NOT NULL default '',
  `private_fax_number` varchar(255) NOT NULL default '',
  `private_cell_number` varchar(255) NOT NULL default '',
  `private_icq` varchar(255) NOT NULL default '',
  `private_country_name` varchar(255) NOT NULL default '',
  `private_city_name` varchar(255) NOT NULL default '',
  `private_street_name` varchar(255) NOT NULL default '',
  `private_zip_code` varchar(255) NOT NULL default '',
  `private_notes` text NOT NULL,
  PRIMARY KEY  (`administrator_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `arm_administrators_extra`
-- 

INSERT INTO `arm_administrators_extra` VALUES (1, '{$SURNAME}', '{$PATRONYMIC}', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');

-- --------------------------------------------------------

-- 
-- Структура таблицы `arm_administrators_groups_rels`
-- 

DROP TABLE IF EXISTS `arm_administrators_groups_rels`;
CREATE TABLE IF NOT EXISTS `arm_administrators_groups_rels` (
  `administrator_id` int(10) unsigned NOT NULL default '0',
  `group_id` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`administrator_id`,`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `arm_administrators_groups_rels`
-- 


-- --------------------------------------------------------

-- 
-- Структура таблицы `arm_administrators_premind`
-- 

DROP TABLE IF EXISTS `arm_administrators_premind`;
CREATE TABLE IF NOT EXISTS `arm_administrators_premind` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `administrator_id` int(10) unsigned NOT NULL,
  `hash_key1` varchar(40) NOT NULL,
  `confirmed` enum('false','true') NOT NULL default 'false',
  `password_hash` varchar(255) NOT NULL,
  `hash_key2` varchar(40) NOT NULL,
  PRIMARY KEY  (`id`,`hash_key1`,`hash_key2`),
  KEY `confirmed` (`confirmed`),
  KEY `administrator_id` (`administrator_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- 
-- Дамп данных таблицы `arm_administrators_premind`
-- 


-- --------------------------------------------------------

-- 
-- Структура таблицы `arm_administrators_rels`
-- 

DROP TABLE IF EXISTS `arm_administrators_rels`;
CREATE TABLE IF NOT EXISTS `arm_administrators_rels` (
  `administrator_id` int(10) unsigned NOT NULL default '0',
  `administrator_owner_id` int(10) unsigned NOT NULL default '0',
  `administrator_owner_pos` int(10) unsigned NOT NULL default '0',
  KEY `administrator_id` (`administrator_id`,`administrator_owner_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `arm_administrators_rels`
-- 


-- --------------------------------------------------------

-- 
-- Структура таблицы `arm_groups`
-- 

DROP TABLE IF EXISTS `arm_groups`;
CREATE TABLE IF NOT EXISTS `arm_groups` (
  `group_id` int(10) unsigned NOT NULL auto_increment,
  `administrator_owner_id` int(10) unsigned NOT NULL default '0',
  `creation_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `change_date` datetime default NULL,
  `change_administrator_id` int(10) unsigned NOT NULL default '0',
  `group_name` varchar(50) NOT NULL default '',
  `group_type` enum('admin','users') NOT NULL default 'admin',
  `allow_to_delete` enum('Y','N') NOT NULL default 'Y',
  `owner_id` int(11) NOT NULL,
  PRIMARY KEY  (`group_id`),
  KEY `administrator_owner_id` (`administrator_owner_id`,`group_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

-- 
-- Дамп данных таблицы `arm_groups`
-- 

INSERT INTO `arm_groups` VALUES (1, 1, '2009-09-01 00:00:00', NULL, 0, 'Зарегистрированные пользователи', 'users', 'N', 0);
INSERT INTO `arm_groups` VALUES (2, 1, '2010-07-09 18:22:04', NULL, 0, 'Администраторы', 'admin', 'Y', 0);

-- --------------------------------------------------------

-- 
-- Структура таблицы `arm_groups_rights`
-- 

DROP TABLE IF EXISTS `arm_groups_rights`;
CREATE TABLE IF NOT EXISTS `arm_groups_rights` (
  `right_id` int(10) unsigned NOT NULL auto_increment,
  `group_id` int(10) unsigned NOT NULL default '0',
  `object_id` int(10) unsigned NOT NULL default '0',
  `event_id` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`right_id`),
  KEY `group_id` (`group_id`,`object_id`,`event_id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 AUTO_INCREMENT=16 ;

-- 
-- Дамп данных таблицы `arm_groups_rights`
-- 

INSERT INTO `arm_groups_rights` VALUES (1, 2, 1, 0);
INSERT INTO `arm_groups_rights` VALUES (2, 2, 1, 35);
INSERT INTO `arm_groups_rights` VALUES (3, 2, 1, 36);
INSERT INTO `arm_groups_rights` VALUES (4, 2, 3, 0);
INSERT INTO `arm_groups_rights` VALUES (5, 2, 3, 32);
INSERT INTO `arm_groups_rights` VALUES (6, 2, 3, 33);
INSERT INTO `arm_groups_rights` VALUES (7, 2, 4, 0);
INSERT INTO `arm_groups_rights` VALUES (8, 2, 5, 0);
INSERT INTO `arm_groups_rights` VALUES (9, 2, 6, 0);
INSERT INTO `arm_groups_rights` VALUES (10, 2, 8, 0);
INSERT INTO `arm_groups_rights` VALUES (11, 2, 10, 0);
INSERT INTO `arm_groups_rights` VALUES (12, 2, 15, 0);
INSERT INTO `arm_groups_rights` VALUES (13, 2, 15, 575);
INSERT INTO `arm_groups_rights` VALUES (14, 2, 15, 576);
INSERT INTO `arm_groups_rights` VALUES (15, 2, 15, 577);

-- --------------------------------------------------------

-- 
-- Структура таблицы `arm_objects_rights`
-- 

DROP TABLE IF EXISTS `arm_objects_rights`;
CREATE TABLE IF NOT EXISTS `arm_objects_rights` (
  `object_right_id` int(11) NOT NULL auto_increment,
  `group_id` int(11) NOT NULL,
  `object_id` int(11) NOT NULL,
  `table_name` varchar(40) NOT NULL,
  `write` enum('false','true') NOT NULL,
  `read` enum('false','true') NOT NULL,
  `publish` enum('false','true') NOT NULL,
  `child_create` enum('false','true') NOT NULL,
  PRIMARY KEY  (`object_right_id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 AUTO_INCREMENT=14 ;

-- 
-- Дамп данных таблицы `arm_objects_rights`
-- 

INSERT INTO `arm_objects_rights` VALUES (1, 0, 1, 'text_blocks_data', 'false', 'false', 'false', 'false');
INSERT INTO `arm_objects_rights` VALUES (2, 0, 1, 'news_data', 'false', 'false', 'false', 'false');
INSERT INTO `arm_objects_rights` VALUES (3, 0, 2, 'news_data', 'false', 'false', 'false', 'false');
INSERT INTO `arm_objects_rights` VALUES (4, 0, 3, 'news_data', 'false', 'false', 'false', 'false');
INSERT INTO `arm_objects_rights` VALUES (5, 0, 2, 'text_blocks_data', 'false', 'false', 'false', 'false');
INSERT INTO `arm_objects_rights` VALUES (6, 0, 3, 'text_blocks_data', 'false', 'false', 'false', 'false');
INSERT INTO `arm_objects_rights` VALUES (7, 0, 4, 'text_blocks_data', 'false', 'false', 'false', 'false');
INSERT INTO `arm_objects_rights` VALUES (8, 0, 5, 'text_blocks_data', 'false', 'false', 'false', 'false');
INSERT INTO `arm_objects_rights` VALUES (9, 0, 6, 'text_blocks_data', 'false', 'false', 'false', 'false');
INSERT INTO `arm_objects_rights` VALUES (10, 0, 4, 'news_data', 'false', 'false', 'false', 'false');
INSERT INTO `arm_objects_rights` VALUES (11, 0, 5, 'news_data', 'false', 'false', 'false', 'false');
INSERT INTO `arm_objects_rights` VALUES (12, 0, 6, 'news_data', 'false', 'false', 'false', 'false');
INSERT INTO `arm_objects_rights` VALUES (13, 0, 7, 'news_data', 'false', 'false', 'false', 'false');

-- --------------------------------------------------------

-- 
-- Структура таблицы `catalogue_cats`
-- 

DROP TABLE IF EXISTS `catalogue_cats`;
CREATE TABLE IF NOT EXISTS `catalogue_cats` (
  `cat_id` int(10) unsigned NOT NULL auto_increment,
  `cat_parent_id` int(10) unsigned NOT NULL default '0',
  `cat_show_order` int(10) unsigned NOT NULL default '0',
  `cat_path` varchar(255) NOT NULL default '',
  `cat_name` varchar(255) NOT NULL default '',
  `cat_anons` text NOT NULL,
  `cat_description` longtext NOT NULL,
  `cat_hidden` enum('true','false') NOT NULL default 'false',
  `cat_picture` varchar(255) default NULL,
  `cat_meta_title` varchar(255) NOT NULL,
  `cat_meta_descriptions` varchar(255) NOT NULL,
  `cat_meta_keywords` varchar(255) NOT NULL,
  `cat_url` varchar(255) NOT NULL,
  `owner_id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`cat_id`,`cat_path`),
  KEY `cat_parent_id` (`cat_parent_id`),
  KEY `cat_show_order` (`cat_show_order`),
  KEY `cat_hidden` (`cat_hidden`),
  KEY `cat_picture` (`cat_picture`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

-- 
-- Дамп данных таблицы `catalogue_cats`
-- 

INSERT INTO `catalogue_cats` VALUES (1, 0, 1, '#cat1/', 'про', '', '', 'false', NULL, '', '', '', '', 1);

-- --------------------------------------------------------

-- 
-- Структура таблицы `catalogue_cats_params`
-- 

DROP TABLE IF EXISTS `catalogue_cats_params`;
CREATE TABLE IF NOT EXISTS `catalogue_cats_params` (
  `cat_id` int(10) unsigned NOT NULL default '0',
  `param_id` int(10) unsigned NOT NULL default '0',
  `show_order` int(10) unsigned NOT NULL default '1',
  PRIMARY KEY  (`cat_id`,`param_id`),
  KEY `show_order` (`show_order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `catalogue_cats_params`
-- 


-- --------------------------------------------------------

-- 
-- Структура таблицы `catalogue_cats_pgroups`
-- 

DROP TABLE IF EXISTS `catalogue_cats_pgroups`;
CREATE TABLE IF NOT EXISTS `catalogue_cats_pgroups` (
  `group_id` int(10) unsigned NOT NULL auto_increment,
  `group_parent_id` int(10) unsigned NOT NULL default '0',
  `cat_id` int(11) NOT NULL default '0',
  `param_id` int(10) unsigned NOT NULL default '0',
  `show_order` int(10) unsigned NOT NULL default '0',
  `good_list` enum('true','false') NOT NULL default 'false',
  `group_name` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`group_id`),
  KEY `group_parent_id` (`group_parent_id`),
  KEY `param_id` (`param_id`),
  KEY `good_list` (`good_list`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- 
-- Дамп данных таблицы `catalogue_cats_pgroups`
-- 


-- --------------------------------------------------------

-- 
-- Структура таблицы `catalogue_cats_rels`
-- 

DROP TABLE IF EXISTS `catalogue_cats_rels`;
CREATE TABLE IF NOT EXISTS `catalogue_cats_rels` (
  `cat_id` int(10) unsigned NOT NULL default '0',
  `cat_ancestor_id` int(10) unsigned NOT NULL default '0',
  `cat_ancestor_pos` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`cat_id`,`cat_ancestor_id`),
  KEY `cat_ancestor_id` (`cat_ancestor_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `catalogue_cats_rels`
-- 

INSERT INTO `catalogue_cats_rels` VALUES (1, 1, 1);

-- --------------------------------------------------------

-- 
-- Структура таблицы `catalogue_cats_thumbnails`
-- 

DROP TABLE IF EXISTS `catalogue_cats_thumbnails`;
CREATE TABLE IF NOT EXISTS `catalogue_cats_thumbnails` (
  `cat_id` int(10) unsigned NOT NULL default '0',
  `thumb_id` int(10) unsigned NOT NULL default '0',
  `cat` tinyint(4) NOT NULL default '0',
  `good` tinyint(4) NOT NULL default '0',
  `newest` tinyint(4) NOT NULL default '0',
  `specs` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`cat_id`,`thumb_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `catalogue_cats_thumbnails`
-- 

INSERT INTO `catalogue_cats_thumbnails` VALUES (1, 5, 0, 0, 0, 0);
INSERT INTO `catalogue_cats_thumbnails` VALUES (1, 6, 0, 0, 0, 0);
INSERT INTO `catalogue_cats_thumbnails` VALUES (1, 7, 0, 0, 0, 0);

-- --------------------------------------------------------

-- 
-- Структура таблицы `catalogue_goods`
-- 

DROP TABLE IF EXISTS `catalogue_goods`;
CREATE TABLE IF NOT EXISTS `catalogue_goods` (
  `good_id` int(10) unsigned NOT NULL auto_increment,
  `cat_id` int(10) unsigned NOT NULL default '0',
  `good_show_order` int(10) unsigned NOT NULL default '0',
  `good_path` varchar(255) NOT NULL default '',
  `good_name` varchar(255) NOT NULL default '',
  `good_short_descr` text NOT NULL,
  `good_full_descr` longtext NOT NULL,
  `good_newest` enum('true','false') NOT NULL default 'false',
  `good_spec` enum('true','false') NOT NULL default 'false',
  `good_hidden` enum('true','false') NOT NULL default 'true',
  `good_picture` varchar(255) default NULL,
  `good_price` int(20) NOT NULL default '0',
  `catalogue_producer_id` int(11) NOT NULL default '0',
  `good_meta_title` varchar(255) NOT NULL,
  `good_meta_keywords` varchar(255) NOT NULL,
  `good_meta_descriptions` varchar(255) NOT NULL,
  `owner_id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`good_id`,`good_path`),
  KEY `cat_id` (`cat_id`),
  KEY `good_newest` (`good_newest`),
  KEY `good_spec` (`good_spec`),
  KEY `good_hidden` (`good_hidden`),
  KEY `good_picture` (`good_picture`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

-- 
-- Дамп данных таблицы `catalogue_goods`
-- 

INSERT INTO `catalogue_goods` VALUES (1, 1, 1, 'good1', 'Новый товар 1', '', '', 'false', 'false', 'false', 'good1_Koala.jpg', 0, 0, '', '', '', 1);

-- --------------------------------------------------------

-- 
-- Структура таблицы `catalogue_goods_files`
-- 

DROP TABLE IF EXISTS `catalogue_goods_files`;
CREATE TABLE IF NOT EXISTS `catalogue_goods_files` (
  `file_id` int(10) unsigned NOT NULL auto_increment,
  `good_id` int(10) unsigned NOT NULL default '0',
  `filedescr` varchar(255) NOT NULL default '',
  `filename` varchar(255) NOT NULL default '',
  `fileext` varchar(255) NOT NULL default '',
  `filesize` int(10) unsigned NOT NULL default '0',
  `created` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`file_id`,`good_id`),
  KEY `filesize` (`filesize`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- 
-- Дамп данных таблицы `catalogue_goods_files`
-- 


-- --------------------------------------------------------

-- 
-- Структура таблицы `catalogue_goods_pics`
-- 

DROP TABLE IF EXISTS `catalogue_goods_pics`;
CREATE TABLE IF NOT EXISTS `catalogue_goods_pics` (
  `picture_id` int(10) unsigned NOT NULL auto_increment,
  `good_id` int(10) unsigned NOT NULL default '0',
  `show_order` int(10) unsigned NOT NULL default '0',
  `good_picture` varchar(255) NOT NULL default '',
  `created` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`picture_id`),
  KEY `good_id` (`good_id`),
  KEY `show_order` (`show_order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- 
-- Дамп данных таблицы `catalogue_goods_pics`
-- 


-- --------------------------------------------------------

-- 
-- Структура таблицы `catalogue_links`
-- 

DROP TABLE IF EXISTS `catalogue_links`;
CREATE TABLE IF NOT EXISTS `catalogue_links` (
  `node_id` int(10) unsigned NOT NULL default '0',
  `view` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`node_id`,`view`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `catalogue_links`
-- 

INSERT INTO `catalogue_links` VALUES (3, 'list');

-- --------------------------------------------------------

-- 
-- Структура таблицы `catalogue_options`
-- 

DROP TABLE IF EXISTS `catalogue_options`;
CREATE TABLE IF NOT EXISTS `catalogue_options` (
  `option_id` int(10) unsigned NOT NULL auto_increment,
  `option_key` varchar(255) NOT NULL default '',
  `option_name` varchar(255) NOT NULL default '',
  `option_value` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`option_id`),
  UNIQUE KEY `option_key` (`option_key`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

-- 
-- Дамп данных таблицы `catalogue_options`
-- 

INSERT INTO `catalogue_options` VALUES (1, 'admin_email', 'E - mail администратора', '');
INSERT INTO `catalogue_options` VALUES (2, 'delivery_price', 'Стоимость срочной доставки', '700 рублей');

-- --------------------------------------------------------

-- 
-- Структура таблицы `catalogue_params`
-- 

DROP TABLE IF EXISTS `catalogue_params`;
CREATE TABLE IF NOT EXISTS `catalogue_params` (
  `param_id` int(10) unsigned NOT NULL auto_increment,
  `param_type` int(10) unsigned NOT NULL default '1',
  `param_name` varchar(255) NOT NULL default '',
  `param_data` text NOT NULL,
  PRIMARY KEY  (`param_id`),
  KEY `param_type` (`param_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- 
-- Дамп данных таблицы `catalogue_params`
-- 


-- --------------------------------------------------------

-- 
-- Структура таблицы `catalogue_params_types`
-- 

DROP TABLE IF EXISTS `catalogue_params_types`;
CREATE TABLE IF NOT EXISTS `catalogue_params_types` (
  `type_id` int(10) unsigned NOT NULL auto_increment,
  `type_sys` varchar(255) NOT NULL default '',
  `type_name` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`type_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

-- 
-- Дамп данных таблицы `catalogue_params_types`
-- 

INSERT INTO `catalogue_params_types` VALUES (1, 'string', 'Строка');
INSERT INTO `catalogue_params_types` VALUES (2, 'number', 'Число');
INSERT INTO `catalogue_params_types` VALUES (3, 'list', 'Список');

-- --------------------------------------------------------

-- 
-- Структура таблицы `catalogue_params_values`
-- 

DROP TABLE IF EXISTS `catalogue_params_values`;
CREATE TABLE IF NOT EXISTS `catalogue_params_values` (
  `good_id` int(10) unsigned NOT NULL default '0',
  `param_id` int(10) unsigned NOT NULL default '0',
  `param_value` text NOT NULL,
  PRIMARY KEY  (`good_id`,`param_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `catalogue_params_values`
-- 


-- --------------------------------------------------------

-- 
-- Структура таблицы `catalogue_preferences`
-- 

DROP TABLE IF EXISTS `catalogue_preferences`;
CREATE TABLE IF NOT EXISTS `catalogue_preferences` (
  `photogallery` enum('true','false') NOT NULL default 'false',
  `newest_count` int(10) unsigned NOT NULL default '3',
  `specs_count` int(10) unsigned NOT NULL default '3',
  `empty_cat_message` longtext NOT NULL,
  `empty_spec_pic` varchar(255) NOT NULL default '',
  `empty_newest_pic` varchar(255) NOT NULL default '',
  `empty_cat_pic` varchar(255) NOT NULL default '',
  `empty_good_pic` varchar(255) NOT NULL default '',
  `empty_good_item_pic` varchar(255) NOT NULL default '',
  `show_goods_from_subcats` enum('true','false') NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `catalogue_preferences`
-- 

INSERT INTO `catalogue_preferences` VALUES ('true', 3, 3, '<P>На данный момент в категории "{$cat_name}" товары отсутствуют. Приносим свои извинения за предоставленные неудобства.</P>', '', '', '', '', '', 'false');

-- --------------------------------------------------------

-- 
-- Структура таблицы `catalogue_preferences_thumbnails`
-- 

DROP TABLE IF EXISTS `catalogue_preferences_thumbnails`;
CREATE TABLE IF NOT EXISTS `catalogue_preferences_thumbnails` (
  `thumb_id` int(10) unsigned NOT NULL auto_increment,
  `thumb_name` varchar(255) NOT NULL default '',
  `hsize` int(10) unsigned NOT NULL default '0',
  `vsize` int(10) unsigned NOT NULL default '0',
  `show_order` int(10) unsigned NOT NULL default '1',
  `default_for_cat` enum('true','false') NOT NULL default 'false',
  `default_for_good` enum('true','false') NOT NULL default 'false',
  `default_for_newest` enum('true','false') NOT NULL default 'false',
  `default_for_specs` enum('true','false') NOT NULL default 'false',
  PRIMARY KEY  (`thumb_id`),
  KEY `show_order` (`show_order`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

-- 
-- Дамп данных таблицы `catalogue_preferences_thumbnails`
-- 

INSERT INTO `catalogue_preferences_thumbnails` VALUES (1, 'Уменьшенное изображение товара', 150, 150, 1, 'true', 'false', 'false', 'true');
INSERT INTO `catalogue_preferences_thumbnails` VALUES (2, 'Среднее изображение товара', 200, 200, 2, 'false', 'true', 'true', 'false');
INSERT INTO `catalogue_preferences_thumbnails` VALUES (6, 'Новый тип1', 200, 100, 4, 'false', 'false', 'false', 'false');
INSERT INTO `catalogue_preferences_thumbnails` VALUES (7, 'Новый тип12', 250, 100, 5, 'false', 'false', 'false', 'false');
INSERT INTO `catalogue_preferences_thumbnails` VALUES (5, 'Новый тип', 100, 100, 3, 'false', 'false', 'false', 'false');
INSERT INTO `catalogue_preferences_thumbnails` VALUES (8, 'Новый тип13', 400, 100, 6, 'false', 'false', 'false', 'false');

-- --------------------------------------------------------

-- 
-- Структура таблицы `catalogue_producers`
-- 

DROP TABLE IF EXISTS `catalogue_producers`;
CREATE TABLE IF NOT EXISTS `catalogue_producers` (
  `catalogue_producer_id` int(11) NOT NULL auto_increment,
  `catalogue_producer_title` varchar(255) NOT NULL default '',
  `catalogue_producer_logo` varchar(255) NOT NULL default '',
  `catalogue_producer_site` varchar(255) NOT NULL default '',
  `catalogue_producer_anons` text NOT NULL,
  `catalogue_producer_text` longtext NOT NULL,
  `owner_id` int(11) NOT NULL default '0',
  `catalogue_producer_publish` enum('Y','N') NOT NULL default 'N',
  `catalogue_producer_url` varchar(255) NOT NULL,
  PRIMARY KEY  (`catalogue_producer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- 
-- Дамп данных таблицы `catalogue_producers`
-- 


-- --------------------------------------------------------

-- 
-- Структура таблицы `content`
-- 

DROP TABLE IF EXISTS `content`;
CREATE TABLE IF NOT EXISTS `content` (
  `content_id` mediumint(9) NOT NULL auto_increment,
  `node_id` mediumint(9) NOT NULL default '0',
  `template_id` mediumint(9) NOT NULL default '0',
  `content_label` varchar(255) NOT NULL default '',
  `content_data` text NOT NULL,
  PRIMARY KEY  (`content_id`),
  KEY `node_id` (`node_id`),
  KEY `content_label` (`content_label`)
) ENGINE=MyISAM AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 PACK_KEYS=0 AUTO_INCREMENT=34 ;

-- 
-- Дамп данных таблицы `content`
-- 

INSERT INTO `content` VALUES (17, 6, 46, 'HANDY_LABEL_CENTER_RIGHT', '<extension><uniqid>4b7ae0620a320</uniqid><name>sitemap</name><current_node_id>6</current_node_id></extension>');
INSERT INTO `content` VALUES (18, 2, 42, 'HANDY_LABEL_LEFT_TOP', '<extension><uniqid>4c35e4fdb9caa</uniqid><name>textblocks</name><current_node_id>2</current_node_id><params><view>default</view><block_id>2</block_id><show_title_for_block>true</show_title_for_block></params></extension>');
INSERT INTO `content` VALUES (3, 2, 42, 'HANDY_LABEL_RIGHT_TOP', '<extension><uniqid>4b7adc15dce84</uniqid><name>textblocks</name><current_node_id>2</current_node_id><params><view>default</view><block_id>1</block_id><show_title_for_block>true</show_title_for_block></params></extension>');
INSERT INTO `content` VALUES (19, 2, 42, 'HANDY_LABEL_BLOCK1', '<extension><uniqid>4c35e770b9cab</uniqid><name>textblocks</name><current_node_id>2</current_node_id><params><view>default</view><block_id>3</block_id><show_title_for_block>true</show_title_for_block></params></extension>');
INSERT INTO `content` VALUES (20, 2, 42, 'HANDY_LABEL_BLOCK2', '<extension><uniqid>4c35e7ff5e3d3</uniqid><name>textblocks</name><current_node_id>2</current_node_id><params><view>default</view><block_id>4</block_id><show_title_for_block>true</show_title_for_block></params></extension>');
INSERT INTO `content` VALUES (21, 2, 42, 'HANDY_LABEL_BLOCK3', '<extension><uniqid>4c35e845c53c5</uniqid><name>textblocks</name><current_node_id>2</current_node_id><params><view>default</view><block_id>5</block_id><show_title_for_block>true</show_title_for_block></params></extension>');
INSERT INTO `content` VALUES (22, 2, 42, 'HANDY_LABEL_CENTER_RIGHT', '<extension><uniqid>4c35e89b65de5</uniqid><name>textblocks</name><current_node_id>2</current_node_id><params><view>default</view><block_id>6</block_id><show_title_for_block>true</show_title_for_block></params></extension><extension><uniqid>4cbde568a737b</uniqid><name>newsgroups</name><current_node_id>2</current_node_id><params><view>last_news</view><news_count>2</news_count><link_id>4</link_id></params></extension>');
INSERT INTO `content` VALUES (28, 20, 46, 'HANDY_LABEL_CENTER_RIGHT', '<extension><name>newsgroups</name><params><include>27.4cbde1f883006</include><view>list</view><page>{$1}</page></params></extension>');
INSERT INTO `content` VALUES (29, 21, 46, 'HANDY_LABEL_CENTER_RIGHT', '<extension><name>newsgroups</name><params><include>27.4cbde1f883006</include><view>item</view><news_id>{$1}</news_id></params></extension>');
INSERT INTO `content` VALUES (30, 5, 46, 'HANDY_LABEL_CENTER_RIGHT', '<extension><uniqid>4cbde5a8cd779</uniqid><name>newsgroups</name><current_node_id>5</current_node_id><params><view>list</view><count_per_page>10</count_per_page><group_id>1</group_id></params><kill_pages>22,23</kill_pages></extension>');
INSERT INTO `content` VALUES (27, 12, 46, 'HANDY_LABEL_CENTER_RIGHT', '<extension><uniqid>4cbde1f883006</uniqid><name>newsgroups</name><current_node_id>12</current_node_id><params><view>list</view><count_per_page>10</count_per_page><group_id>2</group_id></params><kill_pages>20,21</kill_pages></extension>');
INSERT INTO `content` VALUES (12, 9, 46, 'HANDY_LABEL_CENTER_RIGHT', '<extension><uniqid>4b7addd64b502</uniqid><name>search</name><current_node_id>9</current_node_id></extension>');
INSERT INTO `content` VALUES (31, 22, 46, 'HANDY_LABEL_CENTER_RIGHT', '<extension><name>newsgroups</name><params><include>30.4cbde5a8cd779</include><view>list</view><page>{$1}</page></params></extension>');
INSERT INTO `content` VALUES (32, 23, 46, 'HANDY_LABEL_CENTER_RIGHT', '<extension><name>newsgroups</name><params><include>30.4cbde5a8cd779</include><view>item</view><news_id>{$1}</news_id></params></extension>');
INSERT INTO `content` VALUES (33, 2, 42, 'HANDY_LABEL_LEFT', '<extension><uniqid>4cbde8bd74dec</uniqid><name>newsgroups</name><current_node_id>2</current_node_id><params><view>last_news</view><news_count>3</news_count><link_id>5</link_id></params></extension>');
INSERT INTO `content` VALUES (26, 4, 46, 'HANDY_LABEL_CENTER_RIGHT', '<extension><uniqid>4cb989fd39c18</uniqid><name>forms</name><current_node_id>4</current_node_id><params><view>default</view><form_id>27</form_id></params></extension>');

-- --------------------------------------------------------

-- 
-- Структура таблицы `content_rels`
-- 

DROP TABLE IF EXISTS `content_rels`;
CREATE TABLE IF NOT EXISTS `content_rels` (
  `extension_id` int(10) unsigned NOT NULL,
  `content_id` int(10) unsigned NOT NULL,
  KEY `extension_id` (`extension_id`,`content_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `content_rels`
-- 

INSERT INTO `content_rels` VALUES (4, 3);
INSERT INTO `content_rels` VALUES (4, 18);
INSERT INTO `content_rels` VALUES (4, 19);
INSERT INTO `content_rels` VALUES (4, 20);
INSERT INTO `content_rels` VALUES (4, 21);
INSERT INTO `content_rels` VALUES (4, 22);
INSERT INTO `content_rels` VALUES (5, 26);
INSERT INTO `content_rels` VALUES (9, 17);
INSERT INTO `content_rels` VALUES (15, 22);
INSERT INTO `content_rels` VALUES (15, 27);
INSERT INTO `content_rels` VALUES (15, 28);
INSERT INTO `content_rels` VALUES (15, 29);
INSERT INTO `content_rels` VALUES (15, 30);
INSERT INTO `content_rels` VALUES (15, 31);
INSERT INTO `content_rels` VALUES (15, 32);
INSERT INTO `content_rels` VALUES (15, 33);
INSERT INTO `content_rels` VALUES (78, 12);

-- --------------------------------------------------------

-- 
-- Структура таблицы `extensions`
-- 

DROP TABLE IF EXISTS `extensions`;
CREATE TABLE IF NOT EXISTS `extensions` (
  `extension_id` int(10) unsigned NOT NULL auto_increment,
  `extension_sysname` varchar(255) NOT NULL default '',
  `extension_name` varchar(255) NOT NULL default '',
  `extension_system` enum('false','true') NOT NULL default 'false',
  `extension_link` enum('false','true') NOT NULL default 'false',
  `extension_admin` enum('false','true') NOT NULL default 'false',
  `extension_update_available` enum('false','true') NOT NULL default 'false',
  `extension_developer` varchar(255) NOT NULL default '',
  `extension_version` varchar(255) NOT NULL default '',
  `extension_build_date` varchar(255) NOT NULL default '',
  `extension_show_always` enum('false','true') NOT NULL default 'false',
  `uninstall_sql` text NOT NULL,
  PRIMARY KEY  (`extension_id`),
  UNIQUE KEY `extension_sysname` (`extension_sysname`),
  KEY `extension_admin` (`extension_admin`),
  KEY `extension_system` (`extension_system`),
  KEY `extension_update_available` (`extension_update_available`),
  KEY `extension_link` (`extension_link`)
) ENGINE=MyISAM AUTO_INCREMENT=79 DEFAULT CHARSET=utf8 PACK_KEYS=0 AUTO_INCREMENT=79 ;

-- 
-- Дамп данных таблицы `extensions`
-- 

INSERT INTO `extensions` VALUES (1, 'sitemanager', 'Управление сайтом', 'true', 'false', 'false', 'false', 'Студия дизайна ''Obsudim''', '1.0', '12.10.2007', 'false', '');
INSERT INTO `extensions` VALUES (2, 'extmanager', 'Менеджер расширений', 'false', 'false', 'false', 'false', 'Студия дизайна ''Obsudim''', '1.0', '12.10.2007', 'false', '');
INSERT INTO `extensions` VALUES (3, 'administrators', 'Администраторы', 'false', 'false', 'true', 'false', 'Студия дизайна ''Obsudim''', '1.0', '12.10.2007', 'false', '');
INSERT INTO `extensions` VALUES (8, 'systempreferences', 'Настройки системы', 'false', 'false', 'false', 'false', 'Студия дизайна ''Obsudim''', '1.0', '12.10.2007', 'false', '');
INSERT INTO `extensions` VALUES (9, 'sitemap', 'Карта сайта', 'false', 'true', 'false', 'false', 'Студия дизайна ''Obsudim''', '1.0', '12.10.2007', 'false', '');
INSERT INTO `extensions` VALUES (10, 'usermenus', 'Пользовательские меню', 'false', 'false', 'true', 'false', 'Студия дизайна ''Obsudim''', '1.0', '08.09.2008', 'true', '');
INSERT INTO `extensions` VALUES (4, 'textblocks', 'Текстовые блоки', 'false', 'true', 'true', 'false', 'Студия дизайна ''Obsudim''', '1.0', '12.10.2007', 'false', '');
INSERT INTO `extensions` VALUES (5, 'forms', 'Формы', 'false', 'true', 'true', 'false', 'Студия дизайна ''Obsudim''', '1.0', '12.01.2008', 'false', '');
INSERT INTO `extensions` VALUES (15, 'newsgroups', 'Материалы', 'false', 'true', 'true', 'false', 'Студия дизайна "Obsudim"', '1.0', '12.10.2007', 'false', '');
INSERT INTO `extensions` VALUES (24, 'users', 'Пользователи', 'true', 'true', 'true', 'true', 'Студия дизайна Obsudim', '1.0', '02.09.2009', 'true', '');
INSERT INTO `extensions` VALUES (6, 'spider', 'Индексатор сайта', 'false', 'false', 'false', 'false', 'Студия дизайна ''Obsudim''', '1.0', '07.02.2010', 'false', '');
INSERT INTO `extensions` VALUES (78, 'search', 'Поиск по сайту', 'false', 'true', 'false', 'false', 'Студия дизайна ''Obsudim''', '1.0', '08.02.2010', 'false', '');

-- --------------------------------------------------------

-- 
-- Структура таблицы `extensions_events`
-- 

DROP TABLE IF EXISTS `extensions_events`;
CREATE TABLE IF NOT EXISTS `extensions_events` (
  `event_id` int(10) unsigned NOT NULL auto_increment,
  `extension_id` int(10) unsigned NOT NULL default '0',
  `event_sysname` varchar(255) NOT NULL default '',
  `event_name` varchar(255) NOT NULL default '',
  `event_type` enum('admin','users') NOT NULL default 'admin',
  PRIMARY KEY  (`event_id`),
  KEY `event_sysname` (`event_sysname`),
  KEY `extension_id` (`extension_id`)
) ENGINE=MyISAM AUTO_INCREMENT=592 DEFAULT CHARSET=utf8 AUTO_INCREMENT=592 ;

-- 
-- Дамп данных таблицы `extensions_events`
-- 

INSERT INTO `extensions_events` VALUES (28, 8, 'lang_versions', 'Языковые версии', 'admin');
INSERT INTO `extensions_events` VALUES (29, 8, 'templates', 'Редактирование шаблонов', 'admin');
INSERT INTO `extensions_events` VALUES (30, 7, 'faq', 'Чтение разделов FAQ', 'admin');
INSERT INTO `extensions_events` VALUES (31, 7, 'support', 'Техническая поддержка', 'admin');
INSERT INTO `extensions_events` VALUES (32, 3, 'groups', 'Создание / удаление / редактирование групп', 'admin');
INSERT INTO `extensions_events` VALUES (33, 3, 'admins', 'Создание / удаление / редактирование администраторов', 'admin');
INSERT INTO `extensions_events` VALUES (35, 1, 'edit_content', 'Редактирование наполнения', 'admin');
INSERT INTO `extensions_events` VALUES (36, 1, 'edit_extra', 'Редактирование дополнительных свойств', 'admin');
INSERT INTO `extensions_events` VALUES (575, 15, 'create_groups', 'Создание групп материалов', 'admin');
INSERT INTO `extensions_events` VALUES (576, 15, 'create_news', 'Создание материалов в группах', 'admin');
INSERT INTO `extensions_events` VALUES (577, 15, 'edit_news', 'Редактирование материала', 'admin');
INSERT INTO `extensions_events` VALUES (578, 5, 'validator', 'Создание / удаление значениями валидации для форм', 'admin');
INSERT INTO `extensions_events` VALUES (579, 24, 'users_group_add', 'Создание /редактирование / удаление групп пользователей', 'admin');
INSERT INTO `extensions_events` VALUES (580, 24, 'users_add', 'Создание / редактирование / удаление пользователей', 'admin');
INSERT INTO `extensions_events` VALUES (589, 8, 'robots_txt', 'Редактирование robots.txt', 'admin');
INSERT INTO `extensions_events` VALUES (590, 5, 'form_styles', 'Создание / удаление стилей форм', 'admin');
INSERT INTO `extensions_events` VALUES (591, 5, 'forms_templates', 'Создание / удаление шаблонов форм', 'admin');

-- --------------------------------------------------------

-- 
-- Структура таблицы `extensions_links`
-- 

DROP TABLE IF EXISTS `extensions_links`;
CREATE TABLE IF NOT EXISTS `extensions_links` (
  `extension_sysname` varchar(255) default NULL,
  `extension_object_id` tinyint(4) default NULL,
  `node_id` int(11) NOT NULL,
  `extension_view` varchar(255) NOT NULL,
  UNIQUE KEY `extension_object_id` (`extension_object_id`,`node_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `extensions_links`
-- 


-- --------------------------------------------------------

-- 
-- Структура таблицы `extensions_params`
-- 

DROP TABLE IF EXISTS `extensions_params`;
CREATE TABLE IF NOT EXISTS `extensions_params` (
  `param_id` mediumint(9) NOT NULL auto_increment,
  `view_id` mediumint(9) default NULL,
  `param_sysname` varchar(255) NOT NULL default '',
  `param_name` varchar(255) default NULL,
  `param_type` enum('reference','int','simple','sql') NOT NULL default 'simple',
  `param_data` varchar(255) NOT NULL default '',
  `query` text NOT NULL,
  PRIMARY KEY  (`param_id`),
  KEY `view_id` (`view_id`)
) ENGINE=MyISAM AUTO_INCREMENT=614 DEFAULT CHARSET=utf8 AUTO_INCREMENT=614 ;

-- 
-- Дамп данных таблицы `extensions_params`
-- 

INSERT INTO `extensions_params` VALUES (151, 9, 'block_id', 'Текстовый блок', 'reference', 'text_blocks_groups.group_id@group_id=group_name=Выберите группу:,text_blocks_data.group_id@block_id=block_title=Выберите текстовый блок:', '');
INSERT INTO `extensions_params` VALUES (595, 625, 'page_count', 'Страница', 'int', '', '');
INSERT INTO `extensions_params` VALUES (596, 629, 'form_id', 'Форма', 'reference', 'forms.form_id:forms.reserved<>"true"@form_id=form_name=Выберите форму:', '');
INSERT INTO `extensions_params` VALUES (599, 5, 'date_format', 'Формат даты', 'reference', 'preferences_dates_format.format_id@format_id=format_name=Формат даты:', '');
INSERT INTO `extensions_params` VALUES (609, 630, 'count_per_page', 'Количество материалов на страницу', 'int', '10', '');
INSERT INTO `extensions_params` VALUES (610, 6, 'news_id', 'Материал', 'reference', 'news_groups.group_id@group_id=group_name=Выберите группу материалов:,news_data.group_id@news_id=news_title=Выберите материал:', '');
INSERT INTO `extensions_params` VALUES (611, 630, 'group_id', 'Группа материалов', 'reference', 'news_groups.group_id@group_id=group_name=Выберите группу материалов:', '');
INSERT INTO `extensions_params` VALUES (612, 631, 'news_count', 'Количество выводимых материалов', 'int', '10', '');
INSERT INTO `extensions_params` VALUES (613, 631, 'link_id', 'Группа материалов', 'sql', '', 'SELECT\r\n	news_links.link_id AS result_value,\r\n	CONCAT(\r\n		news_groups.group_name,\r\n		'' ('',\r\n		nodes.node_scheme,\r\n		'')''\r\n	) AS display_value\r\n	FROM news_links\r\n	LEFT JOIN news_groups ON ( news_groups.group_id = news_links.group_id )\r\n	LEFT JOIN nodes ON ( nodes.node_id = news_links.node_id )');

-- --------------------------------------------------------

-- 
-- Структура таблицы `extensions_settings`
-- 

DROP TABLE IF EXISTS `extensions_settings`;
CREATE TABLE IF NOT EXISTS `extensions_settings` (
  `extension_settings_id` int(11) NOT NULL auto_increment,
  `extension_sysname` varchar(50) default NULL,
  `setting_name` varchar(255) NOT NULL,
  `setting_title` varchar(255) NOT NULL,
  `setting_value` varchar(255) NOT NULL,
  `setting_dim` varchar(255) NOT NULL,
  `setting_position` tinyint(3) default '0',
  PRIMARY KEY  (`extension_settings_id`),
  UNIQUE KEY `extension_sysname` (`extension_sysname`,`setting_name`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

-- 
-- Дамп данных таблицы `extensions_settings`
-- 

INSERT INTO `extensions_settings` VALUES (1, 'spider', 'index_meta_keywords', 'Индексировать слова из META-поля Keywords', '1', '1  - да, 0 - нет', 0);
INSERT INTO `extensions_settings` VALUES (2, 'spider', 'min_word_length', 'Минимальная длина слова для индексации', '1', '1  - да, 0 - нет', 0);
INSERT INTO `extensions_settings` VALUES (3, 'spider', 'index_numbers', 'Индексировать числа', '1', '1  - да, 0 - нет', 0);
INSERT INTO `extensions_settings` VALUES (4, 'spider', 'strip_sessids', 'Удалять указатель сессии (SESSID) из URL', '1', '1  - да, 0 - нет', 0);
INSERT INTO `extensions_settings` VALUES (5, 'spider', 'title_weight', 'Вес слова в META-поле Title', '50', '', 0);
INSERT INTO `extensions_settings` VALUES (6, 'spider', 'meta_weight', 'Вес слова в META-поле Keywords', '20', '', 0);
INSERT INTO `extensions_settings` VALUES (7, 'spider', 'reindex', 'Переиндексировать проиндексированные страницы при повторной индексации', '1', '', 0);
INSERT INTO `extensions_settings` VALUES (8, 'spider', 'word_upper_bound', 'Максимальный вес слова', '100', '', 0);
INSERT INTO `extensions_settings` VALUES (9, 'spider', 'ignore_robots_txt', 'Индексировать запрещенные в robots.txt страницы', '1', '1  - да, 0 - нет', 0);
INSERT INTO `extensions_settings` VALUES (10, 'spider', 'word_lenght', 'Максимальная длина слова для индексации', '30', '', 0);

-- --------------------------------------------------------

-- 
-- Структура таблицы `extensions_templates`
-- 

DROP TABLE IF EXISTS `extensions_templates`;
CREATE TABLE IF NOT EXISTS `extensions_templates` (
  `extensions_template_id` int(11) NOT NULL auto_increment,
  `extensions_template_title` varchar(255) NOT NULL,
  `extensions_template_filename` varchar(255) NOT NULL,
  `extension_sysname` varchar(255) default NULL,
  `owner_id` int(11) NOT NULL,
  `extensions_template_default` enum('Y','N') NOT NULL default 'N',
  PRIMARY KEY  (`extensions_template_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

-- 
-- Дамп данных таблицы `extensions_templates`
-- 

INSERT INTO `extensions_templates` VALUES (1, 'Общий шаблон форм', '', 'forms', 10, 'Y');
INSERT INTO `extensions_templates` VALUES (2, 'Мы вам перезвоним', 'recall', 'forms', 10, 'N');
INSERT INTO `extensions_templates` VALUES (3, 'Новости', 'list', 'newsgroups', 0, 'Y');
INSERT INTO `extensions_templates` VALUES (5, 'Статьи', 'articles', 'newsgroups', 0, 'N');

-- --------------------------------------------------------

-- 
-- Структура таблицы `extensions_updates`
-- 

DROP TABLE IF EXISTS `extensions_updates`;
CREATE TABLE IF NOT EXISTS `extensions_updates` (
  `update_id` int(10) unsigned NOT NULL default '0',
  `module_name` varchar(255) NOT NULL,
  `module_sysname` varchar(255) NOT NULL,
  `module_version` varchar(255) NOT NULL,
  `update_type` enum('critical','ordinary') NOT NULL default 'ordinary',
  `update_date` date NOT NULL default '0000-00-00',
  `update_download_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `update_description` text NOT NULL,
  `module_full_name` varchar(255) NOT NULL,
  `handy_build` int(11) default NULL,
  PRIMARY KEY  (`update_id`),
  KEY `update_download_date` (`update_download_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `extensions_updates`
-- 


-- --------------------------------------------------------

-- 
-- Структура таблицы `extensions_updates_downloads`
-- 

DROP TABLE IF EXISTS `extensions_updates_downloads`;
CREATE TABLE IF NOT EXISTS `extensions_updates_downloads` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `update_id` int(10) unsigned NOT NULL default '0',
  `filename` varchar(255) NOT NULL default '',
  `description` text NOT NULL,
  `module_full_name` varchar(255) default NULL,
  `update_date` date NOT NULL,
  `download_date` date default NULL,
  `module_sysname` varchar(255) NOT NULL,
  `module_version` varchar(255) NOT NULL,
  `module_name` varchar(255) NOT NULL,
  `update_type` enum('critical','ordinary') NOT NULL,
  `handy_build` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `update_id` (`update_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 PACK_KEYS=0 AUTO_INCREMENT=1 ;

-- 
-- Дамп данных таблицы `extensions_updates_downloads`
-- 


-- --------------------------------------------------------

-- 
-- Структура таблицы `extensions_updates_installed`
-- 

DROP TABLE IF EXISTS `extensions_updates_installed`;
CREATE TABLE IF NOT EXISTS `extensions_updates_installed` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `update_id` int(10) unsigned NOT NULL default '0',
  `filename` varchar(255) NOT NULL default '',
  `description` text NOT NULL,
  `update_date` date NOT NULL,
  `install_date` datetime NOT NULL,
  `module_full_name` varchar(255) NOT NULL,
  `module_sysname` varchar(255) NOT NULL,
  `module_version` varchar(255) NOT NULL,
  `module_name` varchar(255) NOT NULL,
  `update_type` enum('critical','ordinary') NOT NULL,
  `update_installed` enum('Y','N') default 'N',
  `handy_build` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `update_id` (`update_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- 
-- Дамп данных таблицы `extensions_updates_installed`
-- 


-- --------------------------------------------------------

-- 
-- Структура таблицы `extensions_vers_rels`
-- 

DROP TABLE IF EXISTS `extensions_vers_rels`;
CREATE TABLE IF NOT EXISTS `extensions_vers_rels` (
  `lang_version_id` int(10) unsigned NOT NULL default '0',
  `extension_id` int(10) unsigned NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `extensions_vers_rels`
-- 

INSERT INTO `extensions_vers_rels` VALUES (1, 5);
INSERT INTO `extensions_vers_rels` VALUES (1, 9);
INSERT INTO `extensions_vers_rels` VALUES (1, 4);

-- --------------------------------------------------------

-- 
-- Структура таблицы `extensions_views`
-- 

DROP TABLE IF EXISTS `extensions_views`;
CREATE TABLE IF NOT EXISTS `extensions_views` (
  `view_id` mediumint(9) NOT NULL auto_increment,
  `extension_id` mediumint(9) default NULL,
  `view_sysname` varchar(255) default NULL,
  `view_name` varchar(255) NOT NULL default '',
  `view_default` enum('true','false') NOT NULL default 'false',
  PRIMARY KEY  (`view_id`),
  UNIQUE KEY `extension_id` (`extension_id`,`view_sysname`)
) ENGINE=MyISAM AUTO_INCREMENT=633 DEFAULT CHARSET=utf8 AUTO_INCREMENT=633 ;

-- 
-- Дамп данных таблицы `extensions_views`
-- 

INSERT INTO `extensions_views` VALUES (9, 4, 'default', 'Вид по умолчанию', 'false');
INSERT INTO `extensions_views` VALUES (629, 5, 'default', 'Вид по умолчанию', 'true');
INSERT INTO `extensions_views` VALUES (6, 15, 'item_alone', 'Отдельный материал', 'false');
INSERT INTO `extensions_views` VALUES (630, 15, 'list', 'Список материалов', 'true');
INSERT INTO `extensions_views` VALUES (631, 15, 'last_news', 'Последние материалы группы', 'false');
INSERT INTO `extensions_views` VALUES (632, 24, 'registration', 'Регистрация пользователя', 'true');

-- --------------------------------------------------------

-- 
-- Структура таблицы `extensions_views_rewrite`
-- 

DROP TABLE IF EXISTS `extensions_views_rewrite`;
CREATE TABLE IF NOT EXISTS `extensions_views_rewrite` (
  `rewrite_rule_id` int(10) unsigned NOT NULL auto_increment,
  `view_id` int(10) unsigned NOT NULL default '0',
  `rewrite_node_name` varchar(255) NOT NULL default '',
  `rewrite_rule` varchar(255) NOT NULL default '',
  `rewrite_rule_length` tinyint(3) unsigned NOT NULL default '0',
  `rewrite_rule_validate` enum('true','false') NOT NULL default 'false',
  `content_view` varchar(255) NOT NULL,
  `data` text NOT NULL,
  PRIMARY KEY  (`rewrite_rule_id`),
  KEY `view_id` (`view_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

-- 
-- Дамп данных таблицы `extensions_views_rewrite`
-- 

INSERT INTO `extensions_views_rewrite` VALUES (1, 630, '#page_id', 'page([0-9]+)', 1, 'true', 'list', '<page>{$1}</page>');
INSERT INTO `extensions_views_rewrite` VALUES (2, 630, '#news_id', '([0-9]+)\\.html', 1, 'true', 'item', '<news_id>{$1}</news_id>');
INSERT INTO `extensions_views_rewrite` VALUES (4, 632, '#hash', 'reg_code(.+)', 1, 'true', 'registration', '<hash>{$1}</hash>');

-- --------------------------------------------------------

-- 
-- Структура таблицы `forms`
-- 

DROP TABLE IF EXISTS `forms`;
CREATE TABLE IF NOT EXISTS `forms` (
  `form_id` int(10) unsigned NOT NULL auto_increment,
  `form_name` varchar(255) NOT NULL,
  `form_email` varchar(255) NOT NULL,
  `email_subject` varchar(255) NOT NULL,
  `email_encoding` int(10) unsigned NOT NULL,
  `owner_id` int(11) NOT NULL,
  `reserved` enum('true','false') NOT NULL default 'false',
  `form_type` varchar(255) NOT NULL,
  `form_sent_text` varchar(255) NOT NULL,
  `extensions_template_id` int(11) NOT NULL,
  `form_start_time` time default NULL,
  `form_end_time` time default NULL,
  `form_use_time` enum('Y','N') NOT NULL default 'N',
  `captcha` enum('Y','N') NOT NULL default 'N',
  PRIMARY KEY  (`form_id`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8 AUTO_INCREMENT=31 ;

-- 
-- Дамп данных таблицы `forms`
-- 

INSERT INTO `forms` VALUES (27, 'Обратная связь', 'info@DOMAIN_NAME', 'Обратная связь с сайта {$site}', 3, 1, 'false', '', '', 1, NULL, NULL, 'N', 'Y');
INSERT INTO `forms` VALUES (28, 'Регистрация пользователя', 'info@DOMAIN_NAME', 'Сообщение с сайта {$site}', 3, 1, 'true', 'registration', 'Регистрационные данные успешно отправлены. В ближайшее время Вам на почту придут коды подтверждения регистрации. Для завершения регистрации, перейдите по указанной в письме ссылке.', 1, NULL, NULL, 'N', 'N');

-- --------------------------------------------------------

-- 
-- Структура таблицы `forms_fields`
-- 

DROP TABLE IF EXISTS `forms_fields`;
CREATE TABLE IF NOT EXISTS `forms_fields` (
  `field_id` int(10) unsigned NOT NULL auto_increment,
  `form_id` int(10) unsigned NOT NULL,
  `show_order` int(10) unsigned NOT NULL,
  `field_name` varchar(255) NOT NULL,
  `field_type` enum('text','textarea','radio','checkbox','list') NOT NULL default 'text',
  `field_data` text NOT NULL,
  `forms_validator_id` tinyint(4) default '0',
  `field_required` enum('Y','N') NOT NULL default 'N',
  `field_system` enum('Y','N') NOT NULL default 'N',
  `field_match` tinyint(4) default '0',
  `field_show` enum('Y','N') NOT NULL default 'Y',
  `field_system_name` varchar(255) default NULL,
  `field_validation` varchar(255) NOT NULL,
  `forms_fields_style_id` tinyint(4) default '1',
  PRIMARY KEY  (`field_id`),
  KEY `form_id` (`form_id`),
  KEY `show_order` (`show_order`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 AUTO_INCREMENT=20 ;

-- 
-- Дамп данных таблицы `forms_fields`
-- 

INSERT INTO `forms_fields` VALUES (1, 27, 4, 'Email', 'text', '', 2, 'Y', 'N', 0, 'Y', '', '', 7);
INSERT INTO `forms_fields` VALUES (2, 27, 3, 'Контактные телефоны', 'text', '', 0, 'Y', 'N', 0, 'Y', '', '', 7);
INSERT INTO `forms_fields` VALUES (14, 27, 5, 'Подробности заказа', 'textarea', '', 0, 'Y', 'N', 0, 'Y', NULL, '', 0);
INSERT INTO `forms_fields` VALUES (13, 27, 1, 'ФИО', 'text', '', 0, 'Y', 'N', 0, 'Y', NULL, '', 9);
INSERT INTO `forms_fields` VALUES (6, 28, 1, 'Логин', 'text', '', 0, 'Y', 'N', 0, 'Y', 'login', 'users', 1);
INSERT INTO `forms_fields` VALUES (7, 28, 2, 'Пароль', 'text', '', 0, 'Y', 'N', 0, 'N', 'password', '', 1);
INSERT INTO `forms_fields` VALUES (8, 28, 3, 'Подтверждение пароля', 'text', '', 0, 'Y', 'Y', 7, 'N', '', '', 1);
INSERT INTO `forms_fields` VALUES (9, 28, 4, 'Имя', 'text', '', 0, 'Y', 'N', 0, 'Y', 'name', '', 1);
INSERT INTO `forms_fields` VALUES (10, 28, 5, 'Фамилия', 'text', '', 0, 'Y', 'N', 0, 'Y', 'surname', '', 1);
INSERT INTO `forms_fields` VALUES (11, 28, 9, 'E-mail', 'text', '', 2, 'Y', 'N', 0, 'Y', 'email', '', 1);
INSERT INTO `forms_fields` VALUES (12, 28, 6, 'Отчество', 'text', '', 0, 'Y', 'N', 0, 'Y', 'patronymic', '', 1);
INSERT INTO `forms_fields` VALUES (15, 27, 2, 'Компания', 'text', '', 0, 'Y', 'N', 0, 'Y', NULL, '', 7);
INSERT INTO `forms_fields` VALUES (16, 28, 7, 'Компания', 'text', '', 0, 'Y', 'N', 0, 'Y', NULL, '', 1);
INSERT INTO `forms_fields` VALUES (17, 28, 8, 'Телефон', 'text', '', 0, 'Y', 'N', 0, 'Y', NULL, '', 1);

-- --------------------------------------------------------

-- 
-- Структура таблицы `forms_fields_styles`
-- 

DROP TABLE IF EXISTS `forms_fields_styles`;
CREATE TABLE IF NOT EXISTS `forms_fields_styles` (
  `forms_fields_style_id` int(11) NOT NULL auto_increment,
  `forms_fields_style_title` varchar(255) NOT NULL,
  `forms_fields_style_name` varchar(255) NOT NULL,
  `owner_id` int(11) NOT NULL,
  PRIMARY KEY  (`forms_fields_style_id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

-- 
-- Дамп данных таблицы `forms_fields_styles`
-- 

INSERT INTO `forms_fields_styles` VALUES (7, 'input средний', 'input_mid', 0);
INSERT INTO `forms_fields_styles` VALUES (8, 'input короткий', 'input_small', 0);
INSERT INTO `forms_fields_styles` VALUES (9, 'input длинный', 'input_big', 0);
INSERT INTO `forms_fields_styles` VALUES (10, 'radio button', 'radio', 0);

-- --------------------------------------------------------

-- 
-- Структура таблицы `forms_validators`
-- 

DROP TABLE IF EXISTS `forms_validators`;
CREATE TABLE IF NOT EXISTS `forms_validators` (
  `forms_validator_id` tinyint(4) NOT NULL auto_increment,
  `forms_validator_title` varchar(255) NOT NULL,
  `forms_validator_regex` varchar(255) default NULL,
  `owner_id` tinyint(4) NOT NULL,
  PRIMARY KEY  (`forms_validator_id`),
  KEY `forms_validator_id` (`forms_validator_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

-- 
-- Дамп данных таблицы `forms_validators`
-- 

INSERT INTO `forms_validators` VALUES (2, 'E-mail', '/^[-\\w.]{1,}+@([A-z0-9][-A-z0-9]+\\.)+[A-z]{2,}$/', 1);

-- --------------------------------------------------------

-- 
-- Структура таблицы `help_cache`
-- 

DROP TABLE IF EXISTS `help_cache`;
CREATE TABLE IF NOT EXISTS `help_cache` (
  `url` varchar(255) NOT NULL default '',
  `hash` varchar(255) NOT NULL default '',
  `data` text NOT NULL,
  PRIMARY KEY  (`url`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `help_cache`
-- 


-- --------------------------------------------------------

-- 
-- Структура таблицы `news_data`
-- 

DROP TABLE IF EXISTS `news_data`;
CREATE TABLE IF NOT EXISTS `news_data` (
  `news_id` int(10) unsigned NOT NULL auto_increment,
  `group_id` int(10) unsigned NOT NULL default '0',
  `owner_id` int(10) unsigned NOT NULL default '0',
  `news_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `picture` varchar(255) default NULL,
  `picture_hash` varchar(255) NOT NULL,
  `news_archive` enum('true','false') NOT NULL default 'false',
  `news_pub` enum('true','false') NOT NULL default 'false',
  `news_pub_always` enum('true','false') NOT NULL default 'false',
  `news_url` varchar(255) NOT NULL default '',
  `news_title` varchar(255) default NULL,
  `news_anounce` text,
  `news_text` text,
  `pub_start` datetime NOT NULL,
  `pub_end` datetime NOT NULL,
  `picture_format` varchar(5) NOT NULL default 'jpg',
  PRIMARY KEY  (`news_id`),
  KEY `group_id` (`group_id`,`news_pub`,`news_pub_always`,`news_archive`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

-- 
-- Дамп данных таблицы `news_data`
-- 

INSERT INTO `news_data` VALUES (1, 1, 1, '2010-02-16 20:59:43', NULL, '', 'false', 'true', 'true', '', 'Мы запустили новый сайт', 'Добро пожаловать на наш новый сайт, надеемся Вам у нас понравится!', 'Добро пожаловать на наш новый сайт, надеемся Вам у нас понравится! Пишите отзывы!', '2010-02-16 20:59:00', '2011-02-16 20:59:00', 'jpg');
INSERT INTO `news_data` VALUES (2, 1, 1, '2010-02-16 21:00:29', NULL, '', 'false', 'true', 'true', '', 'Снижение цен на наши услуги', 'Мы снизили цены на 10% - обращайтесь к нам.', 'Мы снизили цены на 10% - обращайтесь к нам.', '2010-02-16 21:00:00', '2011-02-16 21:00:00', 'jpg');
INSERT INTO `news_data` VALUES (3, 1, 1, '2010-02-16 21:01:04', NULL, '', 'false', 'true', 'true', '', 'Сезонные скидки', '<P>Рады сообщить Вам о начале сезонных скидок.</P>', '<P>Рады сообщить Вам о начале сезонных скидок. Спешите!</P>', '2010-02-16 21:00:00', '2011-02-16 21:00:00', 'jpg');
INSERT INTO `news_data` VALUES (4, 2, 1, '2010-07-08 19:28:00', NULL, '', 'false', 'true', 'true', '', 'Почему не критично управление брендом?', 'Интересноотметить,что традиционный канал сложен. Организация службы маркетинга просветляет канон биографии, так Г.Корф формулирует собственную антитезу. Целое образа концентрирует из ряда вон выходящий сегмент рынка, таким образом, все перечисленные признаки архетипа и мифа подтверждают, что действие механизмов мифотворчества сродни механизмам художественно-продуктивного мышления. ', '<P>Интересноотметить,что традиционный канал сложен. Организация службы маркетинга просветляет канон биографии, так Г.Корф формулирует собственную антитезу. Целое образа концентрирует из ряда вон выходящий сегмент рынка, таким образом, все перечисленные признаки архетипа и мифа подтверждают, что действие механизмов мифотворчества сродни механизмам художественно-продуктивного мышления. Интенция переворачивает неизменный ребрендинг, таким образом, сходные законы контрастирующего развития характерны и для процессов в психике. Лидерство в продажах притягивает тактический охват аудитории, так Г.Корф формулирует собственную антитезу. </P>\r\n<P>К тому же искусство готично нейтрализует стиль менеджмента, что-то подобное можно встретить в работах Ауэрбаха и Тандлера. Поэтому иррациональное в творчестве отталкивает декаданс, опираясь на опыт западных коллег. Действительно, объемная скидка имитирует незначительный хтонический миф, повышая конкуренцию. Рыночная ситуация изящно экономит монтаж, повышая конкуренцию. </P>\r\n<P>Семиотика искусства выстраивает принципвосприятия, осознав маркетинг как часть производства. Медиавес, не меняя концепции, изложенной выше, стремительно переворачивает культурный нишевый проект, отвоевывая рыночный сегмент. Мистерия, как бы это ни казалось парадоксальным, монотонно образует ролевой бренд, так Г.Корф формулирует собственную антитезу. Молодежная аудитория отталкивает рейтинг, опираясь на опыт западных коллег. </P>', '2010-07-08 19:15:00', '2011-07-08 19:15:00', 'jpg');
INSERT INTO `news_data` VALUES (5, 2, 1, '2010-07-08 19:39:27', NULL, '', 'false', 'true', 'true', '', 'Бессознательный этикет: гипотеза и теории', 'Героическое, не меняя концепции, изложенной выше, позиционирует потребительский рынок, таким образом, второй комплекс движущих сил получил разработку в трудах А.Берталанфи и Ш.Бюлера. Не факт, что художественное опосредование специфицирует метод кластерного анализа, опираясь на опыт западных коллег. ', '<P>Героическое, не меняя концепции, изложенной выше, позиционирует потребительский рынок, таким образом, второй комплекс движущих сил получил разработку в трудах А.Берталанфи и Ш.Бюлера. Не факт, что художественное опосредование специфицирует метод кластерного анализа, опираясь на опыт западных коллег. Стимулирование сбыта, согласно Ф.Котлеру, оправдывает сокращенный филогенез, именно об этом комплексе движущих сил писал З.Фрейд в теории сублимации. Производство, на первый взгляд, исключительно заканчивает инвестиционный продукт, опираясь на опыт западных коллег. Эволюция мерчандайзинга монотонно продуцирует связанный онтологический статус искусства, используя опыт предыдущих кампаний. </P>\r\n<P>Рекламная акция,врамкахсегодняшнихвоззрений, продуцирует фактографический хтонический миф, это же положение обосновывал Ж.Польти в книге "Тридцать шесть драматических ситуаций". Переходное состояние охватывает рыночный символизм, это же положение обосновывал Ж.Польти в книге "Тридцать шесть драматических ситуаций". Его экзистенциальная тоска выступает как побудительный мотив творчества, однако художественная богема свободна. Художественное опосредование,какпринятосчитать, образует бессознательный синтез искусств, расширяя долю рынка. </P>\r\n<P>Шиллер утверждал: медиапланирование специфицирует предмет искусства, учитывая современные тенденции. Игровое начало, безусловно, начинает эйдос, однако само по себе состояние игры всегда амбивалентно. Инвариант просветляет символический метафоризм, не считаясь с затратами. Художественная эпоха, не меняя концепции, изложенной выше, выстраивает персональный комплекс агрессивности, расширяя долю рынка. Портрет потребителя довольно хорошо сбалансирован. Привлечение аудитории реально ускоряет побочный PR-эффект, так Г.Корф формулирует собственную антитезу. </P>', '2010-06-01 19:38:00', '2011-07-08 19:38:00', 'jpg');
INSERT INTO `news_data` VALUES (6, 2, 1, '2010-07-08 19:39:15', NULL, '', 'false', 'true', 'true', '', 'Почему изоморфнавремени художественная богема?', 'Шиллер утверждал: выразительное трансформирует рейтинг, учитывая современные тенденции. Сангвиник транслирует сублимированный сегмент рынка, осознав маркетинг как часть производства. PR использует комплексный анализ ситуации, это же положение обосновывал Ж.Польти в книге "Тридцать шесть драматических ситуаций". ', '<P>Шиллер утверждал: выразительное трансформирует рейтинг, учитывая современные тенденции. Сангвиник транслирует сублимированный сегмент рынка, осознав маркетинг как часть производства. PR использует комплексный анализ ситуации, это же положение обосновывал Ж.Польти в книге "Тридцать шесть драматических ситуаций". Эротическое, вопреки мнению П.Друкера, спонтанно использует композиционный принцип артистизма, однако само по себе состояние игры всегда амбивалентно. </P>\r\n<P>Медиапланирование готично охватывает контент, однако само по себе состояние игры всегда амбивалентно. Клиентский спрос реально искажает коллективный катарсис, именно об этом комплексе движущих сил писал З.Фрейд в теории сублимации. Богатство мировой литературы от Платона до Ортеги-и-Гассета свидетельствует о том, что особенность рекламы стабилизирует креативный целевой трафик, полагаясь на инсайдерскую информацию. Каждая сфера рынка существенно начинает социометрический синтез искусств, именно об этом комплексе движущих сил писал З.Фрейд в теории сублимации. Поэтому фарс оправдывает эпитет, расширяя долю рынка. Стиль менеджмента,какследуетизвышесказанного, ускоряет направленный маркетинг, таким образом, все перечисленные признаки архетипа и мифа подтверждают, что действие механизмов мифотворчества сродни механизмам художественно-продуктивного мышления. </P>\r\n<P>Восприятие марки изящно позиционирует канон биографии, полагаясь на инсайдерскую информацию. CTR изящно вызывает процесс стратегического планирования, что-то подобное можно встретить в работах Ауэрбаха и Тандлера. Инструмент маркетинга имеет общественный медиавес, полагаясь на инсайдерскую информацию. Искусство как всегда непредсказуемо. Канон биографии, следовательно, заканчивает культурный базовый тип личности, повышая конкуренцию. </P>', '2010-07-04 19:38:00', '2011-07-08 19:38:00', 'jpg');
INSERT INTO `news_data` VALUES (7, 2, 1, '2010-07-08 19:40:14', NULL, '', 'false', 'true', 'true', '', 'Почему гармонично медиапланирование?', 'Нередуцируемость содержания нейтрализует экспрессионизм, именно об этом комплексе движущих сил писал З.Фрейд в теории сублимации. Онтогенез заканчивает суггестивный процесс стратегического планирования, это же положение обосновывал Ж.Польти в книге "Тридцать шесть драматических ситуаций". Аксиология интегрирована.', '<P>Нередуцируемость содержания нейтрализует экспрессионизм, именно об этом комплексе движущих сил писал З.Фрейд в теории сублимации. Онтогенез заканчивает суггестивный процесс стратегического планирования, это же положение обосновывал Ж.Польти в книге "Тридцать шесть драматических ситуаций". Аксиология интегрирована. Тем не менее, трагическое определяет медийный канал, однако само по себе состояние игры всегда амбивалентно. Целое образа неестественно дает суггестивный гений, учитывая современные тенденции. </P>\r\n<P>Системный анализ изящно выстраивает сублимированный монтаж, признавая определенные рыночные тенденции. Как отмечает Майкл Мескон, адекватная ментальность имеет феномер "психической мутации", таким образом, сходные законы контрастирующего развития характерны и для процессов в психике. Портрет потребителя, в том числе, изящно трансформирует невротический метод кластерного анализа, работая над проектом. Стимулирование сбыта конструктивно. </P>\r\n<P>Бессознательное поддерживает рекламный бриф, учитывая современные тенденции. Восприятие сотворчества заканчивает маньеризм, используя опыт предыдущих кампаний. Как предсказывают футурологи бизнес-стратегия отталкивает медиамикс, невзирая на действия конкурентов. Тем не менее, рекламное сообщество постоянно. Традиционный канал раскручивает суггестивный рейтинг, работая над проектом. Экспрессионизм изящно продолжает социометрический пресс-клиппинг, что-то подобное можно встретить в работах Ауэрбаха и Тандлера. </P>', '2010-06-07 19:39:00', '2011-07-08 19:39:00', 'jpg');

-- --------------------------------------------------------

-- 
-- Структура таблицы `news_groups`
-- 

DROP TABLE IF EXISTS `news_groups`;
CREATE TABLE IF NOT EXISTS `news_groups` (
  `group_id` int(10) unsigned NOT NULL auto_increment,
  `owner_id` int(10) unsigned NOT NULL default '0',
  `group_name` varchar(255) NOT NULL default '',
  `show_order` mediumint(9) NOT NULL default '0',
  `news_per_page` smallint(1) NOT NULL default '10',
  `list_link` varchar(255) NOT NULL default '',
  `template_id` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`group_id`),
  KEY `template_id` (`template_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

-- 
-- Дамп данных таблицы `news_groups`
-- 

INSERT INTO `news_groups` VALUES (1, 1, 'Новости', 0, 10, '', 3);
INSERT INTO `news_groups` VALUES (2, 1, 'Статьи', 0, 10, '', 5);

-- --------------------------------------------------------

-- 
-- Структура таблицы `news_links`
-- 

DROP TABLE IF EXISTS `news_links`;
CREATE TABLE IF NOT EXISTS `news_links` (
  `link_id` int(10) unsigned NOT NULL auto_increment,
  `group_id` int(10) unsigned NOT NULL default '0',
  `node_id` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`link_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 PACK_KEYS=0 AUTO_INCREMENT=6 ;

-- 
-- Дамп данных таблицы `news_links`
-- 

INSERT INTO `news_links` VALUES (5, 1, 5);
INSERT INTO `news_links` VALUES (4, 2, 12);

-- --------------------------------------------------------

-- 
-- Структура таблицы `news_preferences`
-- 

DROP TABLE IF EXISTS `news_preferences`;
CREATE TABLE IF NOT EXISTS `news_preferences` (
  `clean_html` enum('true','false') NOT NULL default 'false',
  `thumb_width` int(10) unsigned NOT NULL,
  `thumb_height` int(10) unsigned NOT NULL,
  `pic_width` int(10) unsigned NOT NULL,
  `pic_height` int(10) unsigned NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `news_preferences`
-- 

INSERT INTO `news_preferences` VALUES ('false', 150, 110, 640, 480);

-- --------------------------------------------------------

-- 
-- Структура таблицы `news_templates`
-- 

DROP TABLE IF EXISTS `news_templates`;
CREATE TABLE IF NOT EXISTS `news_templates` (
  `template_id` int(10) unsigned NOT NULL auto_increment,
  `template_name` varchar(255) NOT NULL default '',
  `template_filename` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`template_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

-- 
-- Дамп данных таблицы `news_templates`
-- 

INSERT INTO `news_templates` VALUES (1, 'Новости', 'news_list.tpl');
INSERT INTO `news_templates` VALUES (2, 'Акции', 'news_list.tpl');

-- --------------------------------------------------------

-- 
-- Структура таблицы `nodes`
-- 

DROP TABLE IF EXISTS `nodes`;
CREATE TABLE IF NOT EXISTS `nodes` (
  `node_id` int(10) unsigned NOT NULL auto_increment,
  `owner_id` int(10) unsigned NOT NULL default '0',
  `node_ancestor_id` int(10) unsigned NOT NULL default '0',
  `node_terminal` tinyint(1) unsigned NOT NULL default '1',
  `node_show_order` smallint(5) unsigned NOT NULL default '0',
  `node_level` tinyint(3) unsigned NOT NULL default '1',
  `node_scheme` varchar(255) NOT NULL default '',
  `node_type` enum('node','param') NOT NULL default 'node',
  `node_name` varchar(255) NOT NULL default '',
  `lang_version` enum('true','false') NOT NULL default 'false',
  `main_lang_page` enum('true','false') NOT NULL default 'false',
  `lang_version_name` varchar(50) NOT NULL default '',
  `lang_copyright` text NOT NULL,
  `site_name` varchar(255) NOT NULL default '',
  `default_template_id` int(10) unsigned NOT NULL default '0',
  `menu_title` varchar(255) NOT NULL default '',
  `page_title` varchar(255) NOT NULL default '',
  `redirect_url` varchar(255) NOT NULL default '',
  `meta_title` varchar(255) NOT NULL default '',
  `meta_keywords` varchar(255) NOT NULL default '',
  `meta_description` varchar(255) NOT NULL default '',
  `main_page` enum('false','true') NOT NULL default 'false',
  `show_in_menu` enum('false','true') NOT NULL default 'true',
  `hidden` enum('false','true') NOT NULL default 'false',
  `show_in_map` enum('false','true') NOT NULL default 'true',
  `pic_menu_noactive` varchar(255) NOT NULL default '',
  `pic_menu_active` varchar(255) NOT NULL default '',
  `pic_menu_header` varchar(255) NOT NULL default '',
  `template_id` int(10) unsigned NOT NULL default '0',
  `extension_id` int(5) NOT NULL,
  `access_permited` enum('true','false') NOT NULL default 'false',
  PRIMARY KEY  (`node_id`),
  UNIQUE KEY `node_scheme` (`node_scheme`),
  KEY `node_ancestor_id` (`node_ancestor_id`),
  KEY `node_show_order` (`node_show_order`,`node_level`),
  KEY `main_page` (`main_page`),
  KEY `lang_version` (`lang_version`),
  KEY `main_lang_page` (`main_lang_page`),
  KEY `show_in_menu` (`show_in_menu`),
  KEY `hidden` (`hidden`),
  KEY `node_type` (`node_type`),
  KEY `show_in_map` (`show_in_map`),
  KEY `default_template_id` (`default_template_id`)
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 PACK_KEYS=0 AUTO_INCREMENT=24 ;

-- 
-- Дамп данных таблицы `nodes`
-- 

INSERT INTO `nodes` VALUES (1, 1, 0, 0, 1, 0, '/DOMAIN_NAME/', 'node', '', 'true', 'false', 'Русский', '', '', 46, '', '', '', '', '', '', 'false', 'true', 'false', 'true', '', '', '', 42, 0, 'false');
INSERT INTO `nodes` VALUES (2, 1, 1, 1, 2, 1, '/DOMAIN_NAME/main/', 'node', 'main', 'false', 'false', '', '', '', 0, 'Главная страница', 'Главная страница', '', '', '', '', 'true', 'false', 'false', 'false', '', '', '', 42, 0, 'false');
INSERT INTO `nodes` VALUES (3, 1, 1, 0, 3, 1, '/DOMAIN_NAME/about/', 'node', 'about', 'false', 'false', '', '', '', 0, 'О компании', '', '', '', '', '', 'false', 'true', 'false', 'true', '', '', '', 46, 0, 'false');
INSERT INTO `nodes` VALUES (4, 1, 1, 1, 6, 1, '/DOMAIN_NAME/contact/', 'node', 'contact', 'false', 'false', '', '', '', 0, 'Контакты', '', '', '', '', '', 'false', 'true', 'false', 'true', '', '', '', 46, 0, 'false');
INSERT INTO `nodes` VALUES (5, 1, 1, 1, 5, 1, '/DOMAIN_NAME/news/', 'node', 'news', 'false', 'false', '', '', '', 0, 'Новости', '', '', '', '', '', 'false', 'true', 'false', 'true', '', '', '', 46, 0, 'false');
INSERT INTO `nodes` VALUES (6, 1, 1, 1, 7, 1, '/DOMAIN_NAME/map/', 'node', 'map', 'false', 'false', '', '', '', 0, 'Карта сайта', '', '', '', '', '', 'false', 'true', 'false', 'false', '', '', '', 46, 0, 'false');
INSERT INTO `nodes` VALUES (22, 1, 5, 1, 0, 2, '/DOMAIN_NAME/news/#page_id/', 'param', '#page_id', 'false', 'false', '', '', '', 0, 'Список материалов', 'Список материалов', '', '', '', '', 'false', 'true', 'false', 'true', '', '', '', 46, 15, 'false');
INSERT INTO `nodes` VALUES (23, 1, 5, 1, 0, 2, '/DOMAIN_NAME/news/#news_id/', 'param', '#news_id', 'false', 'false', '', '', '', 0, 'Список материалов', 'Список материалов', '', '', '', '', 'false', 'true', 'false', 'true', '', '', '', 46, 15, 'false');
INSERT INTO `nodes` VALUES (9, 1, 1, 1, 8, 1, '/DOMAIN_NAME/search/', 'node', 'search', 'false', 'true', '', '', '', 0, 'Поиск по сайту', '', '', '', '', '', 'false', 'true', 'false', 'false', '', '', '', 46, 0, 'false');
INSERT INTO `nodes` VALUES (12, 1, 3, 1, 1, 2, '/DOMAIN_NAME/about/articles/', 'node', 'articles', 'false', 'false', '', '', '', 0, 'Статьи', 'Статьи', '', '', '', '', 'false', 'true', 'false', 'true', '', '', '', 46, 0, 'false');
INSERT INTO `nodes` VALUES (13, 1, 3, 1, 2, 2, '/DOMAIN_NAME/about/vac/', 'node', 'vac', 'false', 'false', '', '', '', 0, 'Вакансии', '', '', '', '', '', 'false', 'true', 'false', 'true', '', '', '', 46, 0, 'false');
INSERT INTO `nodes` VALUES (14, 1, 1, 0, 4, 1, '/DOMAIN_NAME/service/', 'node', 'service', 'false', 'false', '', '', '', 0, 'Услуги', 'Услуги', '', '', '', '', 'false', 'true', 'false', 'true', '', '', '', 46, 0, 'false');
INSERT INTO `nodes` VALUES (15, 1, 14, 1, 1, 2, '/DOMAIN_NAME/service/pr/', 'node', 'pr', 'false', 'false', '', '', '', 0, 'Проектирование зданий', 'Проектирование зданий', '', '', '', '', 'false', 'true', 'false', 'true', '', '', '', 46, 0, 'false');
INSERT INTO `nodes` VALUES (16, 1, 14, 1, 2, 2, '/DOMAIN_NAME/service/design/', 'node', 'design', 'false', 'false', '', '', '', 0, 'Разработка дизайн-проекта', 'Разработка дизайн-проекта', '', '', '', '', 'false', 'true', 'false', 'true', '', '', '', 46, 0, 'false');
INSERT INTO `nodes` VALUES (17, 1, 14, 1, 3, 2, '/DOMAIN_NAME/service/zd/', 'node', 'zd', 'false', 'false', '', '', '', 0, 'Реконструкция зданий', 'Реконструкция зданий', '', '', '', '', 'false', 'true', 'false', 'true', '', '', '', 46, 0, 'false');
INSERT INTO `nodes` VALUES (21, 1, 12, 1, 0, 3, '/DOMAIN_NAME/about/articles/#news_id/', 'param', '#news_id', 'false', 'false', '', '', '', 0, 'Список материалов', 'Список материалов', '', '', '', '', 'false', 'true', 'false', 'true', '', '', '', 46, 15, 'false');
INSERT INTO `nodes` VALUES (20, 1, 12, 1, 0, 3, '/DOMAIN_NAME/about/articles/#page_id/', 'param', '#page_id', 'false', 'false', '', '', '', 0, 'Список материалов', 'Список материалов', '', '', '', '', 'false', 'true', 'false', 'true', '', '', '', 46, 15, 'false');

-- --------------------------------------------------------

-- 
-- Структура таблицы `nodes_rels`
-- 

DROP TABLE IF EXISTS `nodes_rels`;
CREATE TABLE IF NOT EXISTS `nodes_rels` (
  `node_id` int(10) unsigned NOT NULL default '0',
  `node_ancestor_id` int(10) unsigned NOT NULL default '0',
  `node_ancestor_pos` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`node_id`,`node_ancestor_id`),
  KEY `node_ancestor_id` (`node_ancestor_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `nodes_rels`
-- 

INSERT INTO `nodes_rels` VALUES (2, 1, 1);
INSERT INTO `nodes_rels` VALUES (3, 1, 1);
INSERT INTO `nodes_rels` VALUES (4, 1, 1);
INSERT INTO `nodes_rels` VALUES (5, 1, 1);
INSERT INTO `nodes_rels` VALUES (6, 1, 1);
INSERT INTO `nodes_rels` VALUES (22, 1, 2);
INSERT INTO `nodes_rels` VALUES (22, 5, 1);
INSERT INTO `nodes_rels` VALUES (23, 1, 2);
INSERT INTO `nodes_rels` VALUES (23, 5, 1);
INSERT INTO `nodes_rels` VALUES (9, 1, 1);
INSERT INTO `nodes_rels` VALUES (12, 3, 1);
INSERT INTO `nodes_rels` VALUES (12, 1, 2);
INSERT INTO `nodes_rels` VALUES (13, 3, 1);
INSERT INTO `nodes_rels` VALUES (13, 1, 2);
INSERT INTO `nodes_rels` VALUES (14, 1, 1);
INSERT INTO `nodes_rels` VALUES (15, 1, 2);
INSERT INTO `nodes_rels` VALUES (15, 14, 1);
INSERT INTO `nodes_rels` VALUES (16, 14, 1);
INSERT INTO `nodes_rels` VALUES (16, 1, 2);
INSERT INTO `nodes_rels` VALUES (17, 14, 1);
INSERT INTO `nodes_rels` VALUES (17, 1, 2);
INSERT INTO `nodes_rels` VALUES (21, 3, 2);
INSERT INTO `nodes_rels` VALUES (21, 1, 3);
INSERT INTO `nodes_rels` VALUES (21, 12, 1);
INSERT INTO `nodes_rels` VALUES (20, 3, 2);
INSERT INTO `nodes_rels` VALUES (20, 1, 3);
INSERT INTO `nodes_rels` VALUES (20, 12, 1);

-- --------------------------------------------------------

-- 
-- Структура таблицы `nodes_rewrite`
-- 

DROP TABLE IF EXISTS `nodes_rewrite`;
CREATE TABLE IF NOT EXISTS `nodes_rewrite` (
  `rule_id` int(10) unsigned NOT NULL auto_increment,
  `node_id` int(10) unsigned NOT NULL default '0',
  `rule` varchar(255) NOT NULL default '',
  `rule_length` tinyint(3) unsigned NOT NULL default '0',
  `rule_validator` varchar(255) NOT NULL default '',
  `field` varchar(255) NOT NULL,
  `rule_enumerator` enum('true','false') NOT NULL default 'false',
  PRIMARY KEY  (`rule_id`),
  KEY `node_id` (`node_id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

-- 
-- Дамп данных таблицы `nodes_rewrite`
-- 

INSERT INTO `nodes_rewrite` VALUES (9, 22, 'page([0-9]+)', 1, 'newsgroups', '31', 'false');
INSERT INTO `nodes_rewrite` VALUES (8, 21, '([0-9]+).html', 1, 'newsgroups', '29', 'false');
INSERT INTO `nodes_rewrite` VALUES (7, 20, 'page([0-9]+)', 1, 'newsgroups', '28', 'false');
INSERT INTO `nodes_rewrite` VALUES (10, 23, '([0-9]+).html', 1, 'newsgroups', '32', 'false');

-- --------------------------------------------------------

-- 
-- Структура таблицы `preferences`
-- 

DROP TABLE IF EXISTS `preferences`;
CREATE TABLE IF NOT EXISTS `preferences` (
  `license_number` varchar(255) NOT NULL default '',
  `email` varchar(255) NOT NULL default '',
  `meta_title` varchar(255) NOT NULL default '',
  `meta_description` varchar(255) NOT NULL default '',
  `meta_keywords` varchar(255) NOT NULL default '',
  `meta_data` text NOT NULL,
  `email_encoding` int(10) unsigned NOT NULL default '0',
  `site_closed` enum('false','true') NOT NULL default 'false',
  `site_closed_msg` text NOT NULL,
  `copyright_data` text NOT NULL,
  `date_format` int(10) unsigned NOT NULL default '0',
  `html_editor` int(10) unsigned NOT NULL default '0',
  `main_host` varchar(255) NOT NULL default '',
  `disallow_robots` enum('true','false') NOT NULL default 'false',
  `site_name` varchar(255) NOT NULL default ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `preferences`
-- 

INSERT INTO `preferences` VALUES ('', 'info@DOMAIN_NAME', 'Моя компания', 'Моя компания', 'Моя компания', '', 3, 'false', '<h2 align="center">Сайт закрыт по техническим причинам</h2>\r\n<p align="center">Приносим Вам свои извинения за предоставленные неудобства.</p>\r\n<p align="center">С Уважением, Администрация</p>', '&copy; <currentyear/> Моя компания', 3, 3, 'www.DOMAIN_NAME', 'false', 'Моя компания');

-- --------------------------------------------------------

-- 
-- Структура таблицы `preferences_dates_format`
-- 

DROP TABLE IF EXISTS `preferences_dates_format`;
CREATE TABLE IF NOT EXISTS `preferences_dates_format` (
  `format_id` int(10) unsigned NOT NULL auto_increment,
  `format_string` varchar(255) NOT NULL default '',
  `format_name` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`format_id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 AUTO_INCREMENT=14 ;

-- 
-- Дамп данных таблицы `preferences_dates_format`
-- 

INSERT INTO `preferences_dates_format` VALUES (1, 'd.m.Y H:i:s', 'дд.мм.ГГГГ ЧЧ:ММ:сс');
INSERT INTO `preferences_dates_format` VALUES (2, 'd/m/Y H:i:s', 'дд/мм/ГГГГ ЧЧ:ММ:сс');
INSERT INTO `preferences_dates_format` VALUES (3, 'd-m-Y H:i:s', 'дд-мм-ГГГГГ ЧЧ:ММ:сс');
INSERT INTO `preferences_dates_format` VALUES (4, 'd.m.Y H:i', 'дд.мм.ГГГГ ЧЧ:ММ');
INSERT INTO `preferences_dates_format` VALUES (5, 'd/m/Y H:i', 'дд/мм/ГГГГ ЧЧ:ММ');
INSERT INTO `preferences_dates_format` VALUES (6, 'd-m-Y H:i', 'дд-мм-ГГГГ ЧЧ:ММ');
INSERT INTO `preferences_dates_format` VALUES (7, 'd.m.Y H:i:s', 'дд.мм.ГГГГ ЧЧ:ММ:сс');
INSERT INTO `preferences_dates_format` VALUES (8, 'd/m/Y', 'дд/мм/ГГГГ');
INSERT INTO `preferences_dates_format` VALUES (9, 'd-m-Y', 'дд-мм-ГГГГ');
INSERT INTO `preferences_dates_format` VALUES (10, 'd.m.y', 'дд.мм.гг');
INSERT INTO `preferences_dates_format` VALUES (11, 'd.m.Y', 'дд.мм.гггг');
INSERT INTO `preferences_dates_format` VALUES (12, 'd $month y', 'ДД месяц ГГ');
INSERT INTO `preferences_dates_format` VALUES (13, 'd $month Y', 'ДД месяц ГГГГ');

-- --------------------------------------------------------

-- 
-- Структура таблицы `preferences_encodings`
-- 

DROP TABLE IF EXISTS `preferences_encodings`;
CREATE TABLE IF NOT EXISTS `preferences_encodings` (
  `encoding_id` int(10) unsigned NOT NULL auto_increment,
  `encoding_name` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`encoding_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

-- 
-- Дамп данных таблицы `preferences_encodings`
-- 

INSERT INTO `preferences_encodings` VALUES (1, 'windows-1251');
INSERT INTO `preferences_encodings` VALUES (2, 'koi8-r');
INSERT INTO `preferences_encodings` VALUES (3, 'UTF-8');

-- --------------------------------------------------------

-- 
-- Структура таблицы `preferences_filetypes`
-- 

DROP TABLE IF EXISTS `preferences_filetypes`;
CREATE TABLE IF NOT EXISTS `preferences_filetypes` (
  `filetype_id` int(10) unsigned NOT NULL auto_increment,
  `filetype_default` enum('true','false') NOT NULL default 'false',
  `filetype_name` varchar(255) NOT NULL,
  `filetype_icon` varchar(255) NOT NULL,
  PRIMARY KEY  (`filetype_id`,`filetype_default`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 AUTO_INCREMENT=17 ;

-- 
-- Дамп данных таблицы `preferences_filetypes`
-- 

INSERT INTO `preferences_filetypes` VALUES (1, 'true', 'Тип файлов по - умолчанию', '/files/filetypes/icon_file.gif');
INSERT INTO `preferences_filetypes` VALUES (5, 'false', 'Microsoft Word', '/files/filetypes/icon_doc.gif');
INSERT INTO `preferences_filetypes` VALUES (13, 'false', 'Microsoft Excel', '/files/filetypes/icon_xls.gif');
INSERT INTO `preferences_filetypes` VALUES (14, 'false', 'Adobe PDF', '/files/filetypes/icon_pdf.gif');
INSERT INTO `preferences_filetypes` VALUES (15, 'false', 'Архив', '/files/filetypes/icon_arc.gif');
INSERT INTO `preferences_filetypes` VALUES (16, 'false', 'Графическое изображение', '/files/filetypes/icon_pic.gif');

-- --------------------------------------------------------

-- 
-- Структура таблицы `preferences_filetypes_exts`
-- 

DROP TABLE IF EXISTS `preferences_filetypes_exts`;
CREATE TABLE IF NOT EXISTS `preferences_filetypes_exts` (
  `ext_id` int(10) unsigned NOT NULL auto_increment,
  `filetype_id` int(10) unsigned NOT NULL,
  `ext` varchar(255) NOT NULL,
  PRIMARY KEY  (`ext_id`,`ext`),
  KEY `filetype_id` (`filetype_id`)
) ENGINE=MyISAM AUTO_INCREMENT=51 DEFAULT CHARSET=utf8 AUTO_INCREMENT=51 ;

-- 
-- Дамп данных таблицы `preferences_filetypes_exts`
-- 

INSERT INTO `preferences_filetypes_exts` VALUES (1, 5, 'docx');
INSERT INTO `preferences_filetypes_exts` VALUES (19, 5, 'rtf');
INSERT INTO `preferences_filetypes_exts` VALUES (17, 5, 'doc');
INSERT INTO `preferences_filetypes_exts` VALUES (21, 5, 'txt');
INSERT INTO `preferences_filetypes_exts` VALUES (23, 13, 'xls');
INSERT INTO `preferences_filetypes_exts` VALUES (24, 13, 'xlsx');
INSERT INTO `preferences_filetypes_exts` VALUES (25, 13, 'csv');
INSERT INTO `preferences_filetypes_exts` VALUES (26, 14, 'pdf');
INSERT INTO `preferences_filetypes_exts` VALUES (27, 15, 'rar');
INSERT INTO `preferences_filetypes_exts` VALUES (28, 15, 'zip');
INSERT INTO `preferences_filetypes_exts` VALUES (29, 15, '7z');
INSERT INTO `preferences_filetypes_exts` VALUES (30, 15, 'tar');
INSERT INTO `preferences_filetypes_exts` VALUES (31, 15, 'gz');
INSERT INTO `preferences_filetypes_exts` VALUES (32, 15, 'gzip');
INSERT INTO `preferences_filetypes_exts` VALUES (33, 15, 'cab');
INSERT INTO `preferences_filetypes_exts` VALUES (34, 15, 'rpm');
INSERT INTO `preferences_filetypes_exts` VALUES (36, 16, 'jpg');
INSERT INTO `preferences_filetypes_exts` VALUES (37, 16, 'gif');
INSERT INTO `preferences_filetypes_exts` VALUES (38, 16, 'bmp');
INSERT INTO `preferences_filetypes_exts` VALUES (39, 16, 'tif');
INSERT INTO `preferences_filetypes_exts` VALUES (40, 16, 'tiff');
INSERT INTO `preferences_filetypes_exts` VALUES (41, 16, 'jpeg');
INSERT INTO `preferences_filetypes_exts` VALUES (42, 16, 'png');
INSERT INTO `preferences_filetypes_exts` VALUES (43, 16, 'psd');
INSERT INTO `preferences_filetypes_exts` VALUES (44, 16, 'pic');
INSERT INTO `preferences_filetypes_exts` VALUES (45, 16, 'ico');
INSERT INTO `preferences_filetypes_exts` VALUES (46, 16, 'tga');
INSERT INTO `preferences_filetypes_exts` VALUES (47, 16, 'cdr');
INSERT INTO `preferences_filetypes_exts` VALUES (48, 16, 'ai');
INSERT INTO `preferences_filetypes_exts` VALUES (49, 16, 'eps');

-- --------------------------------------------------------

-- 
-- Структура таблицы `preferences_html_editors`
-- 

DROP TABLE IF EXISTS `preferences_html_editors`;
CREATE TABLE IF NOT EXISTS `preferences_html_editors` (
  `html_editor_id` int(10) unsigned NOT NULL auto_increment,
  `html_editor_sysname` varchar(255) NOT NULL,
  `hidden` enum('true','false') NOT NULL default 'false',
  `html_editor_name` varchar(255) NOT NULL default '',
  `include_scripts` text NOT NULL,
  `execute_scripts` text NOT NULL,
  PRIMARY KEY  (`html_editor_id`,`html_editor_sysname`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

-- 
-- Дамп данных таблицы `preferences_html_editors`
-- 

INSERT INTO `preferences_html_editors` VALUES (3, 'innova', 'false', 'InnovaEditor', '<script type="text/javascript" src="/admin/scripts/editor/scripts/language/russian/editor_lang.js"></script><script type="text/javascript" src="/admin/scripts/editor/scripts/innovaeditor.js"></script>\r\n', '$global_id = ''oEditor_[TEXTAREA_ID]'';\r\n       window[$global_id] = new InnovaEditor ($global_id);\r\n       window[$global_id].cmdInternalLink="modelessDialogShow(\\''links.php\\'',365,250)";\r\n       window[$global_id].features=["Save", "FullScreen","Cut","Copy","PasteWord","PasteText","|","Undo","Redo","|",\r\n           "ForeColor","BackColor","|","Bookmark","Hyperlink","Line",\r\n           "Image","|","Table","Guidelines","Absolute","|",\r\n           "Characters","RemoveFormat","BRK",\r\n           "XHTMLSource","Paragraph","|",\r\n           "Bold","Italic","Underline","Strikethrough","|",\r\n           "JustifyLeft","JustifyCenter","JustifyRight","JustifyFull","|","Numbering","Bullets","|","Indent","Outdent"];\r\n       window[$global_id].width="100%";\r\n       window[$global_id].css = ''[THEME]/css/styles.css'';\r\n       window[$global_id].height="[HEIGHT]px";\r\n       window[$global_id].btnClearAll=true;\r\n       window[$global_id].useDIV=false;\r\n       window[$global_id].cmdAssetManager="modalDialogShow(\\''/admin/scripts/editor/assetmanager/assetmanager.php?lang=russian\\'',640,500);";\r\n       window[$global_id].btnStyles=true;\r\n       \r\n       $textarea = $(''[TEXTAREA_ID]'');\r\n       $div = document.createElement ( ''div'' );\r\n       $div.id = ''content_div_[TEXTAREA_ID]'';\r\n       $textarea.parentNode.insertBefore($div, $textarea);\r\n       window.contentDivName = ''content_div_[TEXTAREA_ID]'';\r\n       window[$global_id].REPLACE(''[TEXTAREA_ID]'');');
INSERT INTO `preferences_html_editors` VALUES (5, 'innova_lite', 'true', 'InnovaEditor (lite)', '<script type="text/javascript" src="/admin/scripts/editor/scripts/language/russian/editor_lang.js"></script><script type="text/javascript" src="scripts/editor/scripts/innovaeditor.js"></script>', '$global_id = ''oEditor_[TEXTAREA_ID]'';\r\n       window[$global_id] = new InnovaEditor ($global_id);\r\n       window[$global_id].cmdInternalLink="modelessDialogShow(\\''links.php\\'',365,250)";\r\n       window[$global_id].features=["Save", "Cut","Copy","PasteWord","PasteText","|","Undo","Redo","|","Hyperlink", "RemoveFormat",\r\n           "XHTMLSource","|",\r\n           "Bold","Italic","Underline","Strikethrough","|",\r\n           "JustifyLeft","JustifyCenter","JustifyRight","JustifyFull"];\r\n       window[$global_id].width="100%";\r\n       window[$global_id].css = ''/css/styles.css'';\r\n       window[$global_id].height="[HEIGHT]px";\r\n       window[$global_id].btnClearAll=true;\r\n       window[$global_id].useDIV=false;\r\n       window[$global_id].cmdAssetManager="modalDialogShow(\\''/admin/scripts/editor/assetmanager/assetmanager.php?lang=russian\\'',640,500);";\r\n       window[$global_id].btnStyles=true;\r\n       \r\n       $textarea = $(''[TEXTAREA_ID]'');\r\n       $div = document.createElement ( ''div'' );\r\n       $div.id = ''content_div_[TEXTAREA_ID]'';\r\n       $textarea.parentNode.insertBefore($div, $textarea);\r\n       window.contentDivName = ''content_div_[TEXTAREA_ID]'';\r\n       window[$global_id].REPLACE(''[TEXTAREA_ID]'');');

-- --------------------------------------------------------

-- 
-- Структура таблицы `spider_domains`
-- 

DROP TABLE IF EXISTS `spider_domains`;
CREATE TABLE IF NOT EXISTS `spider_domains` (
  `spider_domain_id` int(11) NOT NULL auto_increment,
  `spider_domain_title` varchar(255) default NULL,
  PRIMARY KEY  (`spider_domain_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

-- 
-- Дамп данных таблицы `spider_domains`
-- 

INSERT INTO `spider_domains` VALUES (1, 'www.DOMAIN_NAME');

-- --------------------------------------------------------

-- 
-- Структура таблицы `spider_keywords`
-- 

DROP TABLE IF EXISTS `spider_keywords`;
CREATE TABLE IF NOT EXISTS `spider_keywords` (
  `spider_keyword_id` int(11) NOT NULL auto_increment,
  `spider_keyword_title` varchar(30) NOT NULL,
  PRIMARY KEY  (`spider_keyword_id`),
  UNIQUE KEY `kw` (`spider_keyword_title`),
  KEY `keyword` (`spider_keyword_title`(10))
) ENGINE=MyISAM AUTO_INCREMENT=636 DEFAULT CHARSET=utf8 AUTO_INCREMENT=636 ;

-- 
-- Дамп данных таблицы `spider_keywords`
-- 

INSERT INTO `spider_keywords` VALUES (1, '');
INSERT INTO `spider_keywords` VALUES (2, '10');
INSERT INTO `spider_keywords` VALUES (3, '16');
INSERT INTO `spider_keywords` VALUES (4, '495');
INSERT INTO `spider_keywords` VALUES (5, '2010');
INSERT INTO `spider_keywords` VALUES (6, '505-44-02');
INSERT INTO `spider_keywords` VALUES (7, '555-44-33');
INSERT INTO `spider_keywords` VALUES (8, '6-ти');
INSERT INTO `spider_keywords` VALUES (9, '982-38-10');
INSERT INTO `spider_keywords` VALUES (10, 'admin');
INSERT INTO `spider_keywords` VALUES (11, 'cms');
INSERT INTO `spider_keywords` VALUES (12, 'conversion');
INSERT INTO `spider_keywords` VALUES (13, 'ctr');
INSERT INTO `spider_keywords` VALUES (14, 'e-mail');
INSERT INTO `spider_keywords` VALUES (15, 'handy');
INSERT INTO `spider_keywords` VALUES (16, 'handycms');
INSERT INTO `spider_keywords` VALUES (17, 'help');
INSERT INTO `spider_keywords` VALUES (18, 'pr');
INSERT INTO `spider_keywords` VALUES (19, 'pr-эффект');
INSERT INTO `spider_keywords` VALUES (20, 'rate');
INSERT INTO `spider_keywords` VALUES (21, 'ru');
INSERT INTO `spider_keywords` VALUES (22, 'vip-мероприятие');
INSERT INTO `spider_keywords` VALUES (23, 'агентами');
INSERT INTO `spider_keywords` VALUES (24, 'агентская');
INSERT INTO `spider_keywords` VALUES (25, 'административную');
INSERT INTO `spider_keywords` VALUES (26, 'акоффа');
INSERT INTO `spider_keywords` VALUES (27, 'активна');
INSERT INTO `spider_keywords` VALUES (28, 'активности');
INSERT INTO `spider_keywords` VALUES (29, 'анализ');
INSERT INTO `spider_keywords` VALUES (30, 'анализируя');
INSERT INTO `spider_keywords` VALUES (31, 'антитезу');
INSERT INTO `spider_keywords` VALUES (32, 'архетипа');
INSERT INTO `spider_keywords` VALUES (33, 'база');
INSERT INTO `spider_keywords` VALUES (34, 'без');
INSERT INTO `spider_keywords` VALUES (35, 'биографии');
INSERT INTO `spider_keywords` VALUES (36, 'блок');
INSERT INTO `spider_keywords` VALUES (37, 'богема');
INSERT INTO `spider_keywords` VALUES (38, 'бренда');
INSERT INTO `spider_keywords` VALUES (39, 'брендом');
INSERT INTO `spider_keywords` VALUES (40, 'будет');
INSERT INTO `spider_keywords` VALUES (41, 'бюджеты');
INSERT INTO `spider_keywords` VALUES (42, 'в');
INSERT INTO `spider_keywords` VALUES (43, 'вам');
INSERT INTO `spider_keywords` VALUES (44, 'вас');
INSERT INTO `spider_keywords` VALUES (45, 'введите');
INSERT INTO `spider_keywords` VALUES (46, 'версифицирован');
INSERT INTO `spider_keywords` VALUES (47, 'весна');
INSERT INTO `spider_keywords` VALUES (48, 'внимание');
INSERT INTO `spider_keywords` VALUES (49, 'вон');
INSERT INTO `spider_keywords` VALUES (50, 'вопреки');
INSERT INTO `spider_keywords` VALUES (51, 'вопросам');
INSERT INTO `spider_keywords` VALUES (52, 'все');
INSERT INTO `spider_keywords` VALUES (53, 'всем');
INSERT INTO `spider_keywords` VALUES (54, 'вы');
INSERT INTO `spider_keywords` VALUES (55, 'выразительное');
INSERT INTO `spider_keywords` VALUES (56, 'выстраивания');
INSERT INTO `spider_keywords` VALUES (57, 'выходящий');
INSERT INTO `spider_keywords` VALUES (58, 'г');
INSERT INTO `spider_keywords` VALUES (59, 'главная');
INSERT INTO `spider_keywords` VALUES (60, 'данная');
INSERT INTO `spider_keywords` VALUES (61, 'действие');
INSERT INTO `spider_keywords` VALUES (62, 'действия');
INSERT INTO `spider_keywords` VALUES (63, 'демо');
INSERT INTO `spider_keywords` VALUES (64, 'демо-площадка');
INSERT INTO `spider_keywords` VALUES (65, 'демо-тексты');
INSERT INTO `spider_keywords` VALUES (66, 'демонстрационный');
INSERT INTO `spider_keywords` VALUES (67, 'дизайн-проекта');
INSERT INTO `spider_keywords` VALUES (68, 'для');
INSERT INTO `spider_keywords` VALUES (69, 'добро');
INSERT INTO `spider_keywords` VALUES (70, 'доступа');
INSERT INTO `spider_keywords` VALUES (71, 'драматических');
INSERT INTO `spider_keywords` VALUES (72, 'другие');
INSERT INTO `spider_keywords` VALUES (73, 'друкера');
INSERT INTO `spider_keywords` VALUES (74, 'ж');
INSERT INTO `spider_keywords` VALUES (75, 'же');
INSERT INTO `spider_keywords` VALUES (76, 'западных');
INSERT INTO `spider_keywords` VALUES (77, 'запустили');
INSERT INTO `spider_keywords` VALUES (78, 'затратами');
INSERT INTO `spider_keywords` VALUES (79, 'звоните');
INSERT INTO `spider_keywords` VALUES (80, 'зданий');
INSERT INTO `spider_keywords` VALUES (81, 'и');
INSERT INTO `spider_keywords` VALUES (82, 'из');
INSERT INTO `spider_keywords` VALUES (83, 'издание');
INSERT INTO `spider_keywords` VALUES (84, 'изданий');
INSERT INTO `spider_keywords` VALUES (85, 'изоморфнавремени');
INSERT INTO `spider_keywords` VALUES (86, 'имеет');
INSERT INTO `spider_keywords` VALUES (87, 'индуцирует');
INSERT INTO `spider_keywords` VALUES (88, 'интересноотметить');
INSERT INTO `spider_keywords` VALUES (89, 'искусство');
INSERT INTO `spider_keywords` VALUES (90, 'использует');
INSERT INTO `spider_keywords` VALUES (91, 'к');
INSERT INTO `spider_keywords` VALUES (92, 'как');
INSERT INTO `spider_keywords` VALUES (93, 'кампании');
INSERT INTO `spider_keywords` VALUES (94, 'канал');
INSERT INTO `spider_keywords` VALUES (95, 'канон');
INSERT INTO `spider_keywords` VALUES (96, 'клиентский');
INSERT INTO `spider_keywords` VALUES (97, 'книге');
INSERT INTO `spider_keywords` VALUES (98, 'коллег');
INSERT INTO `spider_keywords` VALUES (99, 'коллективный');
INSERT INTO `spider_keywords` VALUES (100, 'комиссия');
INSERT INTO `spider_keywords` VALUES (101, 'коммерсчекими');
INSERT INTO `spider_keywords` VALUES (102, 'компании');
INSERT INTO `spider_keywords` VALUES (103, 'комплексный');
INSERT INTO `spider_keywords` VALUES (104, 'конкуренцию');
INSERT INTO `spider_keywords` VALUES (105, 'конструктивный');
INSERT INTO `spider_keywords` VALUES (106, 'концентрирует');
INSERT INTO `spider_keywords` VALUES (107, 'концепции');
INSERT INTO `spider_keywords` VALUES (108, 'корф');
INSERT INTO `spider_keywords` VALUES (109, 'креативный');
INSERT INTO `spider_keywords` VALUES (110, 'критично');
INSERT INTO `spider_keywords` VALUES (111, 'культурный');
INSERT INTO `spider_keywords` VALUES (112, 'логин');
INSERT INTO `spider_keywords` VALUES (113, 'лояльных');
INSERT INTO `spider_keywords` VALUES (114, 'маркетинг');
INSERT INTO `spider_keywords` VALUES (115, 'маркетинга');
INSERT INTO `spider_keywords` VALUES (116, 'маркетингово-ориентированное');
INSERT INTO `spider_keywords` VALUES (117, 'материал');
INSERT INTO `spider_keywords` VALUES (118, 'материалы');
INSERT INTO `spider_keywords` VALUES (119, 'медиа-кампаний');
INSERT INTO `spider_keywords` VALUES (120, 'медиамикс');
INSERT INTO `spider_keywords` VALUES (121, 'медиапланирования');
INSERT INTO `spider_keywords` VALUES (122, 'менее');
INSERT INTO `spider_keywords` VALUES (123, 'механизмам');
INSERT INTO `spider_keywords` VALUES (124, 'механизмов');
INSERT INTO `spider_keywords` VALUES (125, 'мифа');
INSERT INTO `spider_keywords` VALUES (126, 'мифотворчества');
INSERT INTO `spider_keywords` VALUES (127, 'мнению');
INSERT INTO `spider_keywords` VALUES (128, 'можете');
INSERT INTO `spider_keywords` VALUES (129, 'мониторинг');
INSERT INTO `spider_keywords` VALUES (130, 'мы');
INSERT INTO `spider_keywords` VALUES (131, 'мышления');
INSERT INTO `spider_keywords` VALUES (132, 'на');
INSERT INTO `spider_keywords` VALUES (133, 'надеемся');
INSERT INTO `spider_keywords` VALUES (134, 'надо');
INSERT INTO `spider_keywords` VALUES (135, 'нам');
INSERT INTO `spider_keywords` VALUES (136, 'нас');
INSERT INTO `spider_keywords` VALUES (137, 'начале');
INSERT INTO `spider_keywords` VALUES (138, 'наш');
INSERT INTO `spider_keywords` VALUES (139, 'нашей');
INSERT INTO `spider_keywords` VALUES (140, 'наши');
INSERT INTO `spider_keywords` VALUES (141, 'не');
INSERT INTO `spider_keywords` VALUES (142, 'необходимости');
INSERT INTO `spider_keywords` VALUES (143, 'неоднозначен');
INSERT INTO `spider_keywords` VALUES (144, 'новости');
INSERT INTO `spider_keywords` VALUES (145, 'новую');
INSERT INTO `spider_keywords` VALUES (146, 'новый');
INSERT INTO `spider_keywords` VALUES (147, 'о');
INSERT INTO `spider_keywords` VALUES (148, 'обосновывал');
INSERT INTO `spider_keywords` VALUES (149, 'образа');
INSERT INTO `spider_keywords` VALUES (150, 'образом');
INSERT INTO `spider_keywords` VALUES (151, 'обращайтесь');
INSERT INTO `spider_keywords` VALUES (152, 'общественный');
INSERT INTO `spider_keywords` VALUES (153, 'общество');
INSERT INTO `spider_keywords` VALUES (154, 'ограничений');
INSERT INTO `spider_keywords` VALUES (155, 'ограниченный');
INSERT INTO `spider_keywords` VALUES (156, 'одновременно');
INSERT INTO `spider_keywords` VALUES (157, 'ознакомиться');
INSERT INTO `spider_keywords` VALUES (158, 'окончанию');
INSERT INTO `spider_keywords` VALUES (159, 'она');
INSERT INTO `spider_keywords` VALUES (160, 'опираясь');
INSERT INTO `spider_keywords` VALUES (161, 'оптимизируя');
INSERT INTO `spider_keywords` VALUES (162, 'опыт');
INSERT INTO `spider_keywords` VALUES (163, 'организация');
INSERT INTO `spider_keywords` VALUES (164, 'осознав');
INSERT INTO `spider_keywords` VALUES (165, 'отвоевывая');
INSERT INTO `spider_keywords` VALUES (166, 'отношений');
INSERT INTO `spider_keywords` VALUES (167, 'отражает');
INSERT INTO `spider_keywords` VALUES (168, 'отталкивает');
INSERT INTO `spider_keywords` VALUES (169, 'п');
INSERT INTO `spider_keywords` VALUES (170, 'парадоксально');
INSERT INTO `spider_keywords` VALUES (171, 'пароль');
INSERT INTO `spider_keywords` VALUES (172, 'перейдите');
INSERT INTO `spider_keywords` VALUES (173, 'перечисленные');
INSERT INTO `spider_keywords` VALUES (174, 'периода');
INSERT INTO `spider_keywords` VALUES (175, 'площадка');
INSERT INTO `spider_keywords` VALUES (176, 'площадку');
INSERT INTO `spider_keywords` VALUES (177, 'по');
INSERT INTO `spider_keywords` VALUES (178, 'побочный');
INSERT INTO `spider_keywords` VALUES (179, 'повсеместно');
INSERT INTO `spider_keywords` VALUES (180, 'повышая');
INSERT INTO `spider_keywords` VALUES (181, 'подсознательно');
INSERT INTO `spider_keywords` VALUES (182, 'подтверждают');
INSERT INTO `spider_keywords` VALUES (183, 'пожаловать');
INSERT INTO `spider_keywords` VALUES (184, 'положение');
INSERT INTO `spider_keywords` VALUES (185, 'польти');
INSERT INTO `spider_keywords` VALUES (186, 'помощью');
INSERT INTO `spider_keywords` VALUES (187, 'понравится');
INSERT INTO `spider_keywords` VALUES (188, 'последние');
INSERT INTO `spider_keywords` VALUES (189, 'потребительская');
INSERT INTO `spider_keywords` VALUES (190, 'потребления');
INSERT INTO `spider_keywords` VALUES (191, 'почему');
INSERT INTO `spider_keywords` VALUES (192, 'предлагаем');
INSERT INTO `spider_keywords` VALUES (193, 'предыдущих');
INSERT INTO `spider_keywords` VALUES (194, 'презентационный');
INSERT INTO `spider_keywords` VALUES (195, 'презентация');
INSERT INTO `spider_keywords` VALUES (196, 'пресс-клиппинг');
INSERT INTO `spider_keywords` VALUES (197, 'при');
INSERT INTO `spider_keywords` VALUES (198, 'признаки');
INSERT INTO `spider_keywords` VALUES (199, 'программирует');
INSERT INTO `spider_keywords` VALUES (200, 'проектирование');
INSERT INTO `spider_keywords` VALUES (201, 'производства');
INSERT INTO `spider_keywords` VALUES (202, 'просветляет');
INSERT INTO `spider_keywords` VALUES (203, 'пул');
INSERT INTO `spider_keywords` VALUES (204, 'рады');
INSERT INTO `spider_keywords` VALUES (205, 'развивает');
INSERT INTO `spider_keywords` VALUES (206, 'разработка');
INSERT INTO `spider_keywords` VALUES (207, 'рамках');
INSERT INTO `spider_keywords` VALUES (208, 'регистрации');
INSERT INTO `spider_keywords` VALUES (209, 'результат');
INSERT INTO `spider_keywords` VALUES (210, 'результаты');
INSERT INTO `spider_keywords` VALUES (211, 'рейтинг');
INSERT INTO `spider_keywords` VALUES (212, 'рекламное');
INSERT INTO `spider_keywords` VALUES (213, 'рекламной');
INSERT INTO `spider_keywords` VALUES (214, 'рекламный');
INSERT INTO `spider_keywords` VALUES (215, 'рекламоноситель');
INSERT INTO `spider_keywords` VALUES (216, 'реконструкции');
INSERT INTO `spider_keywords` VALUES (217, 'реконструкция');
INSERT INTO `spider_keywords` VALUES (218, 'рынка');
INSERT INTO `spider_keywords` VALUES (219, 'рыночный');
INSERT INTO `spider_keywords` VALUES (220, 'ряда');
INSERT INTO `spider_keywords` VALUES (221, 'с');
INSERT INTO `spider_keywords` VALUES (222, 'сайт');
INSERT INTO `spider_keywords` VALUES (223, 'сайта');
INSERT INTO `spider_keywords` VALUES (224, 'сангвиник');
INSERT INTO `spider_keywords` VALUES (225, 'связанный');
INSERT INTO `spider_keywords` VALUES (226, 'сгенерированы');
INSERT INTO `spider_keywords` VALUES (227, 'сегмент');
INSERT INTO `spider_keywords` VALUES (228, 'сезонные');
INSERT INTO `spider_keywords` VALUES (229, 'сезонных');
INSERT INTO `spider_keywords` VALUES (230, 'селекция');
INSERT INTO `spider_keywords` VALUES (231, 'сервиса');
INSERT INTO `spider_keywords` VALUES (232, 'синхронизирует');
INSERT INTO `spider_keywords` VALUES (233, 'системы');
INSERT INTO `spider_keywords` VALUES (234, 'ситуации');
INSERT INTO `spider_keywords` VALUES (235, 'ситуаций');
INSERT INTO `spider_keywords` VALUES (236, 'сказать');
INSERT INTO `spider_keywords` VALUES (237, 'скидки');
INSERT INTO `spider_keywords` VALUES (238, 'скидок');
INSERT INTO `spider_keywords` VALUES (239, 'сложен');
INSERT INTO `spider_keywords` VALUES (240, 'слубы');
INSERT INTO `spider_keywords` VALUES (241, 'службы');
INSERT INTO `spider_keywords` VALUES (242, 'снижение');
INSERT INTO `spider_keywords` VALUES (243, 'снизили');
INSERT INTO `spider_keywords` VALUES (244, 'со');
INSERT INTO `spider_keywords` VALUES (245, 'собственную');
INSERT INTO `spider_keywords` VALUES (246, 'события');
INSERT INTO `spider_keywords` VALUES (247, 'современные');
INSERT INTO `spider_keywords` VALUES (248, 'создавать');
INSERT INTO `spider_keywords` VALUES (249, 'создана');
INSERT INTO `spider_keywords` VALUES (250, 'создать');
INSERT INTO `spider_keywords` VALUES (251, 'сообщество');
INSERT INTO `spider_keywords` VALUES (252, 'сообщить');
INSERT INTO `spider_keywords` VALUES (253, 'социальный');
INSERT INTO `spider_keywords` VALUES (254, 'специально');
INSERT INTO `spider_keywords` VALUES (255, 'спецпредложение');
INSERT INTO `spider_keywords` VALUES (256, 'спецпредложением');
INSERT INTO `spider_keywords` VALUES (257, 'спонсорство');
INSERT INTO `spider_keywords` VALUES (258, 'спонтанно');
INSERT INTO `spider_keywords` VALUES (259, 'спорадически');
INSERT INTO `spider_keywords` VALUES (260, 'спрос');
INSERT INTO `spider_keywords` VALUES (261, 'сродни');
INSERT INTO `spider_keywords` VALUES (262, 'срок');
INSERT INTO `spider_keywords` VALUES (263, 'ссылке');
INSERT INTO `spider_keywords` VALUES (264, 'статус');
INSERT INTO `spider_keywords` VALUES (265, 'статьи');
INSERT INTO `spider_keywords` VALUES (266, 'страница');
INSERT INTO `spider_keywords` VALUES (267, 'страницы');
INSERT INTO `spider_keywords` VALUES (268, 'стэка');
INSERT INTO `spider_keywords` VALUES (269, 'сублимированный');
INSERT INTO `spider_keywords` VALUES (270, 'сути');
INSERT INTO `spider_keywords` VALUES (271, 'считаясь');
INSERT INTO `spider_keywords` VALUES (272, 'так');
INSERT INTO `spider_keywords` VALUES (273, 'таким');
INSERT INTO `spider_keywords` VALUES (274, 'тактика');
INSERT INTO `spider_keywords` VALUES (275, 'телефоны');
INSERT INTO `spider_keywords` VALUES (276, 'тем');
INSERT INTO `spider_keywords` VALUES (277, 'тенденции');
INSERT INTO `spider_keywords` VALUES (278, 'течение');
INSERT INTO `spider_keywords` VALUES (279, 'тормозит');
INSERT INTO `spider_keywords` VALUES (280, 'традиционно');
INSERT INTO `spider_keywords` VALUES (281, 'традиционный');
INSERT INTO `spider_keywords` VALUES (282, 'транслирует');
INSERT INTO `spider_keywords` VALUES (283, 'трансформирует');
INSERT INTO `spider_keywords` VALUES (284, 'тридцать');
INSERT INTO `spider_keywords` VALUES (285, 'у');
INSERT INTO `spider_keywords` VALUES (286, 'удалена');
INSERT INTO `spider_keywords` VALUES (287, 'удалять');
INSERT INTO `spider_keywords` VALUES (288, 'указанные');
INSERT INTO `spider_keywords` VALUES (289, 'управление');
INSERT INTO `spider_keywords` VALUES (290, 'управления');
INSERT INTO `spider_keywords` VALUES (291, 'усиливает');
INSERT INTO `spider_keywords` VALUES (292, 'услуги');
INSERT INTO `spider_keywords` VALUES (293, 'утверждал');
INSERT INTO `spider_keywords` VALUES (294, 'учитывая');
INSERT INTO `spider_keywords` VALUES (295, 'февраля');
INSERT INTO `spider_keywords` VALUES (296, 'формат');
INSERT INTO `spider_keywords` VALUES (297, 'формулирует');
INSERT INTO `spider_keywords` VALUES (298, 'художественная');
INSERT INTO `spider_keywords` VALUES (299, 'художественно-продуктивного');
INSERT INTO `spider_keywords` VALUES (300, 'целевой');
INSERT INTO `spider_keywords` VALUES (301, 'целое');
INSERT INTO `spider_keywords` VALUES (302, 'цен');
INSERT INTO `spider_keywords` VALUES (303, 'цены');
INSERT INTO `spider_keywords` VALUES (304, 'часов');
INSERT INTO `spider_keywords` VALUES (305, 'часть');
INSERT INTO `spider_keywords` VALUES (306, 'что');
INSERT INTO `spider_keywords` VALUES (307, 'шесть');
INSERT INTO `spider_keywords` VALUES (308, 'шиллер');
INSERT INTO `spider_keywords` VALUES (309, 'это');
INSERT INTO `spider_keywords` VALUES (310, 'этого');
INSERT INTO `spider_keywords` VALUES (311, 'яндекс');
INSERT INTO `spider_keywords` VALUES (312, 'вакансии');
INSERT INTO `spider_keywords` VALUES (313, 'за');
INSERT INTO `spider_keywords` VALUES (314, 'заполнения');
INSERT INTO `spider_keywords` VALUES (315, 'извинения');
INSERT INTO `spider_keywords` VALUES (316, 'информации');
INSERT INTO `spider_keywords` VALUES (317, 'находится');
INSERT INTO `spider_keywords` VALUES (318, 'неудобства');
INSERT INTO `spider_keywords` VALUES (319, 'предоставленные');
INSERT INTO `spider_keywords` VALUES (320, 'приносим');
INSERT INTO `spider_keywords` VALUES (321, 'свои');
INSERT INTO `spider_keywords` VALUES (322, 'стадии');
INSERT INTO `spider_keywords` VALUES (323, '08');
INSERT INTO `spider_keywords` VALUES (324, 'аудитории');
INSERT INTO `spider_keywords` VALUES (325, 'аудитория');
INSERT INTO `spider_keywords` VALUES (326, 'ауэрбаха');
INSERT INTO `spider_keywords` VALUES (327, 'бренд');
INSERT INTO `spider_keywords` VALUES (328, 'бы');
INSERT INTO `spider_keywords` VALUES (329, 'встретить');
INSERT INTO `spider_keywords` VALUES (330, 'выстраивает');
INSERT INTO `spider_keywords` VALUES (331, 'выше');
INSERT INTO `spider_keywords` VALUES (332, 'готично');
INSERT INTO `spider_keywords` VALUES (333, 'действительно');
INSERT INTO `spider_keywords` VALUES (334, 'декаданс');
INSERT INTO `spider_keywords` VALUES (335, 'законы');
INSERT INTO `spider_keywords` VALUES (336, 'изложенной');
INSERT INTO `spider_keywords` VALUES (337, 'изящно');
INSERT INTO `spider_keywords` VALUES (338, 'имитирует');
INSERT INTO `spider_keywords` VALUES (339, 'интенция');
INSERT INTO `spider_keywords` VALUES (340, 'иррациональное');
INSERT INTO `spider_keywords` VALUES (341, 'искусства');
INSERT INTO `spider_keywords` VALUES (342, 'июля');
INSERT INTO `spider_keywords` VALUES (343, 'казалось');
INSERT INTO `spider_keywords` VALUES (344, 'контрастирующего');
INSERT INTO `spider_keywords` VALUES (345, 'лидерство');
INSERT INTO `spider_keywords` VALUES (346, 'медиавес');
INSERT INTO `spider_keywords` VALUES (347, 'менеджмента');
INSERT INTO `spider_keywords` VALUES (348, 'меняя');
INSERT INTO `spider_keywords` VALUES (349, 'мистерия');
INSERT INTO `spider_keywords` VALUES (350, 'миф');
INSERT INTO `spider_keywords` VALUES (351, 'можно');
INSERT INTO `spider_keywords` VALUES (352, 'молодежная');
INSERT INTO `spider_keywords` VALUES (353, 'монотонно');
INSERT INTO `spider_keywords` VALUES (354, 'монтаж');
INSERT INTO `spider_keywords` VALUES (355, 'незначительный');
INSERT INTO `spider_keywords` VALUES (356, 'неизменный');
INSERT INTO `spider_keywords` VALUES (357, 'нейтрализует');
INSERT INTO `spider_keywords` VALUES (358, 'ни');
INSERT INTO `spider_keywords` VALUES (359, 'нишевый');
INSERT INTO `spider_keywords` VALUES (360, 'новостей');
INSERT INTO `spider_keywords` VALUES (361, 'образует');
INSERT INTO `spider_keywords` VALUES (362, 'объемная');
INSERT INTO `spider_keywords` VALUES (363, 'охват');
INSERT INTO `spider_keywords` VALUES (364, 'парадоксальным');
INSERT INTO `spider_keywords` VALUES (365, 'переворачивает');
INSERT INTO `spider_keywords` VALUES (366, 'подобное');
INSERT INTO `spider_keywords` VALUES (367, 'поэтому');
INSERT INTO `spider_keywords` VALUES (368, 'принципвосприятия');
INSERT INTO `spider_keywords` VALUES (369, 'притягивает');
INSERT INTO `spider_keywords` VALUES (370, 'продажах');
INSERT INTO `spider_keywords` VALUES (371, 'проект');
INSERT INTO `spider_keywords` VALUES (372, 'процессов');
INSERT INTO `spider_keywords` VALUES (373, 'психике');
INSERT INTO `spider_keywords` VALUES (374, 'работах');
INSERT INTO `spider_keywords` VALUES (375, 'развития');
INSERT INTO `spider_keywords` VALUES (376, 'ребрендинг');
INSERT INTO `spider_keywords` VALUES (377, 'ролевой');
INSERT INTO `spider_keywords` VALUES (378, 'рыночная');
INSERT INTO `spider_keywords` VALUES (379, 'семиотика');
INSERT INTO `spider_keywords` VALUES (380, 'ситуация');
INSERT INTO `spider_keywords` VALUES (381, 'скидка');
INSERT INTO `spider_keywords` VALUES (382, 'списку');
INSERT INTO `spider_keywords` VALUES (383, 'стиль');
INSERT INTO `spider_keywords` VALUES (384, 'стремительно');
INSERT INTO `spider_keywords` VALUES (385, 'сходные');
INSERT INTO `spider_keywords` VALUES (386, 'тактический');
INSERT INTO `spider_keywords` VALUES (387, 'тандлера');
INSERT INTO `spider_keywords` VALUES (388, 'творчестве');
INSERT INTO `spider_keywords` VALUES (389, 'тому');
INSERT INTO `spider_keywords` VALUES (390, 'характерны');
INSERT INTO `spider_keywords` VALUES (391, 'хтонический');
INSERT INTO `spider_keywords` VALUES (392, 'что-то');
INSERT INTO `spider_keywords` VALUES (393, 'экономит');
INSERT INTO `spider_keywords` VALUES (394, '04');
INSERT INTO `spider_keywords` VALUES (395, 'амбивалентно');
INSERT INTO `spider_keywords` VALUES (396, 'артистизма');
INSERT INTO `spider_keywords` VALUES (397, 'базовый');
INSERT INTO `spider_keywords` VALUES (398, 'богатство');
INSERT INTO `spider_keywords` VALUES (399, 'восприятие');
INSERT INTO `spider_keywords` VALUES (400, 'всегда');
INSERT INTO `spider_keywords` VALUES (401, 'вызывает');
INSERT INTO `spider_keywords` VALUES (402, 'движущих');
INSERT INTO `spider_keywords` VALUES (403, 'до');
INSERT INTO `spider_keywords` VALUES (404, 'долю');
INSERT INTO `spider_keywords` VALUES (405, 'з');
INSERT INTO `spider_keywords` VALUES (406, 'заканчивает');
INSERT INTO `spider_keywords` VALUES (407, 'игры');
INSERT INTO `spider_keywords` VALUES (408, 'именно');
INSERT INTO `spider_keywords` VALUES (409, 'инсайдерскую');
INSERT INTO `spider_keywords` VALUES (410, 'инструмент');
INSERT INTO `spider_keywords` VALUES (411, 'информацию');
INSERT INTO `spider_keywords` VALUES (412, 'искажает');
INSERT INTO `spider_keywords` VALUES (413, 'искусств');
INSERT INTO `spider_keywords` VALUES (414, 'каждая');
INSERT INTO `spider_keywords` VALUES (415, 'какследуетизвышесказанного');
INSERT INTO `spider_keywords` VALUES (416, 'катарсис');
INSERT INTO `spider_keywords` VALUES (417, 'комплексе');
INSERT INTO `spider_keywords` VALUES (418, 'композиционный');
INSERT INTO `spider_keywords` VALUES (419, 'контент');
INSERT INTO `spider_keywords` VALUES (420, 'литературы');
INSERT INTO `spider_keywords` VALUES (421, 'личности');
INSERT INTO `spider_keywords` VALUES (422, 'марки');
INSERT INTO `spider_keywords` VALUES (423, 'медиапланирование');
INSERT INTO `spider_keywords` VALUES (424, 'мировой');
INSERT INTO `spider_keywords` VALUES (425, 'направленный');
INSERT INTO `spider_keywords` VALUES (426, 'начинает');
INSERT INTO `spider_keywords` VALUES (427, 'непредсказуемо');
INSERT INTO `spider_keywords` VALUES (428, 'об');
INSERT INTO `spider_keywords` VALUES (429, 'однако');
INSERT INTO `spider_keywords` VALUES (430, 'оправдывает');
INSERT INTO `spider_keywords` VALUES (431, 'ортеги-и-гассета');
INSERT INTO `spider_keywords` VALUES (432, 'особенность');
INSERT INTO `spider_keywords` VALUES (433, 'от');
INSERT INTO `spider_keywords` VALUES (434, 'охватывает');
INSERT INTO `spider_keywords` VALUES (435, 'писал');
INSERT INTO `spider_keywords` VALUES (436, 'планирования');
INSERT INTO `spider_keywords` VALUES (437, 'платона');
INSERT INTO `spider_keywords` VALUES (438, 'позиционирует');
INSERT INTO `spider_keywords` VALUES (439, 'полагаясь');
INSERT INTO `spider_keywords` VALUES (440, 'принцип');
INSERT INTO `spider_keywords` VALUES (441, 'процесс');
INSERT INTO `spider_keywords` VALUES (442, 'расширяя');
INSERT INTO `spider_keywords` VALUES (443, 'реально');
INSERT INTO `spider_keywords` VALUES (444, 'рекламы');
INSERT INTO `spider_keywords` VALUES (445, 'само');
INSERT INTO `spider_keywords` VALUES (446, 'свидетельствует');
INSERT INTO `spider_keywords` VALUES (447, 'себе');
INSERT INTO `spider_keywords` VALUES (448, 'сил');
INSERT INTO `spider_keywords` VALUES (449, 'синтез');
INSERT INTO `spider_keywords` VALUES (450, 'следовательно');
INSERT INTO `spider_keywords` VALUES (451, 'состояние');
INSERT INTO `spider_keywords` VALUES (452, 'социометрический');
INSERT INTO `spider_keywords` VALUES (453, 'стабилизирует');
INSERT INTO `spider_keywords` VALUES (454, 'стратегического');
INSERT INTO `spider_keywords` VALUES (455, 'сублимации');
INSERT INTO `spider_keywords` VALUES (456, 'существенно');
INSERT INTO `spider_keywords` VALUES (457, 'сфера');
INSERT INTO `spider_keywords` VALUES (458, 'теории');
INSERT INTO `spider_keywords` VALUES (459, 'тип');
INSERT INTO `spider_keywords` VALUES (460, 'том');
INSERT INTO `spider_keywords` VALUES (461, 'трафик');
INSERT INTO `spider_keywords` VALUES (462, 'ускоряет');
INSERT INTO `spider_keywords` VALUES (463, 'фарс');
INSERT INTO `spider_keywords` VALUES (464, 'фрейд');
INSERT INTO `spider_keywords` VALUES (465, 'эпитет');
INSERT INTO `spider_keywords` VALUES (466, 'эротическое');
INSERT INTO `spider_keywords` VALUES (467, 'этом');
INSERT INTO `spider_keywords` VALUES (468, 'email');
INSERT INTO `spider_keywords` VALUES (469, 'заказа');
INSERT INTO `spider_keywords` VALUES (470, 'компания');
INSERT INTO `spider_keywords` VALUES (471, 'контактные');
INSERT INTO `spider_keywords` VALUES (472, 'контакты');
INSERT INTO `spider_keywords` VALUES (473, 'новое');
INSERT INTO `spider_keywords` VALUES (474, 'подробности');
INSERT INTO `spider_keywords` VALUES (475, 'поле');
INSERT INTO `spider_keywords` VALUES (476, 'фио');
INSERT INTO `spider_keywords` VALUES (477, 'карта');
INSERT INTO `spider_keywords` VALUES (478, 'поиск');
INSERT INTO `spider_keywords` VALUES (479, 'сайту');
INSERT INTO `spider_keywords` VALUES (480, 'отзывы');
INSERT INTO `spider_keywords` VALUES (481, 'пишите');
INSERT INTO `spider_keywords` VALUES (482, 'спешите');
INSERT INTO `spider_keywords` VALUES (483, 'а');
INSERT INTO `spider_keywords` VALUES (484, 'аксиология');
INSERT INTO `spider_keywords` VALUES (485, 'анализа');
INSERT INTO `spider_keywords` VALUES (486, 'берталанфи');
INSERT INTO `spider_keywords` VALUES (487, 'бессознательный');
INSERT INTO `spider_keywords` VALUES (488, 'бюлера');
INSERT INTO `spider_keywords` VALUES (489, 'второй');
INSERT INTO `spider_keywords` VALUES (490, 'гармонично');
INSERT INTO `spider_keywords` VALUES (491, 'героическое');
INSERT INTO `spider_keywords` VALUES (492, 'гипотеза');
INSERT INTO `spider_keywords` VALUES (493, 'интегрирована');
INSERT INTO `spider_keywords` VALUES (494, 'кластерного');
INSERT INTO `spider_keywords` VALUES (495, 'комплекс');
INSERT INTO `spider_keywords` VALUES (496, 'метод');
INSERT INTO `spider_keywords` VALUES (497, 'нередуцируемость');
INSERT INTO `spider_keywords` VALUES (498, 'онтогенез');
INSERT INTO `spider_keywords` VALUES (499, 'опосредование');
INSERT INTO `spider_keywords` VALUES (500, 'получил');
INSERT INTO `spider_keywords` VALUES (501, 'потребительский');
INSERT INTO `spider_keywords` VALUES (502, 'разработку');
INSERT INTO `spider_keywords` VALUES (503, 'рынок');
INSERT INTO `spider_keywords` VALUES (504, 'содержания');
INSERT INTO `spider_keywords` VALUES (505, 'специфицирует');
INSERT INTO `spider_keywords` VALUES (506, 'суггестивный');
INSERT INTO `spider_keywords` VALUES (507, 'трудах');
INSERT INTO `spider_keywords` VALUES (508, 'факт');
INSERT INTO `spider_keywords` VALUES (509, 'художественное');
INSERT INTO `spider_keywords` VALUES (510, 'ш');
INSERT INTO `spider_keywords` VALUES (511, 'экспрессионизм');
INSERT INTO `spider_keywords` VALUES (512, 'этикет');
INSERT INTO `spider_keywords` VALUES (513, '1');
INSERT INTO `spider_keywords` VALUES (514, '2003-2010');
INSERT INTO `spider_keywords` VALUES (515, '3');
INSERT INTO `spider_keywords` VALUES (516, '2008');
INSERT INTO `spider_keywords` VALUES (517, 'build');
INSERT INTO `spider_keywords` VALUES (518, 'cookie');
INSERT INTO `spider_keywords` VALUES (519, 'copy');
INSERT INTO `spider_keywords` VALUES (520, 'ctrl');
INSERT INTO `spider_keywords` VALUES (521, 'f5');
INSERT INTO `spider_keywords` VALUES (522, 'DOMAIN_NAME');
INSERT INTO `spider_keywords` VALUES (523, 'ip');
INSERT INTO `spider_keywords` VALUES (524, 'obsudim');
INSERT INTO `spider_keywords` VALUES (525, 'www');
INSERT INTO `spider_keywords` VALUES (526, 'адреса');
INSERT INTO `spider_keywords` VALUES (527, 'верны');
INSERT INTO `spider_keywords` VALUES (528, 'включите');
INSERT INTO `spider_keywords` VALUES (529, 'выключены');
INSERT INTO `spider_keywords` VALUES (530, 'дизайна');
INSERT INTO `spider_keywords` VALUES (531, 'доступ');
INSERT INTO `spider_keywords` VALUES (532, 'забыли');
INSERT INTO `spider_keywords` VALUES (533, 'запрещен');
INSERT INTO `spider_keywords` VALUES (534, 'или');
INSERT INTO `spider_keywords` VALUES (535, 'их');
INSERT INTO `spider_keywords` VALUES (536, 'неверного');
INSERT INTO `spider_keywords` VALUES (537, 'перезагрузите');
INSERT INTO `spider_keywords` VALUES (538, 'попытка');
INSERT INTO `spider_keywords` VALUES (539, 'сайтом');
INSERT INTO `spider_keywords` VALUES (540, 'система');
INSERT INTO `spider_keywords` VALUES (541, 'страницуc');
INSERT INTO `spider_keywords` VALUES (542, 'студия');
INSERT INTO `spider_keywords` VALUES (543, '01');
INSERT INTO `spider_keywords` VALUES (544, 'агрессивности');
INSERT INTO `spider_keywords` VALUES (545, 'акция');
INSERT INTO `spider_keywords` VALUES (546, 'безусловно');
INSERT INTO `spider_keywords` VALUES (547, 'взгляд');
INSERT INTO `spider_keywords` VALUES (548, 'врамкахсегодняшнихвоззрений');
INSERT INTO `spider_keywords` VALUES (549, 'выступает');
INSERT INTO `spider_keywords` VALUES (550, 'довольно');
INSERT INTO `spider_keywords` VALUES (551, 'его');
INSERT INTO `spider_keywords` VALUES (552, 'игровое');
INSERT INTO `spider_keywords` VALUES (553, 'инвариант');
INSERT INTO `spider_keywords` VALUES (554, 'инвестиционный');
INSERT INTO `spider_keywords` VALUES (555, 'исключительно');
INSERT INTO `spider_keywords` VALUES (556, 'используя');
INSERT INTO `spider_keywords` VALUES (557, 'июня');
INSERT INTO `spider_keywords` VALUES (558, 'какпринятосчитать');
INSERT INTO `spider_keywords` VALUES (559, 'кампаний');
INSERT INTO `spider_keywords` VALUES (560, 'котлеру');
INSERT INTO `spider_keywords` VALUES (561, 'мерчандайзинга');
INSERT INTO `spider_keywords` VALUES (562, 'метафоризм');
INSERT INTO `spider_keywords` VALUES (563, 'мотив');
INSERT INTO `spider_keywords` VALUES (564, 'начало');
INSERT INTO `spider_keywords` VALUES (565, 'онтологический');
INSERT INTO `spider_keywords` VALUES (566, 'первый');
INSERT INTO `spider_keywords` VALUES (567, 'переходное');
INSERT INTO `spider_keywords` VALUES (568, 'персональный');
INSERT INTO `spider_keywords` VALUES (569, 'побудительный');
INSERT INTO `spider_keywords` VALUES (570, 'портрет');
INSERT INTO `spider_keywords` VALUES (571, 'потребителя');
INSERT INTO `spider_keywords` VALUES (572, 'предмет');
INSERT INTO `spider_keywords` VALUES (573, 'привлечение');
INSERT INTO `spider_keywords` VALUES (574, 'продукт');
INSERT INTO `spider_keywords` VALUES (575, 'продуцирует');
INSERT INTO `spider_keywords` VALUES (576, 'производство');
INSERT INTO `spider_keywords` VALUES (577, 'рекламная');
INSERT INTO `spider_keywords` VALUES (578, 'сбалансирован');
INSERT INTO `spider_keywords` VALUES (579, 'сбыта');
INSERT INTO `spider_keywords` VALUES (580, 'свободна');
INSERT INTO `spider_keywords` VALUES (581, 'символизм');
INSERT INTO `spider_keywords` VALUES (582, 'символический');
INSERT INTO `spider_keywords` VALUES (583, 'согласно');
INSERT INTO `spider_keywords` VALUES (584, 'сокращенный');
INSERT INTO `spider_keywords` VALUES (585, 'стимулирование');
INSERT INTO `spider_keywords` VALUES (586, 'творчества');
INSERT INTO `spider_keywords` VALUES (587, 'тоска');
INSERT INTO `spider_keywords` VALUES (588, 'ф');
INSERT INTO `spider_keywords` VALUES (589, 'фактографический');
INSERT INTO `spider_keywords` VALUES (590, 'филогенез');
INSERT INTO `spider_keywords` VALUES (591, 'хорошо');
INSERT INTO `spider_keywords` VALUES (592, 'эволюция');
INSERT INTO `spider_keywords` VALUES (593, 'эйдос');
INSERT INTO `spider_keywords` VALUES (594, 'экзистенциальная');
INSERT INTO `spider_keywords` VALUES (595, 'эпоха');
INSERT INTO `spider_keywords` VALUES (596, '07');
INSERT INTO `spider_keywords` VALUES (597, 'адекватная');
INSERT INTO `spider_keywords` VALUES (598, 'бессознательное');
INSERT INTO `spider_keywords` VALUES (599, 'бизнес-стратегия');
INSERT INTO `spider_keywords` VALUES (600, 'бриф');
INSERT INTO `spider_keywords` VALUES (601, 'гений');
INSERT INTO `spider_keywords` VALUES (602, 'дает');
INSERT INTO `spider_keywords` VALUES (603, 'конкурентов');
INSERT INTO `spider_keywords` VALUES (604, 'конструктивно');
INSERT INTO `spider_keywords` VALUES (605, 'майкл');
INSERT INTO `spider_keywords` VALUES (606, 'маньеризм');
INSERT INTO `spider_keywords` VALUES (607, 'медийный');
INSERT INTO `spider_keywords` VALUES (608, 'ментальность');
INSERT INTO `spider_keywords` VALUES (609, 'мескон');
INSERT INTO `spider_keywords` VALUES (610, 'мутации');
INSERT INTO `spider_keywords` VALUES (611, 'над');
INSERT INTO `spider_keywords` VALUES (612, 'невзирая');
INSERT INTO `spider_keywords` VALUES (613, 'невротический');
INSERT INTO `spider_keywords` VALUES (614, 'неестественно');
INSERT INTO `spider_keywords` VALUES (615, 'определенные');
INSERT INTO `spider_keywords` VALUES (616, 'определяет');
INSERT INTO `spider_keywords` VALUES (617, 'отмечает');
INSERT INTO `spider_keywords` VALUES (618, 'поддерживает');
INSERT INTO `spider_keywords` VALUES (619, 'постоянно');
INSERT INTO `spider_keywords` VALUES (620, 'предсказывают');
INSERT INTO `spider_keywords` VALUES (621, 'признавая');
INSERT INTO `spider_keywords` VALUES (622, 'продолжает');
INSERT INTO `spider_keywords` VALUES (623, 'проектом');
INSERT INTO `spider_keywords` VALUES (624, 'психической');
INSERT INTO `spider_keywords` VALUES (625, 'работая');
INSERT INTO `spider_keywords` VALUES (626, 'раскручивает');
INSERT INTO `spider_keywords` VALUES (627, 'рыночные');
INSERT INTO `spider_keywords` VALUES (628, 'системный');
INSERT INTO `spider_keywords` VALUES (629, 'сотворчества');
INSERT INTO `spider_keywords` VALUES (630, 'трагическое');
INSERT INTO `spider_keywords` VALUES (631, 'феномер');
INSERT INTO `spider_keywords` VALUES (632, 'футурологи');
INSERT INTO `spider_keywords` VALUES (633, 'числе');
INSERT INTO `spider_keywords` VALUES (634, 'войти');
INSERT INTO `spider_keywords` VALUES (635, 'систему');

-- --------------------------------------------------------

-- 
-- Структура таблицы `spider_link_keyword0`
-- 

DROP TABLE IF EXISTS `spider_link_keyword0`;
CREATE TABLE IF NOT EXISTS `spider_link_keyword0` (
  `spider_link_id` int(11) NOT NULL,
  `spider_keyword_id` int(11) NOT NULL,
  `spider_keyword_weight` int(3) default NULL,
  `spider_domain_id` int(4) default NULL,
  KEY `linkid` (`spider_link_id`),
  KEY `keyid` (`spider_keyword_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `spider_link_keyword0`
-- 

INSERT INTO `spider_link_keyword0` VALUES (1, 26, 10, 1);
INSERT INTO `spider_link_keyword0` VALUES (1, 46, 10, 1);
INSERT INTO `spider_link_keyword0` VALUES (1, 66, 10, 1);
INSERT INTO `spider_link_keyword0` VALUES (1, 79, 10, 1);
INSERT INTO `spider_link_keyword0` VALUES (1, 83, 10, 1);
INSERT INTO `spider_link_keyword0` VALUES (1, 114, 40, 1);
INSERT INTO `spider_link_keyword0` VALUES (1, 152, 10, 1);
INSERT INTO `spider_link_keyword0` VALUES (1, 155, 10, 1);
INSERT INTO `spider_link_keyword0` VALUES (1, 166, 10, 1);
INSERT INTO `spider_link_keyword0` VALUES (1, 185, 10, 1);
INSERT INTO `spider_link_keyword0` VALUES (1, 195, 10, 1);
INSERT INTO `spider_link_keyword0` VALUES (1, 212, 10, 1);
INSERT INTO `spider_link_keyword0` VALUES (1, 238, 10, 1);
INSERT INTO `spider_link_keyword0` VALUES (1, 239, 10, 1);
INSERT INTO `spider_link_keyword0` VALUES (1, 261, 10, 1);
INSERT INTO `spider_link_keyword0` VALUES (2, 322, 8, 1);
INSERT INTO `spider_link_keyword0` VALUES (3, 324, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (3, 336, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (3, 114, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (3, 349, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (3, 239, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (3, 261, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (3, 389, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (4, 402, 14, 1);
INSERT INTO `spider_link_keyword0` VALUES (4, 403, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (4, 410, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (4, 114, 14, 1);
INSERT INTO `spider_link_keyword0` VALUES (4, 423, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (4, 152, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (4, 430, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (4, 434, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (4, 185, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (4, 445, 14, 1);
INSERT INTO `spider_link_keyword0` VALUES (4, 261, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (4, 454, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (4, 462, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (4, 466, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (5, 468, 8, 1);
INSERT INTO `spider_link_keyword0` VALUES (5, 472, 16, 1);
INSERT INTO `spider_link_keyword0` VALUES (5, 474, 8, 1);
INSERT INTO `spider_link_keyword0` VALUES (6, 472, 8, 1);
INSERT INTO `spider_link_keyword0` VALUES (7, 238, 8, 1);
INSERT INTO `spider_link_keyword0` VALUES (10, 238, 8, 1);
INSERT INTO `spider_link_keyword0` VALUES (12, 322, 8, 1);
INSERT INTO `spider_link_keyword0` VALUES (13, 322, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (14, 322, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (15, 322, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (16, 485, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (16, 491, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (16, 492, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (16, 402, 14, 1);
INSERT INTO `spider_link_keyword0` VALUES (16, 336, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (16, 114, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (16, 423, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (16, 498, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (16, 185, 14, 1);
INSERT INTO `spider_link_keyword0` VALUES (16, 239, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (16, 261, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (16, 454, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (17, 322, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (18, 538, 8, 1);
INSERT INTO `spider_link_keyword0` VALUES (19, 485, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (19, 324, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (19, 491, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (19, 492, 14, 1);
INSERT INTO `spider_link_keyword0` VALUES (19, 402, 14, 1);
INSERT INTO `spider_link_keyword0` VALUES (19, 336, 14, 1);
INSERT INTO `spider_link_keyword0` VALUES (19, 423, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (19, 430, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (19, 434, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (19, 185, 14, 1);
INSERT INTO `spider_link_keyword0` VALUES (19, 572, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (19, 445, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (19, 587, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (19, 462, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (19, 589, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (20, 485, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (20, 402, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (20, 423, 14, 1);
INSERT INTO `spider_link_keyword0` VALUES (20, 613, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (20, 498, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (20, 615, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (20, 185, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (20, 212, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (20, 445, 7, 1);
INSERT INTO `spider_link_keyword0` VALUES (20, 454, 7, 1);

-- --------------------------------------------------------

-- 
-- Структура таблицы `spider_link_keyword1`
-- 

DROP TABLE IF EXISTS `spider_link_keyword1`;
CREATE TABLE IF NOT EXISTS `spider_link_keyword1` (
  `spider_link_id` int(11) NOT NULL,
  `spider_keyword_id` int(11) NOT NULL,
  `spider_keyword_weight` int(3) default NULL,
  `spider_domain_id` int(4) default NULL,
  KEY `linkid` (`spider_link_id`),
  KEY `keyid` (`spider_keyword_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `spider_link_keyword1`
-- 

INSERT INTO `spider_link_keyword1` VALUES (1, 14, 10, 1);
INSERT INTO `spider_link_keyword1` VALUES (1, 15, 10, 1);
INSERT INTO `spider_link_keyword1` VALUES (1, 50, 10, 1);
INSERT INTO `spider_link_keyword1` VALUES (1, 75, 10, 1);
INSERT INTO `spider_link_keyword1` VALUES (1, 96, 10, 1);
INSERT INTO `spider_link_keyword1` VALUES (1, 97, 10, 1);
INSERT INTO `spider_link_keyword1` VALUES (1, 106, 40, 1);
INSERT INTO `spider_link_keyword1` VALUES (1, 122, 10, 1);
INSERT INTO `spider_link_keyword1` VALUES (1, 141, 40, 1);
INSERT INTO `spider_link_keyword1` VALUES (1, 154, 10, 1);
INSERT INTO `spider_link_keyword1` VALUES (1, 160, 30, 1);
INSERT INTO `spider_link_keyword1` VALUES (1, 180, 30, 1);
INSERT INTO `spider_link_keyword1` VALUES (1, 187, 10, 1);
INSERT INTO `spider_link_keyword1` VALUES (1, 246, 10, 1);
INSERT INTO `spider_link_keyword1` VALUES (1, 262, 10, 1);
INSERT INTO `spider_link_keyword1` VALUES (1, 269, 20, 1);
INSERT INTO `spider_link_keyword1` VALUES (1, 281, 10, 1);
INSERT INTO `spider_link_keyword1` VALUES (3, 75, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (3, 335, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (3, 106, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (3, 141, 21, 1);
INSERT INTO `spider_link_keyword1` VALUES (3, 361, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (3, 160, 14, 1);
INSERT INTO `spider_link_keyword1` VALUES (3, 364, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (3, 180, 14, 1);
INSERT INTO `spider_link_keyword1` VALUES (3, 377, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (3, 378, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (3, 382, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (3, 281, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (4, 50, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (4, 75, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (4, 407, 14, 1);
INSERT INTO `spider_link_keyword1` VALUES (4, 96, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (4, 97, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (4, 420, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (4, 424, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (4, 428, 14, 1);
INSERT INTO `spider_link_keyword1` VALUES (4, 180, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (4, 382, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (4, 453, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (4, 269, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (5, 469, 8, 1);
INSERT INTO `spider_link_keyword1` VALUES (7, 187, 8, 1);
INSERT INTO `spider_link_keyword1` VALUES (8, 187, 8, 1);
INSERT INTO `spider_link_keyword1` VALUES (8, 382, 8, 1);
INSERT INTO `spider_link_keyword1` VALUES (9, 382, 8, 1);
INSERT INTO `spider_link_keyword1` VALUES (10, 382, 8, 1);
INSERT INTO `spider_link_keyword1` VALUES (16, 487, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (16, 75, 14, 1);
INSERT INTO `spider_link_keyword1` VALUES (16, 97, 14, 1);
INSERT INTO `spider_link_keyword1` VALUES (16, 106, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (16, 141, 21, 1);
INSERT INTO `spider_link_keyword1` VALUES (16, 497, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (16, 428, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (16, 160, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (16, 269, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (16, 281, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (18, 519, 8, 1);
INSERT INTO `spider_link_keyword1` VALUES (18, 15, 433, 1);
INSERT INTO `spider_link_keyword1` VALUES (18, 524, 8, 1);
INSERT INTO `spider_link_keyword1` VALUES (18, 141, 8, 1);
INSERT INTO `spider_link_keyword1` VALUES (19, 545, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (19, 487, 21, 1);
INSERT INTO `spider_link_keyword1` VALUES (19, 75, 14, 1);
INSERT INTO `spider_link_keyword1` VALUES (19, 552, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (19, 407, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (19, 97, 14, 1);
INSERT INTO `spider_link_keyword1` VALUES (19, 560, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (19, 562, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (19, 141, 28, 1);
INSERT INTO `spider_link_keyword1` VALUES (19, 428, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (19, 361, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (19, 160, 14, 1);
INSERT INTO `spider_link_keyword1` VALUES (19, 582, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (19, 382, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (19, 585, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (20, 75, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (20, 335, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (20, 407, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (20, 97, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (20, 122, 14, 1);
INSERT INTO `spider_link_keyword1` VALUES (20, 141, 14, 1);
INSERT INTO `spider_link_keyword1` VALUES (20, 497, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (20, 428, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (20, 627, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (20, 382, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (20, 585, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (20, 269, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (20, 281, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (20, 631, 7, 1);
INSERT INTO `spider_link_keyword1` VALUES (21, 524, 364, 1);
INSERT INTO `spider_link_keyword1` VALUES (21, 15, 364, 1);

-- --------------------------------------------------------

-- 
-- Структура таблицы `spider_link_keyword2`
-- 

DROP TABLE IF EXISTS `spider_link_keyword2`;
CREATE TABLE IF NOT EXISTS `spider_link_keyword2` (
  `spider_link_id` int(11) NOT NULL,
  `spider_keyword_id` int(11) NOT NULL,
  `spider_keyword_weight` int(3) default NULL,
  `spider_domain_id` int(4) default NULL,
  KEY `linkid` (`spider_link_id`),
  KEY `keyid` (`spider_keyword_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `spider_link_keyword2`
-- 

INSERT INTO `spider_link_keyword2` VALUES (1, 10, 10, 1);
INSERT INTO `spider_link_keyword2` VALUES (1, 32, 10, 1);
INSERT INTO `spider_link_keyword2` VALUES (1, 35, 10, 1);
INSERT INTO `spider_link_keyword2` VALUES (1, 39, 10, 1);
INSERT INTO `spider_link_keyword2` VALUES (1, 57, 10, 1);
INSERT INTO `spider_link_keyword2` VALUES (1, 76, 30, 1);
INSERT INTO `spider_link_keyword2` VALUES (1, 100, 10, 1);
INSERT INTO `spider_link_keyword2` VALUES (1, 112, 10, 1);
INSERT INTO `spider_link_keyword2` VALUES (1, 137, 10, 1);
INSERT INTO `spider_link_keyword2` VALUES (1, 167, 10, 1);
INSERT INTO `spider_link_keyword2` VALUES (1, 169, 10, 1);
INSERT INTO `spider_link_keyword2` VALUES (1, 173, 10, 1);
INSERT INTO `spider_link_keyword2` VALUES (1, 178, 10, 1);
INSERT INTO `spider_link_keyword2` VALUES (1, 193, 10, 1);
INSERT INTO `spider_link_keyword2` VALUES (1, 209, 10, 1);
INSERT INTO `spider_link_keyword2` VALUES (1, 213, 10, 1);
INSERT INTO `spider_link_keyword2` VALUES (1, 234, 10, 1);
INSERT INTO `spider_link_keyword2` VALUES (1, 244, 10, 1);
INSERT INTO `spider_link_keyword2` VALUES (1, 249, 10, 1);
INSERT INTO `spider_link_keyword2` VALUES (1, 264, 10, 1);
INSERT INTO `spider_link_keyword2` VALUES (1, 294, 20, 1);
INSERT INTO `spider_link_keyword2` VALUES (1, 297, 10, 1);
INSERT INTO `spider_link_keyword2` VALUES (1, 298, 10, 1);
INSERT INTO `spider_link_keyword2` VALUES (1, 304, 10, 1);
INSERT INTO `spider_link_keyword2` VALUES (1, 307, 10, 1);
INSERT INTO `spider_link_keyword2` VALUES (2, 318, 8, 1);
INSERT INTO `spider_link_keyword2` VALUES (3, 32, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (3, 35, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (3, 39, 14, 1);
INSERT INTO `spider_link_keyword2` VALUES (3, 57, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (3, 76, 14, 1);
INSERT INTO `spider_link_keyword2` VALUES (3, 173, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (3, 375, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (3, 297, 21, 1);
INSERT INTO `spider_link_keyword2` VALUES (4, 32, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (4, 35, 14, 1);
INSERT INTO `spider_link_keyword2` VALUES (4, 406, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (4, 419, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (4, 169, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (4, 173, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (4, 234, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (4, 452, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (4, 457, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (4, 294, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (4, 298, 14, 1);
INSERT INTO `spider_link_keyword2` VALUES (4, 307, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (4, 467, 14, 1);
INSERT INTO `spider_link_keyword2` VALUES (7, 137, 8, 1);
INSERT INTO `spider_link_keyword2` VALUES (10, 137, 8, 1);
INSERT INTO `spider_link_keyword2` VALUES (12, 318, 8, 1);
INSERT INTO `spider_link_keyword2` VALUES (13, 318, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (14, 318, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (15, 318, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (16, 32, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (16, 486, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (16, 35, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (16, 39, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (16, 57, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (16, 406, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (16, 76, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (16, 173, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (16, 502, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (16, 503, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (16, 234, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (16, 294, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (16, 297, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (16, 298, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (16, 307, 14, 1);
INSERT INTO `spider_link_keyword2` VALUES (16, 467, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (17, 318, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (18, 518, 8, 1);
INSERT INTO `spider_link_keyword2` VALUES (18, 534, 8, 1);
INSERT INTO `spider_link_keyword2` VALUES (18, 112, 8, 1);
INSERT INTO `spider_link_keyword2` VALUES (19, 486, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (19, 406, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (19, 76, 14, 1);
INSERT INTO `spider_link_keyword2` VALUES (19, 178, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (19, 193, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (19, 502, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (19, 503, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (19, 580, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (19, 264, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (19, 294, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (19, 297, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (19, 298, 14, 1);
INSERT INTO `spider_link_keyword2` VALUES (19, 307, 14, 1);
INSERT INTO `spider_link_keyword2` VALUES (19, 594, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (19, 595, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (19, 467, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (20, 602, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (20, 406, 14, 1);
INSERT INTO `spider_link_keyword2` VALUES (20, 193, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (20, 375, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (20, 452, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (20, 294, 14, 1);
INSERT INTO `spider_link_keyword2` VALUES (20, 307, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (20, 467, 7, 1);
INSERT INTO `spider_link_keyword2` VALUES (21, 634, 7, 1);

-- --------------------------------------------------------

-- 
-- Структура таблицы `spider_link_keyword3`
-- 

DROP TABLE IF EXISTS `spider_link_keyword3`;
CREATE TABLE IF NOT EXISTS `spider_link_keyword3` (
  `spider_link_id` int(11) NOT NULL,
  `spider_keyword_id` int(11) NOT NULL,
  `spider_keyword_weight` int(3) default NULL,
  `spider_domain_id` int(4) default NULL,
  KEY `linkid` (`spider_link_id`),
  KEY `keyid` (`spider_keyword_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `spider_link_keyword3`
-- 

INSERT INTO `spider_link_keyword3` VALUES (1, 4, 10, 1);
INSERT INTO `spider_link_keyword3` VALUES (1, 6, 10, 1);
INSERT INTO `spider_link_keyword3` VALUES (1, 13, 10, 1);
INSERT INTO `spider_link_keyword3` VALUES (1, 16, 10, 1);
INSERT INTO `spider_link_keyword3` VALUES (1, 45, 10, 1);
INSERT INTO `spider_link_keyword3` VALUES (1, 56, 10, 1);
INSERT INTO `spider_link_keyword3` VALUES (1, 64, 10, 1);
INSERT INTO `spider_link_keyword3` VALUES (1, 70, 10, 1);
INSERT INTO `spider_link_keyword3` VALUES (1, 74, 10, 1);
INSERT INTO `spider_link_keyword3` VALUES (1, 94, 10, 1);
INSERT INTO `spider_link_keyword3` VALUES (1, 103, 20, 1);
INSERT INTO `spider_link_keyword3` VALUES (1, 126, 10, 1);
INSERT INTO `spider_link_keyword3` VALUES (1, 131, 10, 1);
INSERT INTO `spider_link_keyword3` VALUES (1, 165, 10, 1);
INSERT INTO `spider_link_keyword3` VALUES (1, 177, 60, 1);
INSERT INTO `spider_link_keyword3` VALUES (1, 184, 10, 1);
INSERT INTO `spider_link_keyword3` VALUES (1, 232, 10, 1);
INSERT INTO `spider_link_keyword3` VALUES (1, 266, 10, 1);
INSERT INTO `spider_link_keyword3` VALUES (1, 300, 10, 1);
INSERT INTO `spider_link_keyword3` VALUES (1, 306, 30, 1);
INSERT INTO `spider_link_keyword3` VALUES (2, 312, 8, 1);
INSERT INTO `spider_link_keyword3` VALUES (2, 266, 8, 1);
INSERT INTO `spider_link_keyword3` VALUES (3, 312, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (3, 330, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (3, 331, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (3, 341, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (3, 94, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (3, 126, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (3, 131, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (3, 165, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (3, 306, 14, 1);
INSERT INTO `spider_link_keyword3` VALUES (4, 13, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (4, 395, 14, 1);
INSERT INTO `spider_link_keyword3` VALUES (4, 312, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (4, 400, 21, 1);
INSERT INTO `spider_link_keyword3` VALUES (4, 74, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (4, 103, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (4, 126, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (4, 131, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (4, 436, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (4, 437, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (4, 177, 14, 1);
INSERT INTO `spider_link_keyword3` VALUES (4, 184, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (4, 455, 14, 1);
INSERT INTO `spider_link_keyword3` VALUES (4, 456, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (4, 461, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (4, 464, 14, 1);
INSERT INTO `spider_link_keyword3` VALUES (4, 300, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (4, 306, 14, 1);
INSERT INTO `spider_link_keyword3` VALUES (5, 470, 8, 1);
INSERT INTO `spider_link_keyword3` VALUES (6, 312, 8, 1);
INSERT INTO `spider_link_keyword3` VALUES (6, 177, 8, 1);
INSERT INTO `spider_link_keyword3` VALUES (6, 478, 8, 1);
INSERT INTO `spider_link_keyword3` VALUES (10, 482, 8, 1);
INSERT INTO `spider_link_keyword3` VALUES (11, 177, 16, 1);
INSERT INTO `spider_link_keyword3` VALUES (11, 478, 16, 1);
INSERT INTO `spider_link_keyword3` VALUES (12, 266, 8, 1);
INSERT INTO `spider_link_keyword3` VALUES (13, 266, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (14, 266, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (15, 266, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (16, 312, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (16, 331, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (16, 74, 14, 1);
INSERT INTO `spider_link_keyword3` VALUES (16, 493, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (16, 94, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (16, 103, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (16, 126, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (16, 131, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (16, 499, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (16, 436, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (16, 184, 14, 1);
INSERT INTO `spider_link_keyword3` VALUES (16, 455, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (16, 464, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (16, 306, 21, 1);
INSERT INTO `spider_link_keyword3` VALUES (16, 510, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (17, 312, 21, 1);
INSERT INTO `spider_link_keyword3` VALUES (17, 266, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (18, 514, 8, 1);
INSERT INTO `spider_link_keyword3` VALUES (18, 70, 8, 1);
INSERT INTO `spider_link_keyword3` VALUES (18, 536, 8, 1);
INSERT INTO `spider_link_keyword3` VALUES (19, 395, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (19, 312, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (19, 400, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (19, 330, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (19, 549, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (19, 331, 14, 1);
INSERT INTO `spider_link_keyword3` VALUES (19, 74, 14, 1);
INSERT INTO `spider_link_keyword3` VALUES (19, 341, 14, 1);
INSERT INTO `spider_link_keyword3` VALUES (19, 558, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (19, 499, 14, 1);
INSERT INTO `spider_link_keyword3` VALUES (19, 177, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (19, 184, 14, 1);
INSERT INTO `spider_link_keyword3` VALUES (19, 455, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (19, 464, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (19, 306, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (19, 510, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (20, 395, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (20, 312, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (20, 400, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (20, 330, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (20, 74, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (20, 493, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (20, 94, 14, 1);
INSERT INTO `spider_link_keyword3` VALUES (20, 617, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (20, 436, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (20, 177, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (20, 184, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (20, 455, 7, 1);
INSERT INTO `spider_link_keyword3` VALUES (20, 464, 7, 1);

-- --------------------------------------------------------

-- 
-- Структура таблицы `spider_link_keyword4`
-- 

DROP TABLE IF EXISTS `spider_link_keyword4`;
CREATE TABLE IF NOT EXISTS `spider_link_keyword4` (
  `spider_link_id` int(11) NOT NULL,
  `spider_keyword_id` int(11) NOT NULL,
  `spider_keyword_weight` int(3) default NULL,
  `spider_domain_id` int(4) default NULL,
  KEY `linkid` (`spider_link_id`),
  KEY `keyid` (`spider_keyword_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `spider_link_keyword4`
-- 

INSERT INTO `spider_link_keyword4` VALUES (1, 82, 10, 1);
INSERT INTO `spider_link_keyword4` VALUES (1, 101, 10, 1);
INSERT INTO `spider_link_keyword4` VALUES (1, 105, 10, 1);
INSERT INTO `spider_link_keyword4` VALUES (1, 124, 10, 1);
INSERT INTO `spider_link_keyword4` VALUES (1, 172, 10, 1);
INSERT INTO `spider_link_keyword4` VALUES (1, 210, 10, 1);
INSERT INTO `spider_link_keyword4` VALUES (1, 233, 10, 1);
INSERT INTO `spider_link_keyword4` VALUES (1, 242, 10, 1);
INSERT INTO `spider_link_keyword4` VALUES (1, 258, 10, 1);
INSERT INTO `spider_link_keyword4` VALUES (1, 271, 20, 1);
INSERT INTO `spider_link_keyword4` VALUES (1, 279, 10, 1);
INSERT INTO `spider_link_keyword4` VALUES (1, 283, 10, 1);
INSERT INTO `spider_link_keyword4` VALUES (2, 317, 8, 1);
INSERT INTO `spider_link_keyword4` VALUES (2, 320, 8, 1);
INSERT INTO `spider_link_keyword4` VALUES (3, 333, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (3, 334, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (3, 82, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (3, 124, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (3, 358, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (3, 383, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (3, 388, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (4, 416, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (4, 124, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (4, 426, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (4, 258, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (4, 383, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (4, 283, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (7, 242, 8, 1);
INSERT INTO `spider_link_keyword4` VALUES (8, 480, 8, 1);
INSERT INTO `spider_link_keyword4` VALUES (8, 481, 8, 1);
INSERT INTO `spider_link_keyword4` VALUES (9, 242, 16, 1);
INSERT INTO `spider_link_keyword4` VALUES (12, 317, 8, 1);
INSERT INTO `spider_link_keyword4` VALUES (12, 320, 8, 1);
INSERT INTO `spider_link_keyword4` VALUES (13, 317, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (13, 320, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (14, 317, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (14, 320, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (15, 317, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (15, 320, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (16, 82, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (16, 124, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (16, 283, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (17, 317, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (17, 320, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (18, 525, 424, 1);
INSERT INTO `spider_link_keyword4` VALUES (19, 426, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (19, 575, 14, 1);
INSERT INTO `spider_link_keyword4` VALUES (19, 271, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (20, 610, 7, 1);
INSERT INTO `spider_link_keyword4` VALUES (20, 283, 7, 1);

-- --------------------------------------------------------

-- 
-- Структура таблицы `spider_link_keyword5`
-- 

DROP TABLE IF EXISTS `spider_link_keyword5`;
CREATE TABLE IF NOT EXISTS `spider_link_keyword5` (
  `spider_link_id` int(11) NOT NULL,
  `spider_keyword_id` int(11) NOT NULL,
  `spider_keyword_weight` int(3) default NULL,
  `spider_domain_id` int(4) default NULL,
  KEY `linkid` (`spider_link_id`),
  KEY `keyid` (`spider_keyword_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `spider_link_keyword5`
-- 

INSERT INTO `spider_link_keyword5` VALUES (1, 11, 10, 1);
INSERT INTO `spider_link_keyword5` VALUES (1, 22, 10, 1);
INSERT INTO `spider_link_keyword5` VALUES (1, 23, 10, 1);
INSERT INTO `spider_link_keyword5` VALUES (1, 34, 10, 1);
INSERT INTO `spider_link_keyword5` VALUES (1, 38, 10, 1);
INSERT INTO `spider_link_keyword5` VALUES (1, 55, 10, 1);
INSERT INTO `spider_link_keyword5` VALUES (1, 73, 10, 1);
INSERT INTO `spider_link_keyword5` VALUES (1, 84, 10, 1);
INSERT INTO `spider_link_keyword5` VALUES (1, 90, 10, 1);
INSERT INTO `spider_link_keyword5` VALUES (1, 98, 30, 1);
INSERT INTO `spider_link_keyword5` VALUES (1, 104, 30, 1);
INSERT INTO `spider_link_keyword5` VALUES (1, 110, 10, 1);
INSERT INTO `spider_link_keyword5` VALUES (1, 121, 20, 1);
INSERT INTO `spider_link_keyword5` VALUES (1, 175, 20, 1);
INSERT INTO `spider_link_keyword5` VALUES (1, 179, 10, 1);
INSERT INTO `spider_link_keyword5` VALUES (1, 201, 30, 1);
INSERT INTO `spider_link_keyword5` VALUES (1, 207, 10, 1);
INSERT INTO `spider_link_keyword5` VALUES (1, 290, 10, 1);
INSERT INTO `spider_link_keyword5` VALUES (2, 314, 8, 1);
INSERT INTO `spider_link_keyword5` VALUES (2, 321, 8, 1);
INSERT INTO `spider_link_keyword5` VALUES (3, 337, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (3, 98, 14, 1);
INSERT INTO `spider_link_keyword5` VALUES (3, 104, 14, 1);
INSERT INTO `spider_link_keyword5` VALUES (3, 110, 14, 1);
INSERT INTO `spider_link_keyword5` VALUES (3, 347, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (3, 201, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (4, 55, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (4, 73, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (4, 337, 14, 1);
INSERT INTO `spider_link_keyword5` VALUES (4, 90, 14, 1);
INSERT INTO `spider_link_keyword5` VALUES (4, 418, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (4, 104, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (4, 347, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (4, 429, 14, 1);
INSERT INTO `spider_link_keyword5` VALUES (4, 431, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (4, 433, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (4, 201, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (4, 444, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (4, 447, 14, 1);
INSERT INTO `spider_link_keyword5` VALUES (5, 471, 8, 1);
INSERT INTO `spider_link_keyword5` VALUES (12, 314, 8, 1);
INSERT INTO `spider_link_keyword5` VALUES (12, 321, 8, 1);
INSERT INTO `spider_link_keyword5` VALUES (13, 314, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (13, 321, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (14, 314, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (14, 321, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (15, 314, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (15, 321, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (16, 55, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (16, 90, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (16, 494, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (16, 98, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (16, 110, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (16, 501, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (16, 201, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (16, 506, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (17, 314, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (17, 321, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (18, 11, 433, 1);
INSERT INTO `spider_link_keyword5` VALUES (18, 527, 8, 1);
INSERT INTO `spider_link_keyword5` VALUES (18, 528, 8, 1);
INSERT INTO `spider_link_keyword5` VALUES (18, 537, 8, 1);
INSERT INTO `spider_link_keyword5` VALUES (18, 290, 8, 1);
INSERT INTO `spider_link_keyword5` VALUES (19, 494, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (19, 98, 14, 1);
INSERT INTO `spider_link_keyword5` VALUES (19, 429, 14, 1);
INSERT INTO `spider_link_keyword5` VALUES (19, 501, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (19, 447, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (19, 591, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (20, 337, 21, 1);
INSERT INTO `spider_link_keyword5` VALUES (20, 494, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (20, 603, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (20, 607, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (20, 429, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (20, 447, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (20, 506, 21, 1);
INSERT INTO `spider_link_keyword5` VALUES (21, 11, 364, 1);
INSERT INTO `spider_link_keyword5` VALUES (21, 635, 7, 1);
INSERT INTO `spider_link_keyword5` VALUES (21, 290, 7, 1);

-- --------------------------------------------------------

-- 
-- Структура таблицы `spider_link_keyword6`
-- 

DROP TABLE IF EXISTS `spider_link_keyword6`;
CREATE TABLE IF NOT EXISTS `spider_link_keyword6` (
  `spider_link_id` int(11) NOT NULL,
  `spider_keyword_id` int(11) NOT NULL,
  `spider_keyword_weight` int(3) default NULL,
  `spider_domain_id` int(4) default NULL,
  KEY `linkid` (`spider_link_id`),
  KEY `keyid` (`spider_keyword_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `spider_link_keyword6`
-- 

INSERT INTO `spider_link_keyword6` VALUES (1, 17, 10, 1);
INSERT INTO `spider_link_keyword6` VALUES (1, 18, 10, 1);
INSERT INTO `spider_link_keyword6` VALUES (1, 20, 10, 1);
INSERT INTO `spider_link_keyword6` VALUES (1, 25, 10, 1);
INSERT INTO `spider_link_keyword6` VALUES (1, 27, 10, 1);
INSERT INTO `spider_link_keyword6` VALUES (1, 44, 10, 1);
INSERT INTO `spider_link_keyword6` VALUES (1, 49, 10, 1);
INSERT INTO `spider_link_keyword6` VALUES (1, 54, 20, 1);
INSERT INTO `spider_link_keyword6` VALUES (1, 58, 10, 1);
INSERT INTO `spider_link_keyword6` VALUES (1, 71, 10, 1);
INSERT INTO `spider_link_keyword6` VALUES (1, 99, 10, 1);
INSERT INTO `spider_link_keyword6` VALUES (1, 120, 30, 1);
INSERT INTO `spider_link_keyword6` VALUES (1, 123, 10, 1);
INSERT INTO `spider_link_keyword6` VALUES (1, 132, 80, 1);
INSERT INTO `spider_link_keyword6` VALUES (1, 182, 10, 1);
INSERT INTO `spider_link_keyword6` VALUES (1, 197, 20, 1);
INSERT INTO `spider_link_keyword6` VALUES (1, 208, 10, 1);
INSERT INTO `spider_link_keyword6` VALUES (1, 222, 40, 1);
INSERT INTO `spider_link_keyword6` VALUES (1, 240, 10, 1);
INSERT INTO `spider_link_keyword6` VALUES (1, 260, 10, 1);
INSERT INTO `spider_link_keyword6` VALUES (1, 263, 10, 1);
INSERT INTO `spider_link_keyword6` VALUES (1, 267, 10, 1);
INSERT INTO `spider_link_keyword6` VALUES (1, 276, 10, 1);
INSERT INTO `spider_link_keyword6` VALUES (1, 285, 10, 1);
INSERT INTO `spider_link_keyword6` VALUES (1, 299, 10, 1);
INSERT INTO `spider_link_keyword6` VALUES (1, 302, 10, 1);
INSERT INTO `spider_link_keyword6` VALUES (2, 319, 8, 1);
INSERT INTO `spider_link_keyword6` VALUES (3, 326, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (3, 49, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (3, 329, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (3, 58, 21, 1);
INSERT INTO `spider_link_keyword6` VALUES (3, 346, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (3, 123, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (3, 132, 14, 1);
INSERT INTO `spider_link_keyword6` VALUES (3, 357, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (3, 182, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (3, 370, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (3, 374, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (3, 299, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (4, 18, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (4, 326, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (4, 397, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (4, 329, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (4, 71, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (4, 409, 21, 1);
INSERT INTO `spider_link_keyword6` VALUES (4, 99, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (4, 421, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (4, 346, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (4, 123, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (4, 132, 21, 1);
INSERT INTO `spider_link_keyword6` VALUES (4, 432, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (4, 182, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (4, 374, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (4, 448, 14, 1);
INSERT INTO `spider_link_keyword6` VALUES (4, 260, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (4, 299, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (5, 473, 8, 1);
INSERT INTO `spider_link_keyword6` VALUES (6, 479, 8, 1);
INSERT INTO `spider_link_keyword6` VALUES (7, 132, 24, 1);
INSERT INTO `spider_link_keyword6` VALUES (7, 222, 16, 1);
INSERT INTO `spider_link_keyword6` VALUES (7, 285, 8, 1);
INSERT INTO `spider_link_keyword6` VALUES (7, 302, 8, 1);
INSERT INTO `spider_link_keyword6` VALUES (8, 132, 8, 1);
INSERT INTO `spider_link_keyword6` VALUES (8, 222, 24, 1);
INSERT INTO `spider_link_keyword6` VALUES (8, 285, 8, 1);
INSERT INTO `spider_link_keyword6` VALUES (9, 132, 24, 1);
INSERT INTO `spider_link_keyword6` VALUES (9, 302, 16, 1);
INSERT INTO `spider_link_keyword6` VALUES (11, 479, 16, 1);
INSERT INTO `spider_link_keyword6` VALUES (12, 319, 8, 1);
INSERT INTO `spider_link_keyword6` VALUES (13, 319, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (14, 319, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (15, 319, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (16, 18, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (16, 488, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (16, 49, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (16, 58, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (16, 71, 14, 1);
INSERT INTO `spider_link_keyword6` VALUES (16, 123, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (16, 132, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (16, 357, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (16, 182, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (16, 448, 14, 1);
INSERT INTO `spider_link_keyword6` VALUES (16, 299, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (17, 319, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (18, 44, 8, 1);
INSERT INTO `spider_link_keyword6` VALUES (18, 539, 8, 1);
INSERT INTO `spider_link_keyword6` VALUES (18, 285, 8, 1);
INSERT INTO `spider_link_keyword6` VALUES (19, 488, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (19, 58, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (19, 71, 14, 1);
INSERT INTO `spider_link_keyword6` VALUES (19, 559, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (19, 132, 21, 1);
INSERT INTO `spider_link_keyword6` VALUES (19, 569, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (19, 573, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (19, 448, 14, 1);
INSERT INTO `spider_link_keyword6` VALUES (19, 581, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (19, 586, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (20, 597, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (20, 326, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (20, 329, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (20, 71, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (20, 559, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (20, 120, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (20, 132, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (20, 357, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (20, 374, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (20, 626, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (20, 448, 7, 1);
INSERT INTO `spider_link_keyword6` VALUES (20, 276, 14, 1);
INSERT INTO `spider_link_keyword6` VALUES (21, 539, 7, 1);

-- --------------------------------------------------------

-- 
-- Структура таблицы `spider_link_keyword7`
-- 

DROP TABLE IF EXISTS `spider_link_keyword7`;
CREATE TABLE IF NOT EXISTS `spider_link_keyword7` (
  `spider_link_id` int(11) NOT NULL,
  `spider_keyword_id` int(11) NOT NULL,
  `spider_keyword_weight` int(3) default NULL,
  `spider_domain_id` int(4) default NULL,
  KEY `linkid` (`spider_link_id`),
  KEY `keyid` (`spider_keyword_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `spider_link_keyword7`
-- 

INSERT INTO `spider_link_keyword7` VALUES (1, 29, 10, 1);
INSERT INTO `spider_link_keyword7` VALUES (1, 59, 10, 1);
INSERT INTO `spider_link_keyword7` VALUES (1, 81, 40, 1);
INSERT INTO `spider_link_keyword7` VALUES (1, 85, 10, 1);
INSERT INTO `spider_link_keyword7` VALUES (1, 92, 30, 1);
INSERT INTO `spider_link_keyword7` VALUES (1, 109, 20, 1);
INSERT INTO `spider_link_keyword7` VALUES (1, 113, 10, 1);
INSERT INTO `spider_link_keyword7` VALUES (1, 116, 10, 1);
INSERT INTO `spider_link_keyword7` VALUES (1, 129, 10, 1);
INSERT INTO `spider_link_keyword7` VALUES (1, 135, 10, 1);
INSERT INTO `spider_link_keyword7` VALUES (1, 145, 10, 1);
INSERT INTO `spider_link_keyword7` VALUES (1, 168, 10, 1);
INSERT INTO `spider_link_keyword7` VALUES (1, 171, 10, 1);
INSERT INTO `spider_link_keyword7` VALUES (1, 181, 10, 1);
INSERT INTO `spider_link_keyword7` VALUES (1, 186, 10, 1);
INSERT INTO `spider_link_keyword7` VALUES (1, 204, 10, 1);
INSERT INTO `spider_link_keyword7` VALUES (1, 205, 20, 1);
INSERT INTO `spider_link_keyword7` VALUES (1, 216, 10, 1);
INSERT INTO `spider_link_keyword7` VALUES (1, 243, 10, 1);
INSERT INTO `spider_link_keyword7` VALUES (1, 310, 10, 1);
INSERT INTO `spider_link_keyword7` VALUES (3, 81, 21, 1);
INSERT INTO `spider_link_keyword7` VALUES (3, 92, 14, 1);
INSERT INTO `spider_link_keyword7` VALUES (3, 360, 7, 1);
INSERT INTO `spider_link_keyword7` VALUES (3, 362, 7, 1);
INSERT INTO `spider_link_keyword7` VALUES (3, 168, 14, 1);
INSERT INTO `spider_link_keyword7` VALUES (3, 392, 7, 1);
INSERT INTO `spider_link_keyword7` VALUES (4, 394, 7, 1);
INSERT INTO `spider_link_keyword7` VALUES (4, 29, 7, 1);
INSERT INTO `spider_link_keyword7` VALUES (4, 81, 14, 1);
INSERT INTO `spider_link_keyword7` VALUES (4, 85, 14, 1);
INSERT INTO `spider_link_keyword7` VALUES (4, 92, 14, 1);
INSERT INTO `spider_link_keyword7` VALUES (4, 109, 7, 1);
INSERT INTO `spider_link_keyword7` VALUES (4, 360, 7, 1);
INSERT INTO `spider_link_keyword7` VALUES (4, 392, 7, 1);
INSERT INTO `spider_link_keyword7` VALUES (7, 135, 8, 1);
INSERT INTO `spider_link_keyword7` VALUES (7, 204, 8, 1);
INSERT INTO `spider_link_keyword7` VALUES (7, 243, 8, 1);
INSERT INTO `spider_link_keyword7` VALUES (8, 360, 8, 1);
INSERT INTO `spider_link_keyword7` VALUES (9, 135, 8, 1);
INSERT INTO `spider_link_keyword7` VALUES (9, 360, 8, 1);
INSERT INTO `spider_link_keyword7` VALUES (9, 243, 8, 1);
INSERT INTO `spider_link_keyword7` VALUES (10, 360, 8, 1);
INSERT INTO `spider_link_keyword7` VALUES (10, 204, 8, 1);
INSERT INTO `spider_link_keyword7` VALUES (16, 484, 7, 1);
INSERT INTO `spider_link_keyword7` VALUES (16, 29, 7, 1);
INSERT INTO `spider_link_keyword7` VALUES (16, 81, 21, 1);
INSERT INTO `spider_link_keyword7` VALUES (16, 85, 7, 1);
INSERT INTO `spider_link_keyword7` VALUES (16, 92, 7, 1);
INSERT INTO `spider_link_keyword7` VALUES (18, 521, 8, 1);
INSERT INTO `spider_link_keyword7` VALUES (18, 81, 8, 1);
INSERT INTO `spider_link_keyword7` VALUES (18, 171, 24, 1);
INSERT INTO `spider_link_keyword7` VALUES (18, 186, 8, 1);
INSERT INTO `spider_link_keyword7` VALUES (18, 541, 8, 1);
INSERT INTO `spider_link_keyword7` VALUES (19, 81, 21, 1);
INSERT INTO `spider_link_keyword7` VALUES (19, 92, 7, 1);
INSERT INTO `spider_link_keyword7` VALUES (19, 360, 7, 1);
INSERT INTO `spider_link_keyword7` VALUES (19, 583, 7, 1);
INSERT INTO `spider_link_keyword7` VALUES (19, 593, 7, 1);
INSERT INTO `spider_link_keyword7` VALUES (20, 484, 7, 1);
INSERT INTO `spider_link_keyword7` VALUES (20, 29, 7, 1);
INSERT INTO `spider_link_keyword7` VALUES (20, 81, 14, 1);
INSERT INTO `spider_link_keyword7` VALUES (20, 92, 14, 1);
INSERT INTO `spider_link_keyword7` VALUES (20, 360, 7, 1);
INSERT INTO `spider_link_keyword7` VALUES (20, 168, 7, 1);
INSERT INTO `spider_link_keyword7` VALUES (20, 620, 7, 1);
INSERT INTO `spider_link_keyword7` VALUES (20, 621, 7, 1);
INSERT INTO `spider_link_keyword7` VALUES (20, 623, 14, 1);
INSERT INTO `spider_link_keyword7` VALUES (20, 624, 7, 1);
INSERT INTO `spider_link_keyword7` VALUES (20, 392, 7, 1);

-- --------------------------------------------------------

-- 
-- Структура таблицы `spider_link_keyword8`
-- 

DROP TABLE IF EXISTS `spider_link_keyword8`;
CREATE TABLE IF NOT EXISTS `spider_link_keyword8` (
  `spider_link_id` int(11) NOT NULL,
  `spider_keyword_id` int(11) NOT NULL,
  `spider_keyword_weight` int(3) default NULL,
  `spider_domain_id` int(4) default NULL,
  KEY `linkid` (`spider_link_id`),
  KEY `keyid` (`spider_keyword_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `spider_link_keyword8`
-- 

INSERT INTO `spider_link_keyword8` VALUES (1, 12, 10, 1);
INSERT INTO `spider_link_keyword8` VALUES (1, 21, 10, 1);
INSERT INTO `spider_link_keyword8` VALUES (1, 33, 10, 1);
INSERT INTO `spider_link_keyword8` VALUES (1, 52, 10, 1);
INSERT INTO `spider_link_keyword8` VALUES (1, 91, 10, 1);
INSERT INTO `spider_link_keyword8` VALUES (1, 111, 10, 1);
INSERT INTO `spider_link_keyword8` VALUES (1, 115, 20, 1);
INSERT INTO `spider_link_keyword8` VALUES (1, 127, 10, 1);
INSERT INTO `spider_link_keyword8` VALUES (1, 144, 20, 1);
INSERT INTO `spider_link_keyword8` VALUES (1, 190, 10, 1);
INSERT INTO `spider_link_keyword8` VALUES (1, 211, 10, 1);
INSERT INTO `spider_link_keyword8` VALUES (1, 217, 20, 1);
INSERT INTO `spider_link_keyword8` VALUES (1, 219, 10, 1);
INSERT INTO `spider_link_keyword8` VALUES (1, 225, 10, 1);
INSERT INTO `spider_link_keyword8` VALUES (1, 226, 10, 1);
INSERT INTO `spider_link_keyword8` VALUES (1, 227, 40, 1);
INSERT INTO `spider_link_keyword8` VALUES (1, 230, 10, 1);
INSERT INTO `spider_link_keyword8` VALUES (1, 231, 10, 1);
INSERT INTO `spider_link_keyword8` VALUES (1, 256, 10, 1);
INSERT INTO `spider_link_keyword8` VALUES (1, 273, 10, 1);
INSERT INTO `spider_link_keyword8` VALUES (1, 280, 10, 1);
INSERT INTO `spider_link_keyword8` VALUES (2, 315, 8, 1);
INSERT INTO `spider_link_keyword8` VALUES (3, 52, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (3, 342, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (3, 91, 14, 1);
INSERT INTO `spider_link_keyword8` VALUES (3, 111, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (3, 115, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (3, 371, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (3, 211, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (3, 219, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (3, 227, 14, 1);
INSERT INTO `spider_link_keyword8` VALUES (3, 273, 14, 1);
INSERT INTO `spider_link_keyword8` VALUES (3, 387, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (3, 390, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (4, 52, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (4, 411, 21, 1);
INSERT INTO `spider_link_keyword8` VALUES (4, 412, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (4, 342, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (4, 91, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (4, 111, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (4, 115, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (4, 127, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (4, 425, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (4, 427, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (4, 443, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (4, 211, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (4, 227, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (4, 450, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (4, 273, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (4, 387, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (5, 476, 8, 1);
INSERT INTO `spider_link_keyword8` VALUES (6, 144, 8, 1);
INSERT INTO `spider_link_keyword8` VALUES (6, 217, 8, 1);
INSERT INTO `spider_link_keyword8` VALUES (7, 91, 8, 1);
INSERT INTO `spider_link_keyword8` VALUES (7, 144, 16, 1);
INSERT INTO `spider_link_keyword8` VALUES (8, 91, 8, 1);
INSERT INTO `spider_link_keyword8` VALUES (9, 91, 16, 1);
INSERT INTO `spider_link_keyword8` VALUES (10, 91, 8, 1);
INSERT INTO `spider_link_keyword8` VALUES (12, 315, 8, 1);
INSERT INTO `spider_link_keyword8` VALUES (12, 217, 8, 1);
INSERT INTO `spider_link_keyword8` VALUES (13, 315, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (13, 217, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (14, 315, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (14, 217, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (15, 315, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (15, 217, 21, 1);
INSERT INTO `spider_link_keyword8` VALUES (16, 52, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (16, 115, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (16, 211, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (16, 227, 14, 1);
INSERT INTO `spider_link_keyword8` VALUES (16, 273, 14, 1);
INSERT INTO `spider_link_keyword8` VALUES (17, 315, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (18, 526, 8, 1);
INSERT INTO `spider_link_keyword8` VALUES (18, 531, 8, 1);
INSERT INTO `spider_link_keyword8` VALUES (18, 535, 8, 1);
INSERT INTO `spider_link_keyword8` VALUES (19, 546, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (19, 550, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (19, 91, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (19, 561, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (19, 443, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (19, 219, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (19, 225, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (19, 273, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (20, 600, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (20, 91, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (20, 612, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (20, 618, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (20, 211, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (20, 273, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (20, 387, 7, 1);
INSERT INTO `spider_link_keyword8` VALUES (20, 390, 7, 1);

-- --------------------------------------------------------

-- 
-- Структура таблицы `spider_link_keyword9`
-- 

DROP TABLE IF EXISTS `spider_link_keyword9`;
CREATE TABLE IF NOT EXISTS `spider_link_keyword9` (
  `spider_link_id` int(11) NOT NULL,
  `spider_keyword_id` int(11) NOT NULL,
  `spider_keyword_weight` int(3) default NULL,
  `spider_domain_id` int(4) default NULL,
  KEY `linkid` (`spider_link_id`),
  KEY `keyid` (`spider_keyword_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `spider_link_keyword9`
-- 

INSERT INTO `spider_link_keyword9` VALUES (1, 19, 10, 1);
INSERT INTO `spider_link_keyword9` VALUES (1, 24, 10, 1);
INSERT INTO `spider_link_keyword9` VALUES (1, 60, 10, 1);
INSERT INTO `spider_link_keyword9` VALUES (1, 95, 10, 1);
INSERT INTO `spider_link_keyword9` VALUES (1, 146, 20, 1);
INSERT INTO `spider_link_keyword9` VALUES (1, 148, 10, 1);
INSERT INTO `spider_link_keyword9` VALUES (1, 149, 10, 1);
INSERT INTO `spider_link_keyword9` VALUES (1, 162, 30, 1);
INSERT INTO `spider_link_keyword9` VALUES (1, 183, 30, 1);
INSERT INTO `spider_link_keyword9` VALUES (1, 191, 20, 1);
INSERT INTO `spider_link_keyword9` VALUES (1, 194, 10, 1);
INSERT INTO `spider_link_keyword9` VALUES (1, 229, 10, 1);
INSERT INTO `spider_link_keyword9` VALUES (1, 236, 10, 1);
INSERT INTO `spider_link_keyword9` VALUES (1, 237, 10, 1);
INSERT INTO `spider_link_keyword9` VALUES (1, 247, 10, 1);
INSERT INTO `spider_link_keyword9` VALUES (1, 272, 10, 1);
INSERT INTO `spider_link_keyword9` VALUES (1, 275, 10, 1);
INSERT INTO `spider_link_keyword9` VALUES (1, 305, 40, 1);
INSERT INTO `spider_link_keyword9` VALUES (1, 309, 10, 1);
INSERT INTO `spider_link_keyword9` VALUES (1, 311, 10, 1);
INSERT INTO `spider_link_keyword9` VALUES (3, 340, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (3, 95, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (3, 355, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (3, 149, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (3, 162, 14, 1);
INSERT INTO `spider_link_keyword9` VALUES (3, 366, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (3, 191, 14, 1);
INSERT INTO `spider_link_keyword9` VALUES (3, 369, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (3, 272, 21, 1);
INSERT INTO `spider_link_keyword9` VALUES (3, 305, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (3, 309, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (4, 396, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (4, 401, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (4, 405, 14, 1);
INSERT INTO `spider_link_keyword9` VALUES (4, 95, 14, 1);
INSERT INTO `spider_link_keyword9` VALUES (4, 417, 14, 1);
INSERT INTO `spider_link_keyword9` VALUES (4, 148, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (4, 366, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (4, 438, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (4, 439, 21, 1);
INSERT INTO `spider_link_keyword9` VALUES (4, 191, 14, 1);
INSERT INTO `spider_link_keyword9` VALUES (4, 247, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (4, 305, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (4, 309, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (5, 275, 8, 1);
INSERT INTO `spider_link_keyword9` VALUES (7, 146, 16, 1);
INSERT INTO `spider_link_keyword9` VALUES (7, 183, 8, 1);
INSERT INTO `spider_link_keyword9` VALUES (7, 229, 8, 1);
INSERT INTO `spider_link_keyword9` VALUES (7, 237, 8, 1);
INSERT INTO `spider_link_keyword9` VALUES (8, 146, 24, 1);
INSERT INTO `spider_link_keyword9` VALUES (8, 183, 8, 1);
INSERT INTO `spider_link_keyword9` VALUES (10, 229, 8, 1);
INSERT INTO `spider_link_keyword9` VALUES (10, 237, 16, 1);
INSERT INTO `spider_link_keyword9` VALUES (16, 405, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (16, 95, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (16, 417, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (16, 496, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (16, 148, 14, 1);
INSERT INTO `spider_link_keyword9` VALUES (16, 149, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (16, 162, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (16, 438, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (16, 191, 21, 1);
INSERT INTO `spider_link_keyword9` VALUES (16, 247, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (16, 505, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (16, 272, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (16, 509, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (16, 305, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (16, 309, 14, 1);
INSERT INTO `spider_link_keyword9` VALUES (18, 523, 8, 1);
INSERT INTO `spider_link_keyword9` VALUES (19, 543, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (19, 19, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (19, 405, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (19, 553, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (19, 557, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (19, 417, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (19, 496, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (19, 148, 14, 1);
INSERT INTO `spider_link_keyword9` VALUES (19, 162, 21, 1);
INSERT INTO `spider_link_keyword9` VALUES (19, 438, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (19, 570, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (19, 571, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (19, 576, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (19, 577, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (19, 578, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (19, 247, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (19, 505, 14, 1);
INSERT INTO `spider_link_keyword9` VALUES (19, 272, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (19, 588, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (19, 590, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (19, 509, 14, 1);
INSERT INTO `spider_link_keyword9` VALUES (19, 309, 14, 1);
INSERT INTO `spider_link_keyword9` VALUES (20, 405, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (20, 557, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (20, 417, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (20, 496, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (20, 148, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (20, 149, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (20, 162, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (20, 366, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (20, 570, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (20, 571, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (20, 191, 14, 1);
INSERT INTO `spider_link_keyword9` VALUES (20, 625, 14, 1);
INSERT INTO `spider_link_keyword9` VALUES (20, 247, 14, 1);
INSERT INTO `spider_link_keyword9` VALUES (20, 632, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (20, 633, 7, 1);
INSERT INTO `spider_link_keyword9` VALUES (20, 309, 7, 1);

-- --------------------------------------------------------

-- 
-- Структура таблицы `spider_link_keyworda`
-- 

DROP TABLE IF EXISTS `spider_link_keyworda`;
CREATE TABLE IF NOT EXISTS `spider_link_keyworda` (
  `spider_link_id` int(11) NOT NULL,
  `spider_keyword_id` int(11) NOT NULL,
  `spider_keyword_weight` int(3) default NULL,
  `spider_domain_id` int(4) default NULL,
  KEY `linkid` (`spider_link_id`),
  KEY `keyid` (`spider_keyword_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `spider_link_keyworda`
-- 

INSERT INTO `spider_link_keyworda` VALUES (1, 67, 20, 1);
INSERT INTO `spider_link_keyworda` VALUES (1, 107, 10, 1);
INSERT INTO `spider_link_keyworda` VALUES (1, 117, 10, 1);
INSERT INTO `spider_link_keyworda` VALUES (1, 125, 10, 1);
INSERT INTO `spider_link_keyworda` VALUES (1, 136, 10, 1);
INSERT INTO `spider_link_keyworda` VALUES (1, 138, 10, 1);
INSERT INTO `spider_link_keyworda` VALUES (1, 142, 10, 1);
INSERT INTO `spider_link_keyworda` VALUES (1, 158, 10, 1);
INSERT INTO `spider_link_keyworda` VALUES (1, 163, 20, 1);
INSERT INTO `spider_link_keyworda` VALUES (1, 176, 10, 1);
INSERT INTO `spider_link_keyworda` VALUES (1, 223, 20, 1);
INSERT INTO `spider_link_keyworda` VALUES (1, 245, 10, 1);
INSERT INTO `spider_link_keyworda` VALUES (1, 250, 10, 1);
INSERT INTO `spider_link_keyworda` VALUES (1, 253, 10, 1);
INSERT INTO `spider_link_keyworda` VALUES (1, 254, 10, 1);
INSERT INTO `spider_link_keyworda` VALUES (2, 316, 8, 1);
INSERT INTO `spider_link_keyworda` VALUES (3, 338, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (3, 344, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (3, 107, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (3, 348, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (3, 125, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (3, 163, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (3, 368, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (3, 245, 21, 1);
INSERT INTO `spider_link_keyworda` VALUES (3, 386, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (4, 413, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (4, 125, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (4, 442, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (6, 67, 8, 1);
INSERT INTO `spider_link_keyworda` VALUES (6, 223, 24, 1);
INSERT INTO `spider_link_keyworda` VALUES (7, 136, 8, 1);
INSERT INTO `spider_link_keyworda` VALUES (7, 138, 8, 1);
INSERT INTO `spider_link_keyworda` VALUES (8, 136, 8, 1);
INSERT INTO `spider_link_keyworda` VALUES (8, 138, 8, 1);
INSERT INTO `spider_link_keyworda` VALUES (12, 67, 8, 1);
INSERT INTO `spider_link_keyworda` VALUES (12, 316, 8, 1);
INSERT INTO `spider_link_keyworda` VALUES (13, 67, 21, 1);
INSERT INTO `spider_link_keyworda` VALUES (13, 316, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (14, 67, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (14, 316, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (15, 67, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (15, 316, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (16, 495, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (16, 107, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (16, 348, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (16, 125, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (16, 163, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (16, 245, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (16, 504, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (17, 316, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (18, 522, 424, 1);
INSERT INTO `spider_link_keyworda` VALUES (18, 533, 8, 1);
INSERT INTO `spider_link_keyworda` VALUES (19, 547, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (19, 554, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (19, 413, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (19, 495, 14, 1);
INSERT INTO `spider_link_keyworda` VALUES (19, 107, 14, 1);
INSERT INTO `spider_link_keyworda` VALUES (19, 348, 14, 1);
INSERT INTO `spider_link_keyworda` VALUES (19, 565, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (19, 442, 14, 1);
INSERT INTO `spider_link_keyworda` VALUES (19, 245, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (19, 592, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (20, 344, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (20, 616, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (20, 504, 7, 1);
INSERT INTO `spider_link_keyworda` VALUES (20, 629, 7, 1);

-- --------------------------------------------------------

-- 
-- Структура таблицы `spider_link_keywordb`
-- 

DROP TABLE IF EXISTS `spider_link_keywordb`;
CREATE TABLE IF NOT EXISTS `spider_link_keywordb` (
  `spider_link_id` int(11) NOT NULL,
  `spider_keyword_id` int(11) NOT NULL,
  `spider_keyword_weight` int(3) default NULL,
  `spider_domain_id` int(4) default NULL,
  KEY `linkid` (`spider_link_id`),
  KEY `keyid` (`spider_keyword_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `spider_link_keywordb`
-- 

INSERT INTO `spider_link_keywordb` VALUES (1, 7, 10, 1);
INSERT INTO `spider_link_keywordb` VALUES (1, 9, 10, 1);
INSERT INTO `spider_link_keywordb` VALUES (1, 61, 10, 1);
INSERT INTO `spider_link_keywordb` VALUES (1, 68, 30, 1);
INSERT INTO `spider_link_keywordb` VALUES (1, 77, 10, 1);
INSERT INTO `spider_link_keywordb` VALUES (1, 86, 10, 1);
INSERT INTO `spider_link_keywordb` VALUES (1, 88, 10, 1);
INSERT INTO `spider_link_keywordb` VALUES (1, 102, 10, 1);
INSERT INTO `spider_link_keywordb` VALUES (1, 108, 10, 1);
INSERT INTO `spider_link_keywordb` VALUES (1, 119, 10, 1);
INSERT INTO `spider_link_keywordb` VALUES (1, 134, 10, 1);
INSERT INTO `spider_link_keywordb` VALUES (1, 161, 20, 1);
INSERT INTO `spider_link_keywordb` VALUES (1, 198, 10, 1);
INSERT INTO `spider_link_keywordb` VALUES (1, 200, 20, 1);
INSERT INTO `spider_link_keywordb` VALUES (1, 202, 10, 1);
INSERT INTO `spider_link_keywordb` VALUES (1, 214, 10, 1);
INSERT INTO `spider_link_keywordb` VALUES (1, 218, 30, 1);
INSERT INTO `spider_link_keywordb` VALUES (1, 220, 10, 1);
INSERT INTO `spider_link_keywordb` VALUES (1, 224, 10, 1);
INSERT INTO `spider_link_keywordb` VALUES (1, 241, 10, 1);
INSERT INTO `spider_link_keywordb` VALUES (1, 248, 10, 1);
INSERT INTO `spider_link_keywordb` VALUES (1, 270, 10, 1);
INSERT INTO `spider_link_keywordb` VALUES (1, 274, 10, 1);
INSERT INTO `spider_link_keywordb` VALUES (1, 284, 10, 1);
INSERT INTO `spider_link_keywordb` VALUES (2, 313, 8, 1);
INSERT INTO `spider_link_keywordb` VALUES (2, 102, 16, 1);
INSERT INTO `spider_link_keywordb` VALUES (3, 61, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (3, 68, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (3, 88, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (3, 108, 21, 1);
INSERT INTO `spider_link_keywordb` VALUES (3, 353, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (3, 354, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (3, 367, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (3, 198, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (3, 202, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (3, 218, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (3, 220, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (3, 241, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (4, 61, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (4, 86, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (4, 367, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (4, 198, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (4, 218, 21, 1);
INSERT INTO `spider_link_keywordb` VALUES (4, 224, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (4, 446, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (4, 284, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (4, 463, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (6, 102, 8, 1);
INSERT INTO `spider_link_keywordb` VALUES (6, 200, 8, 1);
INSERT INTO `spider_link_keywordb` VALUES (7, 77, 8, 1);
INSERT INTO `spider_link_keywordb` VALUES (8, 77, 16, 1);
INSERT INTO `spider_link_keywordb` VALUES (12, 313, 8, 1);
INSERT INTO `spider_link_keywordb` VALUES (12, 200, 8, 1);
INSERT INTO `spider_link_keywordb` VALUES (13, 313, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (13, 200, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (14, 313, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (14, 200, 21, 1);
INSERT INTO `spider_link_keywordb` VALUES (15, 313, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (15, 200, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (16, 489, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (16, 61, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (16, 88, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (16, 108, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (16, 500, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (16, 198, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (16, 202, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (16, 218, 14, 1);
INSERT INTO `spider_link_keywordb` VALUES (16, 220, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (16, 224, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (16, 241, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (16, 284, 14, 1);
INSERT INTO `spider_link_keywordb` VALUES (16, 511, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (16, 512, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (17, 313, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (18, 517, 8, 1);
INSERT INTO `spider_link_keywordb` VALUES (18, 520, 8, 1);
INSERT INTO `spider_link_keywordb` VALUES (19, 548, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (19, 489, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (19, 108, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (19, 353, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (19, 500, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (19, 574, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (19, 202, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (19, 218, 14, 1);
INSERT INTO `spider_link_keywordb` VALUES (19, 284, 14, 1);
INSERT INTO `spider_link_keywordb` VALUES (19, 512, 14, 1);
INSERT INTO `spider_link_keywordb` VALUES (20, 68, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (20, 86, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (20, 604, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (20, 605, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (20, 354, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (20, 614, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (20, 619, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (20, 214, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (20, 284, 7, 1);
INSERT INTO `spider_link_keywordb` VALUES (20, 511, 14, 1);

-- --------------------------------------------------------

-- 
-- Структура таблицы `spider_link_keywordc`
-- 

DROP TABLE IF EXISTS `spider_link_keywordc`;
CREATE TABLE IF NOT EXISTS `spider_link_keywordc` (
  `spider_link_id` int(11) NOT NULL,
  `spider_keyword_id` int(11) NOT NULL,
  `spider_keyword_weight` int(3) default NULL,
  `spider_domain_id` int(4) default NULL,
  KEY `linkid` (`spider_link_id`),
  KEY `keyid` (`spider_keyword_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `spider_link_keywordc`
-- 

INSERT INTO `spider_link_keywordc` VALUES (1, 3, 30, 1);
INSERT INTO `spider_link_keywordc` VALUES (1, 43, 30, 1);
INSERT INTO `spider_link_keywordc` VALUES (1, 47, 10, 1);
INSERT INTO `spider_link_keywordc` VALUES (1, 48, 10, 1);
INSERT INTO `spider_link_keywordc` VALUES (1, 65, 10, 1);
INSERT INTO `spider_link_keywordc` VALUES (1, 72, 10, 1);
INSERT INTO `spider_link_keywordc` VALUES (1, 118, 10, 1);
INSERT INTO `spider_link_keywordc` VALUES (1, 128, 20, 1);
INSERT INTO `spider_link_keywordc` VALUES (1, 140, 10, 1);
INSERT INTO `spider_link_keywordc` VALUES (1, 151, 20, 1);
INSERT INTO `spider_link_keywordc` VALUES (1, 188, 10, 1);
INSERT INTO `spider_link_keywordc` VALUES (1, 189, 10, 1);
INSERT INTO `spider_link_keywordc` VALUES (1, 192, 10, 1);
INSERT INTO `spider_link_keywordc` VALUES (1, 277, 10, 1);
INSERT INTO `spider_link_keywordc` VALUES (1, 292, 10, 1);
INSERT INTO `spider_link_keywordc` VALUES (1, 293, 10, 1);
INSERT INTO `spider_link_keywordc` VALUES (2, 43, 8, 1);
INSERT INTO `spider_link_keywordc` VALUES (3, 339, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (3, 343, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (3, 356, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (3, 365, 14, 1);
INSERT INTO `spider_link_keywordc` VALUES (3, 372, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (3, 380, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (3, 391, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (4, 398, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (4, 277, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (4, 460, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (4, 293, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (6, 477, 24, 1);
INSERT INTO `spider_link_keywordc` VALUES (6, 292, 8, 1);
INSERT INTO `spider_link_keywordc` VALUES (7, 3, 24, 1);
INSERT INTO `spider_link_keywordc` VALUES (7, 43, 16, 1);
INSERT INTO `spider_link_keywordc` VALUES (7, 140, 8, 1);
INSERT INTO `spider_link_keywordc` VALUES (7, 151, 8, 1);
INSERT INTO `spider_link_keywordc` VALUES (7, 292, 8, 1);
INSERT INTO `spider_link_keywordc` VALUES (8, 3, 8, 1);
INSERT INTO `spider_link_keywordc` VALUES (8, 43, 8, 1);
INSERT INTO `spider_link_keywordc` VALUES (9, 3, 8, 1);
INSERT INTO `spider_link_keywordc` VALUES (9, 140, 16, 1);
INSERT INTO `spider_link_keywordc` VALUES (9, 151, 8, 1);
INSERT INTO `spider_link_keywordc` VALUES (9, 292, 16, 1);
INSERT INTO `spider_link_keywordc` VALUES (10, 3, 8, 1);
INSERT INTO `spider_link_keywordc` VALUES (10, 43, 8, 1);
INSERT INTO `spider_link_keywordc` VALUES (12, 43, 8, 1);
INSERT INTO `spider_link_keywordc` VALUES (12, 292, 16, 1);
INSERT INTO `spider_link_keywordc` VALUES (13, 43, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (14, 43, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (15, 43, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (16, 277, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (16, 507, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (16, 293, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (17, 43, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (18, 513, 8, 1);
INSERT INTO `spider_link_keywordc` VALUES (18, 540, 8, 1);
INSERT INTO `spider_link_keywordc` VALUES (19, 544, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (19, 556, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (19, 567, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (19, 584, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (19, 277, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (19, 507, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (19, 293, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (19, 391, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (20, 556, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (20, 611, 14, 1);
INSERT INTO `spider_link_keywordc` VALUES (20, 372, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (20, 277, 21, 1);
INSERT INTO `spider_link_keywordc` VALUES (20, 460, 7, 1);
INSERT INTO `spider_link_keywordc` VALUES (21, 540, 7, 1);

-- --------------------------------------------------------

-- 
-- Структура таблицы `spider_link_keywordd`
-- 

DROP TABLE IF EXISTS `spider_link_keywordd`;
CREATE TABLE IF NOT EXISTS `spider_link_keywordd` (
  `spider_link_id` int(11) NOT NULL,
  `spider_keyword_id` int(11) NOT NULL,
  `spider_keyword_weight` int(3) default NULL,
  `spider_domain_id` int(4) default NULL,
  KEY `linkid` (`spider_link_id`),
  KEY `keyid` (`spider_keyword_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `spider_link_keywordd`
-- 

INSERT INTO `spider_link_keywordd` VALUES (1, 1, 20, 1);
INSERT INTO `spider_link_keywordd` VALUES (1, 2, 10, 1);
INSERT INTO `spider_link_keywordd` VALUES (1, 5, 30, 1);
INSERT INTO `spider_link_keywordd` VALUES (1, 28, 10, 1);
INSERT INTO `spider_link_keywordd` VALUES (1, 36, 10, 1);
INSERT INTO `spider_link_keywordd` VALUES (1, 37, 10, 1);
INSERT INTO `spider_link_keywordd` VALUES (1, 42, 40, 1);
INSERT INTO `spider_link_keywordd` VALUES (1, 51, 20, 1);
INSERT INTO `spider_link_keywordd` VALUES (1, 53, 20, 1);
INSERT INTO `spider_link_keywordd` VALUES (1, 69, 30, 1);
INSERT INTO `spider_link_keywordd` VALUES (1, 143, 10, 1);
INSERT INTO `spider_link_keywordd` VALUES (1, 199, 10, 1);
INSERT INTO `spider_link_keywordd` VALUES (1, 206, 20, 1);
INSERT INTO `spider_link_keywordd` VALUES (1, 228, 10, 1);
INSERT INTO `spider_link_keywordd` VALUES (1, 252, 10, 1);
INSERT INTO `spider_link_keywordd` VALUES (1, 286, 10, 1);
INSERT INTO `spider_link_keywordd` VALUES (1, 287, 10, 1);
INSERT INTO `spider_link_keywordd` VALUES (1, 291, 20, 1);
INSERT INTO `spider_link_keywordd` VALUES (1, 295, 30, 1);
INSERT INTO `spider_link_keywordd` VALUES (1, 303, 10, 1);
INSERT INTO `spider_link_keywordd` VALUES (2, 42, 8, 1);
INSERT INTO `spider_link_keywordd` VALUES (3, 5, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (3, 42, 28, 1);
INSERT INTO `spider_link_keywordd` VALUES (3, 350, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (3, 363, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (3, 376, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (3, 381, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (3, 384, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (3, 393, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (4, 5, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (4, 37, 14, 1);
INSERT INTO `spider_link_keywordd` VALUES (4, 42, 28, 1);
INSERT INTO `spider_link_keywordd` VALUES (4, 399, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (4, 404, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (4, 408, 14, 1);
INSERT INTO `spider_link_keywordd` VALUES (4, 422, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (4, 441, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (6, 206, 8, 1);
INSERT INTO `spider_link_keywordd` VALUES (7, 1, 8, 1);
INSERT INTO `spider_link_keywordd` VALUES (7, 2, 8, 1);
INSERT INTO `spider_link_keywordd` VALUES (7, 5, 24, 1);
INSERT INTO `spider_link_keywordd` VALUES (7, 69, 8, 1);
INSERT INTO `spider_link_keywordd` VALUES (7, 228, 8, 1);
INSERT INTO `spider_link_keywordd` VALUES (7, 252, 8, 1);
INSERT INTO `spider_link_keywordd` VALUES (7, 295, 24, 1);
INSERT INTO `spider_link_keywordd` VALUES (7, 303, 8, 1);
INSERT INTO `spider_link_keywordd` VALUES (8, 5, 8, 1);
INSERT INTO `spider_link_keywordd` VALUES (8, 69, 8, 1);
INSERT INTO `spider_link_keywordd` VALUES (8, 295, 8, 1);
INSERT INTO `spider_link_keywordd` VALUES (9, 1, 8, 1);
INSERT INTO `spider_link_keywordd` VALUES (9, 2, 8, 1);
INSERT INTO `spider_link_keywordd` VALUES (9, 5, 8, 1);
INSERT INTO `spider_link_keywordd` VALUES (9, 295, 8, 1);
INSERT INTO `spider_link_keywordd` VALUES (9, 303, 8, 1);
INSERT INTO `spider_link_keywordd` VALUES (10, 5, 8, 1);
INSERT INTO `spider_link_keywordd` VALUES (10, 228, 16, 1);
INSERT INTO `spider_link_keywordd` VALUES (10, 252, 8, 1);
INSERT INTO `spider_link_keywordd` VALUES (10, 295, 8, 1);
INSERT INTO `spider_link_keywordd` VALUES (12, 42, 8, 1);
INSERT INTO `spider_link_keywordd` VALUES (12, 206, 8, 1);
INSERT INTO `spider_link_keywordd` VALUES (13, 42, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (13, 206, 21, 1);
INSERT INTO `spider_link_keywordd` VALUES (14, 42, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (14, 206, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (15, 42, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (15, 206, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (16, 37, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (16, 42, 28, 1);
INSERT INTO `spider_link_keywordd` VALUES (16, 408, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (16, 441, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (17, 42, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (18, 1, 8, 1);
INSERT INTO `spider_link_keywordd` VALUES (18, 532, 16, 1);
INSERT INTO `spider_link_keywordd` VALUES (19, 5, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (19, 37, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (19, 42, 28, 1);
INSERT INTO `spider_link_keywordd` VALUES (19, 404, 14, 1);
INSERT INTO `spider_link_keywordd` VALUES (19, 551, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (19, 408, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (19, 350, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (19, 564, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (19, 566, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (20, 596, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (20, 5, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (20, 598, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (20, 599, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (20, 42, 35, 1);
INSERT INTO `spider_link_keywordd` VALUES (20, 399, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (20, 408, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (20, 622, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (20, 441, 7, 1);
INSERT INTO `spider_link_keywordd` VALUES (21, 42, 7, 1);

-- --------------------------------------------------------

-- 
-- Структура таблицы `spider_link_keyworde`
-- 

DROP TABLE IF EXISTS `spider_link_keyworde`;
CREATE TABLE IF NOT EXISTS `spider_link_keyworde` (
  `spider_link_id` int(11) NOT NULL,
  `spider_keyword_id` int(11) NOT NULL,
  `spider_keyword_weight` int(3) default NULL,
  `spider_domain_id` int(4) default NULL,
  KEY `linkid` (`spider_link_id`),
  KEY `keyid` (`spider_keyword_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `spider_link_keyworde`
-- 

INSERT INTO `spider_link_keyworde` VALUES (1, 31, 10, 1);
INSERT INTO `spider_link_keyworde` VALUES (1, 62, 10, 1);
INSERT INTO `spider_link_keyworde` VALUES (1, 80, 50, 1);
INSERT INTO `spider_link_keyworde` VALUES (1, 93, 10, 1);
INSERT INTO `spider_link_keyworde` VALUES (1, 130, 20, 1);
INSERT INTO `spider_link_keyworde` VALUES (1, 139, 10, 1);
INSERT INTO `spider_link_keyworde` VALUES (1, 156, 10, 1);
INSERT INTO `spider_link_keyworde` VALUES (1, 157, 10, 1);
INSERT INTO `spider_link_keyworde` VALUES (1, 159, 10, 1);
INSERT INTO `spider_link_keyworde` VALUES (1, 174, 10, 1);
INSERT INTO `spider_link_keyworde` VALUES (1, 221, 40, 1);
INSERT INTO `spider_link_keyworde` VALUES (1, 251, 10, 1);
INSERT INTO `spider_link_keyworde` VALUES (1, 257, 10, 1);
INSERT INTO `spider_link_keyworde` VALUES (1, 259, 10, 1);
INSERT INTO `spider_link_keyworde` VALUES (1, 265, 10, 1);
INSERT INTO `spider_link_keyworde` VALUES (1, 268, 10, 1);
INSERT INTO `spider_link_keyworde` VALUES (1, 296, 10, 1);
INSERT INTO `spider_link_keyworde` VALUES (1, 301, 10, 1);
INSERT INTO `spider_link_keyworde` VALUES (2, 265, 8, 1);
INSERT INTO `spider_link_keyworde` VALUES (3, 31, 21, 1);
INSERT INTO `spider_link_keyworde` VALUES (3, 325, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (3, 327, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (3, 345, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (3, 351, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (3, 352, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (3, 379, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (3, 265, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (3, 301, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (4, 351, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (4, 440, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (4, 449, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (4, 451, 14, 1);
INSERT INTO `spider_link_keyworde` VALUES (4, 265, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (4, 465, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (6, 80, 16, 1);
INSERT INTO `spider_link_keyworde` VALUES (6, 265, 8, 1);
INSERT INTO `spider_link_keyworde` VALUES (7, 130, 16, 1);
INSERT INTO `spider_link_keyworde` VALUES (8, 130, 16, 1);
INSERT INTO `spider_link_keyworde` VALUES (9, 130, 8, 1);
INSERT INTO `spider_link_keyworde` VALUES (12, 80, 16, 1);
INSERT INTO `spider_link_keyworde` VALUES (13, 80, 14, 1);
INSERT INTO `spider_link_keyworde` VALUES (14, 80, 28, 1);
INSERT INTO `spider_link_keyworde` VALUES (15, 80, 28, 1);
INSERT INTO `spider_link_keyworde` VALUES (16, 483, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (16, 31, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (16, 265, 21, 1);
INSERT INTO `spider_link_keyworde` VALUES (16, 508, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (16, 301, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (17, 265, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (18, 515, 8, 1);
INSERT INTO `spider_link_keyworde` VALUES (18, 516, 8, 1);
INSERT INTO `spider_link_keyworde` VALUES (18, 221, 424, 1);
INSERT INTO `spider_link_keyworde` VALUES (18, 542, 8, 1);
INSERT INTO `spider_link_keyworde` VALUES (19, 483, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (19, 31, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (19, 555, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (19, 563, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (19, 568, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (19, 221, 364, 1);
INSERT INTO `spider_link_keyworde` VALUES (19, 449, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (19, 451, 14, 1);
INSERT INTO `spider_link_keyworde` VALUES (19, 265, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (19, 508, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (20, 62, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (20, 608, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (20, 351, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (20, 628, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (20, 251, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (20, 451, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (20, 265, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (20, 301, 7, 1);
INSERT INTO `spider_link_keyworde` VALUES (21, 542, 7, 1);

-- --------------------------------------------------------

-- 
-- Структура таблицы `spider_link_keywordf`
-- 

DROP TABLE IF EXISTS `spider_link_keywordf`;
CREATE TABLE IF NOT EXISTS `spider_link_keywordf` (
  `spider_link_id` int(11) NOT NULL,
  `spider_keyword_id` int(11) NOT NULL,
  `spider_keyword_weight` int(3) default NULL,
  `spider_domain_id` int(4) default NULL,
  KEY `linkid` (`spider_link_id`),
  KEY `keyid` (`spider_keyword_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `spider_link_keywordf`
-- 

INSERT INTO `spider_link_keywordf` VALUES (1, 8, 10, 1);
INSERT INTO `spider_link_keywordf` VALUES (1, 30, 10, 1);
INSERT INTO `spider_link_keywordf` VALUES (1, 40, 20, 1);
INSERT INTO `spider_link_keywordf` VALUES (1, 41, 20, 1);
INSERT INTO `spider_link_keywordf` VALUES (1, 63, 10, 1);
INSERT INTO `spider_link_keywordf` VALUES (1, 78, 20, 1);
INSERT INTO `spider_link_keywordf` VALUES (1, 87, 20, 1);
INSERT INTO `spider_link_keywordf` VALUES (1, 89, 20, 1);
INSERT INTO `spider_link_keywordf` VALUES (1, 133, 10, 1);
INSERT INTO `spider_link_keywordf` VALUES (1, 147, 10, 1);
INSERT INTO `spider_link_keywordf` VALUES (1, 150, 10, 1);
INSERT INTO `spider_link_keywordf` VALUES (1, 153, 10, 1);
INSERT INTO `spider_link_keywordf` VALUES (1, 164, 30, 1);
INSERT INTO `spider_link_keywordf` VALUES (1, 170, 10, 1);
INSERT INTO `spider_link_keywordf` VALUES (1, 196, 10, 1);
INSERT INTO `spider_link_keywordf` VALUES (1, 203, 10, 1);
INSERT INTO `spider_link_keywordf` VALUES (1, 215, 10, 1);
INSERT INTO `spider_link_keywordf` VALUES (1, 235, 10, 1);
INSERT INTO `spider_link_keywordf` VALUES (1, 255, 20, 1);
INSERT INTO `spider_link_keywordf` VALUES (1, 278, 10, 1);
INSERT INTO `spider_link_keywordf` VALUES (1, 282, 10, 1);
INSERT INTO `spider_link_keywordf` VALUES (1, 288, 10, 1);
INSERT INTO `spider_link_keywordf` VALUES (1, 289, 10, 1);
INSERT INTO `spider_link_keywordf` VALUES (1, 308, 10, 1);
INSERT INTO `spider_link_keywordf` VALUES (2, 147, 16, 1);
INSERT INTO `spider_link_keywordf` VALUES (3, 323, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (3, 328, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (3, 332, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (3, 89, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (3, 359, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (3, 150, 14, 1);
INSERT INTO `spider_link_keywordf` VALUES (3, 164, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (3, 373, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (3, 385, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (3, 289, 14, 1);
INSERT INTO `spider_link_keywordf` VALUES (4, 332, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (4, 89, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (4, 414, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (4, 415, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (4, 147, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (4, 150, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (4, 164, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (4, 435, 14, 1);
INSERT INTO `spider_link_keywordf` VALUES (4, 235, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (4, 458, 14, 1);
INSERT INTO `spider_link_keywordf` VALUES (4, 459, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (4, 282, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (4, 308, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (5, 475, 8, 1);
INSERT INTO `spider_link_keywordf` VALUES (6, 147, 8, 1);
INSERT INTO `spider_link_keywordf` VALUES (7, 133, 8, 1);
INSERT INTO `spider_link_keywordf` VALUES (7, 147, 8, 1);
INSERT INTO `spider_link_keywordf` VALUES (8, 133, 8, 1);
INSERT INTO `spider_link_keywordf` VALUES (10, 147, 8, 1);
INSERT INTO `spider_link_keywordf` VALUES (16, 490, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (16, 150, 14, 1);
INSERT INTO `spider_link_keywordf` VALUES (16, 164, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (16, 435, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (16, 235, 14, 1);
INSERT INTO `spider_link_keywordf` VALUES (16, 458, 14, 1);
INSERT INTO `spider_link_keywordf` VALUES (16, 282, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (16, 289, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (16, 308, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (18, 529, 8, 1);
INSERT INTO `spider_link_keywordf` VALUES (18, 530, 8, 1);
INSERT INTO `spider_link_keywordf` VALUES (19, 78, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (19, 150, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (19, 435, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (19, 579, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (19, 235, 14, 1);
INSERT INTO `spider_link_keywordf` VALUES (19, 458, 21, 1);
INSERT INTO `spider_link_keywordf` VALUES (19, 308, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (20, 490, 14, 1);
INSERT INTO `spider_link_keywordf` VALUES (20, 601, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (20, 606, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (20, 609, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (20, 150, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (20, 435, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (20, 196, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (20, 373, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (20, 579, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (20, 235, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (20, 385, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (20, 458, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (20, 630, 7, 1);
INSERT INTO `spider_link_keywordf` VALUES (21, 530, 7, 1);

-- --------------------------------------------------------

-- 
-- Структура таблицы `spider_links`
-- 

DROP TABLE IF EXISTS `spider_links`;
CREATE TABLE IF NOT EXISTS `spider_links` (
  `spider_link_id` int(11) NOT NULL auto_increment,
  `spider_site_id` int(11) default NULL,
  `spider_link_url` varchar(255) NOT NULL,
  `spider_link_title` varchar(200) default NULL,
  `spider_link_description` varchar(255) default NULL,
  `spider_link_fulltxt` mediumtext,
  `spider_link_indexdate` datetime default NULL,
  `spider_link_size` float default NULL,
  `spider_link_md5sum` varchar(32) default NULL,
  `spider_link_visible` int(11) default '0',
  `spider_link_level` int(11) default NULL,
  PRIMARY KEY  (`spider_link_id`),
  KEY `spider_link_url` (`spider_link_url`),
  KEY `spider_link_md5key` (`spider_link_md5sum`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 AUTO_INCREMENT=22 ;

-- 
-- Дамп данных таблицы `spider_links`
-- 

INSERT INTO `spider_links` VALUES (1, 1, 'http://www.DOMAIN_NAME/', 'Главная страница', '', 'Проектирование зданий Разработка дизайн-проекта Реконструкция зданий Спецпредложение Предлагаем Вам ознакомиться со спецпредложением по реконструкции зданий. Внимание! Спецпредложение имеет ограниченный срок действия. По всем вопросам - звоните: 555-44-33. Демо площадка Добро пожаловать на демонстрационный сайт системы управления Handy.CMS. Данная демо-площадка создана специально для Вас. Вы можете удалять, создавать страницы, новости и другие материалы без ограничений. Площадка будет активна в течение 6-ти часов, по окончанию этого периода она будет удалена. При необходимости, вы можете создать новую площадку. Демо-тексты для сайта сгенерированы с помощью сервиса Яндекс.Весна . Для доступа в административную часть сайта, перейдите по ссылке: /admin , введите логин и пароль, указанные при регистрации. По всем вопросам, обращайтесь: E-mail: help@handycms.ru Телефоны: (495) 982-38-10, 505-44-02 Проектирование зданий Тем не менее, организация слубы маркетинга парадоксально развивает конструктивный медиамикс, осознав маркетинг как часть производства. Надо сказать, что спонсорство усиливает связанный мониторинг активности, оптимизируя бюджеты. Разработка дизайн-проекта Искусство медиапланирования, вопреки мнению П.Друкера, традиционно отражает conversion rate, опираясь на опыт западных коллег. Агентская комиссия спорадически концентрирует креативный целевой сегмент рынка, повышая конкуренцию. Реконструкция зданий Тактика выстраивания отношений с коммерсчекими агентами усиливает коллективный медиамикс, отвоевывая рыночный сегмент. Искусство медиапланирования концентрирует общественный CTR, не считаясь с затратами. Маркетингово-ориентированное издание отталкивает пресс-клиппинг, опираясь на опыт западных коллег. Новости 16 февраля 2010 Снижение цен на наши услуги Мы снизили цены на 10% - обращайтесь к нам. 16 февраля 2010 Сезонные скидки Рады сообщить Вам о начале сезонных скидок. 16 февраля 2010 Мы запустили новый сайт Добро пожаловать на наш новый сайт, надеемся Вам у нас понравится! Добро пожаловать на сайт нашей компании! Общество потребления, анализируя результаты рекламной кампании, спонтанно тормозит сублимированный рекламный блок, повышая конкуренцию. Презентационный материал одновременно индуцирует пул лояльных изданий, не считаясь с затратами. Презентация подсознательно индуцирует медиамикс, повышая конкуренцию. В рамках концепции Акоффа и Стэка, селекция бренда программирует комплексный маркетинг, опираясь на опыт западных коллег. Клиентский спрос неоднозначен. Потребительская база развивает культурный рекламоноситель, оптимизируя бюджеты. По сути, формат события версифицирован. VIP-мероприятие синхронизирует социальный статус, осознав маркетинг как часть производства. Рекламное сообщество повсеместно концентрирует креативный побочный PR-эффект, учитывая результат предыдущих медиа-кампаний. Последние статьи Почему не критично управление брендом? Интересноотметить,что традиционный канал сложен. Организация службы маркетинга просветляет канон биографии, так Г.Корф формулирует собственную антитезу. Целое образа концентрирует из ряда вон выходящий сегмент рынка, таким образом, все перечисленные признаки архетипа и мифа подтверждают, что действие механизмов мифотворчества сродни механизмам художественно-продуктивного мышления. Почему изоморфнавремени художественная богема? Шиллер утверждал: выразительное трансформирует рейтинг, учитывая современные тенденции. Сангвиник транслирует сублимированный сегмент рынка, осознав маркетинг как часть производства. PR использует комплексный анализ ситуации, это же положение обосновывал Ж.Польти в книге \\"Тридцать шесть драматических ситуаций\\".', '2010-10-19 00:00:00', 14.87, '489373d306f79467ef178b970c624a82', 0, 0);
INSERT INTO `spider_links` VALUES (2, 1, 'http://www.DOMAIN_NAME/about/', 'О компании', '', 'О компании Статьи Вакансии Страница находится в стадии заполнения информации, приносим Вам свои извинения за предоставленные неудобства.', '2010-10-19 00:00:00', 8.69, '00989aed53f2e4b92193aa42803be3d0', 0, 1);
INSERT INTO `spider_links` VALUES (3, 1, 'http://www.DOMAIN_NAME/about/articles/4.html', 'Почему не критично управление брендом?', 'Почему не критично управление брендом?', 'Почему не критично управление брендом? Статьи Вакансии 08 июля 2010 Интересноотметить,что традиционный канал сложен. Организация службы маркетинга просветляет канон биографии, так Г.Корф формулирует собственную антитезу. Целое образа концентрирует из ряда вон выходящий сегмент рынка, таким образом, все перечисленные признаки архетипа и мифа подтверждают, что действие механизмов мифотворчества сродни механизмам художественно-продуктивного мышления. Интенция переворачивает неизменный ребрендинг, таким образом, сходные законы контрастирующего развития характерны и для процессов в психике. Лидерство в продажах притягивает тактический охват аудитории, так Г.Корф формулирует собственную антитезу. К тому же искусство готично нейтрализует стиль менеджмента, что-то подобное можно встретить в работах Ауэрбаха и Тандлера. Поэтому иррациональное в творчестве отталкивает декаданс, опираясь на опыт западных коллег. Действительно, объемная скидка имитирует незначительный хтонический миф, повышая конкуренцию. Рыночная ситуация изящно экономит монтаж, повышая конкуренцию. Семиотика искусства выстраивает принципвосприятия, осознав маркетинг как часть производства. Медиавес, не меняя концепции, изложенной выше, стремительно переворачивает культурный нишевый проект, отвоевывая рыночный сегмент. Мистерия, как бы это ни казалось парадоксальным, монотонно образует ролевой бренд, так Г.Корф формулирует собственную антитезу. Молодежная аудитория отталкивает рейтинг, опираясь на опыт западных коллег. К списку новостей', '2010-10-19 00:00:00', 10.51, '5e8b00ca188a42257b6d089ae5502f8e', 0, 1);
INSERT INTO `spider_links` VALUES (4, 1, 'http://www.DOMAIN_NAME/about/articles/6.html', 'Почему изоморфнавремени художественная богема?', 'Почему изоморфнавремени художественная богема?', 'Почему изоморфнавремени художественная богема? Статьи Вакансии 04 июля 2010 Шиллер утверждал: выразительное трансформирует рейтинг, учитывая современные тенденции. Сангвиник транслирует сублимированный сегмент рынка, осознав маркетинг как часть производства. PR использует комплексный анализ ситуации, это же положение обосновывал Ж.Польти в книге \\"Тридцать шесть драматических ситуаций\\". Эротическое, вопреки мнению П.Друкера, спонтанно использует композиционный принцип артистизма, однако само по себе состояние игры всегда амбивалентно. Медиапланирование готично охватывает контент, однако само по себе состояние игры всегда амбивалентно. Клиентский спрос реально искажает коллективный катарсис, именно об этом комплексе движущих сил писал З.Фрейд в теории сублимации. Богатство мировой литературы от Платона до Ортеги-и-Гассета свидетельствует о том, что особенность рекламы стабилизирует креативный целевой трафик, полагаясь на инсайдерскую информацию. Каждая сфера рынка существенно начинает социометрический синтез искусств, именно об этом комплексе движущих сил писал З.Фрейд в теории сублимации. Поэтому фарс оправдывает эпитет, расширяя долю рынка. Стиль менеджмента,какследуетизвышесказанного, ускоряет направленный маркетинг, таким образом, все перечисленные признаки архетипа и мифа подтверждают, что действие механизмов мифотворчества сродни механизмам художественно-продуктивного мышления. Восприятие марки изящно позиционирует канон биографии, полагаясь на инсайдерскую информацию. CTR изящно вызывает процесс стратегического планирования, что-то подобное можно встретить в работах Ауэрбаха и Тандлера. Инструмент маркетинга имеет общественный медиавес, полагаясь на инсайдерскую информацию. Искусство как всегда непредсказуемо. Канон биографии, следовательно, заканчивает культурный базовый тип личности, повышая конкуренцию. К списку новостей', '2010-10-19 00:00:00', 10.87, 'ba6db7dad5ed9e1179ffc98a28c76697', 0, 1);
INSERT INTO `spider_links` VALUES (5, 1, 'http://www.DOMAIN_NAME/contact/', 'Контакты', '', 'Контакты ФИО? * Компания * Контактные телефоны * Email * Подробности заказа * Новое поле', '2010-10-19 00:00:00', 10.44, 'd04363869e4ca24ccf614cc212689829', 0, 1);
INSERT INTO `spider_links` VALUES (6, 1, 'http://www.DOMAIN_NAME/map/', 'Карта сайта', '', 'Карта сайта О компании Статьи Вакансии Услуги Проектирование зданий Разработка дизайн-проекта Реконструкция зданий Новости Контакты Карта сайта Поиск по сайту', '2010-10-19 00:00:00', 10.7, '6bc15d877a267635f465b48e4ced4cc0', 0, 1);
INSERT INTO `spider_links` VALUES (7, 1, 'http://www.DOMAIN_NAME/news/', 'Новости', '', 'Новости Снижение цен на наши услуги 16 февраля 2010 Мы снизили цены на 10% - обращайтесь к нам. Сезонные скидки 16 февраля 2010 Рады сообщить Вам о начале сезонных скидок. Мы запустили новый сайт 16 февраля 2010 Добро пожаловать на наш новый сайт, надеемся Вам у нас понравится!', '2010-10-19 00:00:00', 8.93, '1c78833d3daef16f9fdc4a2c69a0f367', 0, 1);
INSERT INTO `spider_links` VALUES (8, 1, 'http://www.DOMAIN_NAME/news/1.html', 'Мы запустили новый сайт', 'Мы запустили новый сайт', 'Мы запустили новый сайт 16 февраля 2010 Добро пожаловать на наш новый сайт, надеемся Вам у нас понравится! Пишите отзывы! К списку новостей', '2010-10-19 00:00:00', 8.36, '201ffcf5f012a4c5191844df175827ad', 0, 1);
INSERT INTO `spider_links` VALUES (9, 1, 'http://www.DOMAIN_NAME/news/2.html', 'Снижение цен на наши услуги', 'Снижение цен на наши услуги', 'Снижение цен на наши услуги 16 февраля 2010 Мы снизили цены на 10% - обращайтесь к нам. К списку новостей', '2010-10-19 00:00:00', 8.34, '32d3b6b50e8a972aa92a704e69c50fca', 0, 1);
INSERT INTO `spider_links` VALUES (10, 1, 'http://www.DOMAIN_NAME/news/3.html', 'Сезонные скидки', 'Сезонные скидки', 'Сезонные скидки 16 февраля 2010 Рады сообщить Вам о начале сезонных скидок. Спешите! К списку новостей', '2010-10-19 00:00:00', 8.31, 'd9a4373560f80dc62067117d62fcc9bc', 0, 1);
INSERT INTO `spider_links` VALUES (11, 1, 'http://www.DOMAIN_NAME/search/', 'Поиск по сайту', '', 'Поиск по сайту', '2010-10-19 00:00:00', 8.18, 'b99cc33fafb6fafefca5bbbf2db09d63', 0, 1);
INSERT INTO `spider_links` VALUES (12, 1, 'http://www.DOMAIN_NAME/service/', 'Услуги', '', 'Услуги Проектирование зданий Разработка дизайн-проекта Реконструкция зданий Страница находится в стадии заполнения информации, приносим Вам свои извинения за предоставленные неудобства.', '2010-10-19 00:00:00', 8.98, '2a38a24f9775395703e751cd35240624', 0, 1);
INSERT INTO `spider_links` VALUES (13, 1, 'http://www.DOMAIN_NAME/service/design/', 'Разработка дизайн-проекта', '', 'Разработка дизайн-проекта Проектирование зданий Разработка дизайн-проекта Реконструкция зданий Страница находится в стадии заполнения информации, приносим Вам свои извинения за предоставленные неудобства.', '2010-10-19 00:00:00', 9.35, '372eda0734d76315b146c3523808f1ba', 0, 1);
INSERT INTO `spider_links` VALUES (14, 1, 'http://www.DOMAIN_NAME/service/pr/', 'Проектирование зданий', '', 'Проектирование зданий Проектирование зданий Разработка дизайн-проекта Реконструкция зданий Страница находится в стадии заполнения информации, приносим Вам свои извинения за предоставленные неудобства.', '2010-10-19 00:00:00', 9.34, 'f9d6a5f9abbc0fcfd34637990916f67d', 0, 1);
INSERT INTO `spider_links` VALUES (15, 1, 'http://www.DOMAIN_NAME/service/zd/', 'Реконструкция зданий', '', 'Реконструкция зданий Проектирование зданий Разработка дизайн-проекта Реконструкция зданий Страница находится в стадии заполнения информации, приносим Вам свои извинения за предоставленные неудобства.', '2010-10-19 00:00:00', 9.34, '323b58f7e25635818e047d4ba849ce7c', 0, 1);
INSERT INTO `spider_links` VALUES (16, 1, 'http://www.DOMAIN_NAME/about/articles/', 'Статьи', '', 'Статьи Статьи Вакансии Почему не критично управление брендом? Интересноотметить,что традиционный канал сложен. Организация службы маркетинга просветляет канон биографии, так Г.Корф формулирует собственную антитезу. Целое образа концентрирует из ряда вон выходящий сегмент рынка, таким образом, все перечисленные признаки архетипа и мифа подтверждают, что действие механизмов мифотворчества сродни механизмам художественно-продуктивного мышления. Почему изоморфнавремени художественная богема? Шиллер утверждал: выразительное трансформирует рейтинг, учитывая современные тенденции. Сангвиник транслирует сублимированный сегмент рынка, осознав маркетинг как часть производства. PR использует комплексный анализ ситуации, это же положение обосновывал Ж.Польти в книге \\"Тридцать шесть драматических ситуаций\\". Почему гармонично медиапланирование? Нередуцируемость содержания нейтрализует экспрессионизм, именно об этом комплексе движущих сил писал З.Фрейд в теории сублимации. Онтогенез заканчивает суггестивный процесс стратегического планирования, это же положение обосновывал Ж.Польти в книге \\"Тридцать шесть драматических ситуаций\\". Аксиология интегрирована. Бессознательный этикет: гипотеза и теории Героическое, не меняя концепции, изложенной выше, позиционирует потребительский рынок, таким образом, второй комплекс движущих сил получил разработку в трудах А.Берталанфи и Ш.Бюлера. Не факт, что художественное опосредование специфицирует метод кластерного анализа, опираясь на опыт западных коллег.', '2010-10-19 00:00:00', 10.79, '82c05770c2db7aa79ca29e4a07ce29bd', 0, 2);
INSERT INTO `spider_links` VALUES (17, 1, 'http://www.DOMAIN_NAME/about/vac/', 'Вакансии', '', 'Вакансии Статьи Вакансии Страница находится в стадии заполнения информации, приносим Вам свои извинения за предоставленные неудобства.', '2010-10-19 00:00:00', 9, 'dd2ff3a095c45d5003c96837f6fdf48f', 0, 2);
INSERT INTO `spider_links` VALUES (18, 1, 'http://www.DOMAIN_NAME/admin/', 'Система управления сайтом Handy.CMS | www.DOMAIN_NAME', '', 'Забыли пароль? Попытка доступа с неверного IP - адреса! Логин или пароль не верны! Доступ запрещен! Забыли пароль? У Вас выключены cookie!Включите их и перезагрузите страницуc помощью ctrl+F5. Handy.CMS 3.1 build 2008. &copy 2003-2010 Студия дизайна Obsudim.', '2010-10-19 00:00:00', 12.55, '13b9ca17924cdc0001254cd626018931', 0, 2);
INSERT INTO `spider_links` VALUES (19, 1, 'http://www.DOMAIN_NAME/about/articles/5.html', 'Бессознательный этикет: гипотеза и теории', 'Бессознательный этикет: гипотеза и теории', 'Бессознательный этикет: гипотеза и теории Статьи Вакансии 01 июня 2010 Героическое, не меняя концепции, изложенной выше, позиционирует потребительский рынок, таким образом, второй комплекс движущих сил получил разработку в трудах А.Берталанфи и Ш.Бюлера. Не факт, что художественное опосредование специфицирует метод кластерного анализа, опираясь на опыт западных коллег. Стимулирование сбыта, согласно Ф.Котлеру, оправдывает сокращенный филогенез, именно об этом комплексе движущих сил писал З.Фрейд в теории сублимации. Производство, на первый взгляд, исключительно заканчивает инвестиционный продукт, опираясь на опыт западных коллег. Эволюция мерчандайзинга монотонно продуцирует связанный онтологический статус искусства, используя опыт предыдущих кампаний. Рекламная акция,врамкахсегодняшнихвоззрений, продуцирует фактографический хтонический миф, это же положение обосновывал Ж.Польти в книге \\"Тридцать шесть драматических ситуаций\\". Переходное состояние охватывает рыночный символизм, это же положение обосновывал Ж.Польти в книге \\"Тридцать шесть драматических ситуаций\\". Его экзистенциальная тоска выступает как побудительный мотив творчества, однако художественная богема свободна. Художественное опосредование,какпринятосчитать, образует бессознательный синтез искусств, расширяя долю рынка. Шиллер утверждал: медиапланирование специфицирует предмет искусства, учитывая современные тенденции. Игровое начало, безусловно, начинает эйдос, однако само по себе состояние игры всегда амбивалентно. Инвариант просветляет символический метафоризм, не считаясь с затратами. Художественная эпоха, не меняя концепции, изложенной выше, выстраивает персональный комплекс агрессивности, расширяя долю рынка. Портрет потребителя довольно хорошо сбалансирован. Привлечение аудитории реально ускоряет побочный PR-эффект, так Г.Корф формулирует собственную антитезу. К списку новостей', '2010-10-19 00:00:00', 10.87, '125afbaa98632e32ada629e65fc5a3dc', 0, 3);
INSERT INTO `spider_links` VALUES (20, 1, 'http://www.DOMAIN_NAME/about/articles/7.html', 'Почему гармонично медиапланирование?', 'Почему гармонично медиапланирование?', 'Почему гармонично медиапланирование? Статьи Вакансии 07 июня 2010 Нередуцируемость содержания нейтрализует экспрессионизм, именно об этом комплексе движущих сил писал З.Фрейд в теории сублимации. Онтогенез заканчивает суггестивный процесс стратегического планирования, это же положение обосновывал Ж.Польти в книге \\"Тридцать шесть драматических ситуаций\\". Аксиология интегрирована. Тем не менее, трагическое определяет медийный канал, однако само по себе состояние игры всегда амбивалентно. Целое образа неестественно дает суггестивный гений, учитывая современные тенденции. Системный анализ изящно выстраивает сублимированный монтаж, признавая определенные рыночные тенденции. Как отмечает Майкл Мескон, адекватная ментальность имеет феномер \\"психической мутации\\", таким образом, сходные законы контрастирующего развития характерны и для процессов в психике. Портрет потребителя, в том числе, изящно трансформирует невротический метод кластерного анализа, работая над проектом. Стимулирование сбыта конструктивно. Бессознательное поддерживает рекламный бриф, учитывая современные тенденции. Восприятие сотворчества заканчивает маньеризм, используя опыт предыдущих кампаний. Как предсказывают футурологи бизнес-стратегия отталкивает медиамикс, невзирая на действия конкурентов. Тем не менее, рекламное сообщество постоянно. Традиционный канал раскручивает суггестивный рейтинг, работая над проектом. Экспрессионизм изящно продолжает социометрический пресс-клиппинг, что-то подобное можно встретить в работах Ауэрбаха и Тандлера. К списку новостей', '2010-10-19 00:00:00', 10.54, '130bb859159fbf89476e8e8433a27375', 0, 3);
INSERT INTO `spider_links` VALUES (21, 1, 'http://www.DOMAIN_NAME/admin/lost/', 'Система управления сайтом Handy.CMS | Студия дизайна \\''Obsudim\\''', '', 'Войти в систему', '2010-10-19 00:00:00', 2.58, 'c8608bd577afc2f1b9d9be646eb790d3', 0, 3);

-- --------------------------------------------------------

-- 
-- Структура таблицы `spider_pending`
-- 

DROP TABLE IF EXISTS `spider_pending`;
CREATE TABLE IF NOT EXISTS `spider_pending` (
  `spider_site_id` int(11) default NULL,
  `spider_temp_id` varchar(32) default NULL,
  `spider_pending_level` int(11) default NULL,
  `spider_pending_count` int(11) default NULL,
  `spider_pending_num` int(11) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `spider_pending`
-- 


-- --------------------------------------------------------

-- 
-- Структура таблицы `spider_sites`
-- 

DROP TABLE IF EXISTS `spider_sites`;
CREATE TABLE IF NOT EXISTS `spider_sites` (
  `spider_site_id` int(11) NOT NULL auto_increment,
  `spider_site_url` varchar(255) default NULL,
  `spider_site_title` varchar(255) default NULL,
  `spider_site_short_desc` text,
  `spider_site_indexdate` date default NULL,
  `spider_site_depth` int(11) default '2',
  `spider_site_required` text,
  `spider_site_disallowed` text,
  `spider_site_can_leave_domain` tinyint(1) default NULL,
  PRIMARY KEY  (`spider_site_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

-- 
-- Дамп данных таблицы `spider_sites`
-- 

INSERT INTO `spider_sites` VALUES (1, 'www.DOMAIN_NAME', NULL, NULL, '2010-10-19', -1, '', '', 0);

-- --------------------------------------------------------

-- 
-- Структура таблицы `spider_temp`
-- 

DROP TABLE IF EXISTS `spider_temp`;
CREATE TABLE IF NOT EXISTS `spider_temp` (
  `spider_temp_link` varchar(255) NOT NULL default '',
  `spider_temp_level` int(11) default NULL,
  `spider_temp_id` varchar(32) NOT NULL default '',
  PRIMARY KEY  (`spider_temp_link`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `spider_temp`
-- 


-- --------------------------------------------------------

-- 
-- Структура таблицы `templates`
-- 

DROP TABLE IF EXISTS `templates`;
CREATE TABLE IF NOT EXISTS `templates` (
  `template_id` int(10) unsigned NOT NULL auto_increment,
  `owner_id` int(10) unsigned NOT NULL default '0',
  `template_name` varchar(255) NOT NULL default '',
  `template_filename` varchar(255) NOT NULL default '',
  `template_hash` varchar(32) NOT NULL default '',
  `template_default` enum('true','false') NOT NULL default 'false',
  `template_to_use` enum('true','false') NOT NULL default 'true',
  PRIMARY KEY  (`template_id`),
  KEY `template_to_use` (`template_to_use`)
) ENGINE=MyISAM AUTO_INCREMENT=47 DEFAULT CHARSET=utf8 AUTO_INCREMENT=47 ;

-- 
-- Дамп данных таблицы `templates`
-- 

INSERT INTO `templates` VALUES (42, 1, '', 'template.tpl', '955056c6a38bf52c109e49e1aa26f7e2', 'false', 'true');
INSERT INTO `templates` VALUES (46, 1, '', 'template_inner.tpl', 'c6ad121b691fffc6f7af374423d2884b', 'true', 'true');

-- --------------------------------------------------------

-- 
-- Структура таблицы `templates_errs`
-- 

DROP TABLE IF EXISTS `templates_errs`;
CREATE TABLE IF NOT EXISTS `templates_errs` (
  `template_id` int(11) NOT NULL auto_increment,
  `err_code` varchar(3) NOT NULL,
  `template_data` text NOT NULL,
  PRIMARY KEY  (`template_id`),
  UNIQUE KEY `err_code` (`err_code`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

-- 
-- Дамп данных таблицы `templates_errs`
-- 
INSERT INTO `templates_errs` VALUES (1, '403', '');
INSERT INTO `templates_errs` VALUES (2, '404', '');
INSERT INTO `templates_errs` VALUES (3, '405', '');
INSERT INTO `templates_errs` VALUES (4, '406', '');
INSERT INTO `templates_errs` VALUES (5, '407', '');

-- --------------------------------------------------------

-- 
-- Структура таблицы `templates_labels`
-- 

DROP TABLE IF EXISTS `templates_labels`;
CREATE TABLE IF NOT EXISTS `templates_labels` (
  `template_label_id` int(10) unsigned NOT NULL auto_increment,
  `template_id` int(10) unsigned NOT NULL default '0',
  `template_label_sysname` varchar(255) NOT NULL default '',
  `template_label_displayname` varchar(255) NOT NULL default '',
  `template_label_mess` text NOT NULL,
  `template_label_pic` varchar(255) default NULL,
  `template_label_default` enum('true','false') NOT NULL default 'false',
  PRIMARY KEY  (`template_label_id`),
  KEY `template_id` (`template_id`),
  KEY `template_label_sysname` (`template_label_sysname`)
) ENGINE=MyISAM AUTO_INCREMENT=60 DEFAULT CHARSET=utf8 AUTO_INCREMENT=60 ;

-- 
-- Дамп данных таблицы `templates_labels`
-- 

INSERT INTO `templates_labels` VALUES (52, 42, 'HANDY_LABEL_LEFT_TOP', 'Левая верхняя', '', '', 'false');
INSERT INTO `templates_labels` VALUES (49, 42, 'HANDY_LABEL_LEFT', 'Левая область', '', '', 'false');
INSERT INTO `templates_labels` VALUES (58, 46, 'HANDY_LABEL_LEFT', 'Левая колонка', '', '', 'false');
INSERT INTO `templates_labels` VALUES (59, 46, 'HANDY_LABEL_CENTER_RIGHT', 'Область контента (правая колонка)', '', '', 'true');
INSERT INTO `templates_labels` VALUES (53, 42, 'HANDY_LABEL_RIGHT_TOP', 'Правая верхняя', '', '', 'false');
INSERT INTO `templates_labels` VALUES (54, 42, 'HANDY_LABEL_BLOCK1', 'Центральный блок №1', '', '', 'false');
INSERT INTO `templates_labels` VALUES (55, 42, 'HANDY_LABEL_BLOCK2', 'Центральный блок №2', '', '', 'false');
INSERT INTO `templates_labels` VALUES (56, 42, 'HANDY_LABEL_BLOCK3', 'Центральный блок №3', '', '', 'false');
INSERT INTO `templates_labels` VALUES (57, 42, 'HANDY_LABEL_CENTER_RIGHT', 'Центральный правый блок', '', '', 'false');

-- --------------------------------------------------------

-- 
-- Структура таблицы `templates_preferences`
-- 

DROP TABLE IF EXISTS `templates_preferences`;
CREATE TABLE IF NOT EXISTS `templates_preferences` (
  `default_content` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `templates_preferences`
-- 

INSERT INTO `templates_preferences` VALUES ('Страница находится в стадии заполнения информации, приносим Вам свои извинения за предоставленные неудобства.');

-- --------------------------------------------------------

-- 
-- Структура таблицы `templates_rights`
-- 

DROP TABLE IF EXISTS `templates_rights`;
CREATE TABLE IF NOT EXISTS `templates_rights` (
  `template_id` int(10) unsigned NOT NULL default '0',
  `template_label_id` int(10) unsigned NOT NULL default '0',
  `extension_id` int(10) unsigned NOT NULL default '0',
  KEY `extension_id` (`extension_id`),
  KEY `template_label_id` (`template_label_id`),
  KEY `template_id` (`template_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `templates_rights`
-- 

INSERT INTO `templates_rights` VALUES (42, 57, 15);
INSERT INTO `templates_rights` VALUES (42, 57, 5);
INSERT INTO `templates_rights` VALUES (42, 57, 4);
INSERT INTO `templates_rights` VALUES (42, 57, 9);
INSERT INTO `templates_rights` VALUES (42, 56, 24);
INSERT INTO `templates_rights` VALUES (42, 56, 15);
INSERT INTO `templates_rights` VALUES (42, 56, 5);
INSERT INTO `templates_rights` VALUES (42, 56, 4);
INSERT INTO `templates_rights` VALUES (46, 59, 24);
INSERT INTO `templates_rights` VALUES (46, 59, 15);
INSERT INTO `templates_rights` VALUES (46, 59, 5);
INSERT INTO `templates_rights` VALUES (42, 56, 9);
INSERT INTO `templates_rights` VALUES (42, 55, 24);
INSERT INTO `templates_rights` VALUES (42, 55, 15);
INSERT INTO `templates_rights` VALUES (46, 59, 4);
INSERT INTO `templates_rights` VALUES (42, 55, 5);
INSERT INTO `templates_rights` VALUES (46, 59, 9);
INSERT INTO `templates_rights` VALUES (46, 58, 78);
INSERT INTO `templates_rights` VALUES (46, 59, 78);
INSERT INTO `templates_rights` VALUES (42, 55, 4);
INSERT INTO `templates_rights` VALUES (42, 55, 9);
INSERT INTO `templates_rights` VALUES (42, 54, 24);
INSERT INTO `templates_rights` VALUES (42, 54, 15);
INSERT INTO `templates_rights` VALUES (42, 54, 5);
INSERT INTO `templates_rights` VALUES (42, 54, 4);
INSERT INTO `templates_rights` VALUES (42, 54, 9);
INSERT INTO `templates_rights` VALUES (42, 53, 24);
INSERT INTO `templates_rights` VALUES (42, 53, 15);
INSERT INTO `templates_rights` VALUES (42, 53, 5);
INSERT INTO `templates_rights` VALUES (42, 53, 4);
INSERT INTO `templates_rights` VALUES (42, 53, 9);
INSERT INTO `templates_rights` VALUES (42, 52, 24);
INSERT INTO `templates_rights` VALUES (42, 52, 15);
INSERT INTO `templates_rights` VALUES (42, 52, 5);
INSERT INTO `templates_rights` VALUES (42, 52, 4);
INSERT INTO `templates_rights` VALUES (42, 52, 9);
INSERT INTO `templates_rights` VALUES (42, 49, 24);
INSERT INTO `templates_rights` VALUES (42, 49, 15);
INSERT INTO `templates_rights` VALUES (42, 49, 5);
INSERT INTO `templates_rights` VALUES (42, 49, 4);
INSERT INTO `templates_rights` VALUES (42, 49, 9);
INSERT INTO `templates_rights` VALUES (46, 58, 24);
INSERT INTO `templates_rights` VALUES (42, 57, 24);
INSERT INTO `templates_rights` VALUES (46, 58, 15);
INSERT INTO `templates_rights` VALUES (46, 58, 5);
INSERT INTO `templates_rights` VALUES (46, 58, 4);
INSERT INTO `templates_rights` VALUES (46, 58, 9);

-- --------------------------------------------------------

-- 
-- Структура таблицы `text_blocks_data`
-- 

DROP TABLE IF EXISTS `text_blocks_data`;
CREATE TABLE IF NOT EXISTS `text_blocks_data` (
  `block_id` mediumint(8) unsigned NOT NULL auto_increment,
  `group_id` mediumint(8) unsigned NOT NULL default '0',
  `owner_id` int(10) unsigned NOT NULL default '0',
  `block_title` varchar(255) NOT NULL default '',
  `modify_date` timestamp NOT NULL default '0000-00-00 00:00:00',
  `text` text NOT NULL,
  PRIMARY KEY  (`block_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 PACK_KEYS=0 AUTO_INCREMENT=7 ;

-- 
-- Дамп данных таблицы `text_blocks_data`
-- 

INSERT INTO `text_blocks_data` VALUES (1, 1, 1, 'Демо площадка', '2010-07-08 18:59:13', '<P>Добро пожаловать на демонстрационный сайт системы управления Handy.CMS. Данная демо-площадка создана специально для Вас. Вы можете удалять, создавать страницы, новости и другие материалы без ограничений. </P>\r\n<P>Площадка будет активна в течение 6-ти часов, по окончанию этого периода она будет удалена. При необходимости, вы можете создать новую площадку.</P>\r\n<P>Демо-тексты для сайта сгенерированы с помощью сервиса <A href="http://vesna.yandex.ru">Яндекс.Весна</A>.</P>\r\n<P>Для доступа в административную часть сайта, перейдите по ссылке: <A href="/admin">/admin</A>, введите логин и пароль, указанные при регистрации.</P>\r\n<P>По всем вопросам, обращайтесь:</P>\r\n<UL>\r\n<LI>E-mail: <A href="mailto:help@handycms.ru">help@handycms.ru</A> \r\n<LI>Телефоны: (495) 982-38-10, 505-44-02</LI></UL>');
INSERT INTO `text_blocks_data` VALUES (2, 1, 1, 'Спецпредложение', '2010-07-08 18:47:54', '<P>Предлагаем Вам ознакомиться со спецпредложением по реконструкции зданий. </P>\r\n<P><STRONG>Внимание!</STRONG> Спецпредложение имеет ограниченный срок действия. По всем вопросам - звоните: 555-44-33.</P>');
INSERT INTO `text_blocks_data` VALUES (3, 1, 1, 'Проектирование зданий', '2010-07-08 19:12:01', '<P><IMG style="MARGIN-RIGHT: 10px" border=0 alt="" src="/files/textblocks/1inews.png" width=260 height=160></P>\r\n<P>Тем не менее, организация слубы маркетинга парадоксально развивает конструктивный медиамикс, осознав маркетинг как часть производства. Надо сказать, что спонсорство усиливает связанный мониторинг активности, оптимизируя бюджеты. </P>');
INSERT INTO `text_blocks_data` VALUES (4, 1, 1, 'Разработка дизайн-проекта', '2010-07-08 19:42:29', '<P><IMG border=0 alt="" src="/files/textblocks/newsi3.png"></P>\r\n<P>Искусство медиапланирования, вопреки мнению П.Друкера, традиционно отражает conversion rate, опираясь на опыт западных коллег. Агентская комиссия спорадически концентрирует креативный целевой сегмент рынка, повышая конкуренцию.</P>');
INSERT INTO `text_blocks_data` VALUES (5, 1, 1, 'Реконструкция зданий', '2010-07-08 19:13:11', '<P><IMG border=0 alt="" src="/files/textblocks/newsi2.png"></P>\r\n<P>Тактика выстраивания отношений с коммерсчекими агентами усиливает коллективный медиамикс, отвоевывая рыночный сегмент. Искусство медиапланирования концентрирует общественный CTR, не считаясь с затратами. Маркетингово-ориентированное издание отталкивает пресс-клиппинг, опираясь на опыт западных коллег. </P>');
INSERT INTO `text_blocks_data` VALUES (6, 1, 1, 'Добро пожаловать на сайт нашей компании!', '2010-07-08 19:41:56', '<P>Общество потребления, анализируя результаты рекламной кампании, спонтанно тормозит сублимированный рекламный блок, повышая конкуренцию. Презентационный материал одновременно индуцирует пул лояльных изданий, не считаясь с затратами. Презентация подсознательно индуцирует медиамикс, повышая конкуренцию. В рамках концепции Акоффа и Стэка, селекция бренда программирует комплексный маркетинг, опираясь на опыт западных коллег. Клиентский спрос неоднозначен. </P>\r\n<P>Потребительская база развивает культурный рекламоноситель, оптимизируя бюджеты. По сути, формат события версифицирован. VIP-мероприятие синхронизирует социальный статус, осознав маркетинг как часть производства.</P>\r\n<P>Рекламное сообщество повсеместно концентрирует креативный побочный PR-эффект, учитывая результат предыдущих медиа-кампаний. </P>');

-- --------------------------------------------------------

-- 
-- Структура таблицы `text_blocks_groups`
-- 

DROP TABLE IF EXISTS `text_blocks_groups`;
CREATE TABLE IF NOT EXISTS `text_blocks_groups` (
  `group_id` mediumint(8) unsigned NOT NULL auto_increment,
  `owner_id` int(10) unsigned NOT NULL default '0',
  `group_name` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`group_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 PACK_KEYS=0 AUTO_INCREMENT=2 ;

-- 
-- Дамп данных таблицы `text_blocks_groups`
-- 

INSERT INTO `text_blocks_groups` VALUES (1, 1, 'Демо-данные');

-- --------------------------------------------------------

-- 
-- Структура таблицы `transactions`
-- 

DROP TABLE IF EXISTS `transactions`;
CREATE TABLE IF NOT EXISTS `transactions` (
  `transaction_id` int(10) unsigned NOT NULL auto_increment,
  `session_id` varchar(40) NOT NULL,
  `operation` varchar(40) NOT NULL,
  PRIMARY KEY  (`transaction_id`),
  KEY `session_id` (`session_id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 AUTO_INCREMENT=17 ;

-- 
-- Дамп данных таблицы `transactions`
-- 

INSERT INTO `transactions` VALUES (1, '34b821d91c1dd16d50de735ea7820063', 'reload_tree');
INSERT INTO `transactions` VALUES (2, '34b821d91c1dd16d50de735ea7820063', 'reload_tree');
INSERT INTO `transactions` VALUES (3, '54f78cec242d301ed71d04c4ef345681', 'reload_tree');
INSERT INTO `transactions` VALUES (4, '54f78cec242d301ed71d04c4ef345681', 'reload_tree');
INSERT INTO `transactions` VALUES (5, '54f78cec242d301ed71d04c4ef345681', 'reload_tree');
INSERT INTO `transactions` VALUES (6, '54f78cec242d301ed71d04c4ef345681', 'reload_tree');
INSERT INTO `transactions` VALUES (7, '54f78cec242d301ed71d04c4ef345681', 'reload_tree');
INSERT INTO `transactions` VALUES (8, '7e2d2161513e25c03ed0828e73c19dad', 'reload_tree');
INSERT INTO `transactions` VALUES (9, '7e2d2161513e25c03ed0828e73c19dad', 'reload_tree');
INSERT INTO `transactions` VALUES (10, '7e2d2161513e25c03ed0828e73c19dad', 'reload_tree');
INSERT INTO `transactions` VALUES (11, '7e2d2161513e25c03ed0828e73c19dad', 'reload_tree');
INSERT INTO `transactions` VALUES (12, '7e2d2161513e25c03ed0828e73c19dad', 'reload_tree');
INSERT INTO `transactions` VALUES (13, '7e2d2161513e25c03ed0828e73c19dad', 'reload_tree');
INSERT INTO `transactions` VALUES (14, '7e2d2161513e25c03ed0828e73c19dad', 'reload_tree');
INSERT INTO `transactions` VALUES (15, '7e2d2161513e25c03ed0828e73c19dad', 'reload_tree');
INSERT INTO `transactions` VALUES (16, '7e2d2161513e25c03ed0828e73c19dad', 'exec(''extmanager'',''action=desktop_icons''');

-- --------------------------------------------------------

-- 
-- Структура таблицы `transactions_sess`
-- 

DROP TABLE IF EXISTS `transactions_sess`;
CREATE TABLE IF NOT EXISTS `transactions_sess` (
  `transaction_id` int(10) unsigned NOT NULL,
  `session_id` varchar(255) NOT NULL,
  PRIMARY KEY  (`transaction_id`,`session_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Дамп данных таблицы `transactions_sess`
-- 

INSERT INTO `transactions_sess` VALUES (1, '54f78cec242d301ed71d04c4ef345681');
INSERT INTO `transactions_sess` VALUES (1, '73ad9d6573f8251cf2916559eabb7003');
INSERT INTO `transactions_sess` VALUES (1, '7e2d2161513e25c03ed0828e73c19dad');
INSERT INTO `transactions_sess` VALUES (1, 'b714b4928ede8869e439c58f1306e279');
INSERT INTO `transactions_sess` VALUES (2, '54f78cec242d301ed71d04c4ef345681');
INSERT INTO `transactions_sess` VALUES (2, '73ad9d6573f8251cf2916559eabb7003');
INSERT INTO `transactions_sess` VALUES (2, '7e2d2161513e25c03ed0828e73c19dad');
INSERT INTO `transactions_sess` VALUES (2, 'b714b4928ede8869e439c58f1306e279');
INSERT INTO `transactions_sess` VALUES (3, '73ad9d6573f8251cf2916559eabb7003');
INSERT INTO `transactions_sess` VALUES (3, '7e2d2161513e25c03ed0828e73c19dad');
INSERT INTO `transactions_sess` VALUES (3, 'b714b4928ede8869e439c58f1306e279');
INSERT INTO `transactions_sess` VALUES (4, '73ad9d6573f8251cf2916559eabb7003');
INSERT INTO `transactions_sess` VALUES (4, '7e2d2161513e25c03ed0828e73c19dad');
INSERT INTO `transactions_sess` VALUES (4, 'b714b4928ede8869e439c58f1306e279');
INSERT INTO `transactions_sess` VALUES (5, '73ad9d6573f8251cf2916559eabb7003');
INSERT INTO `transactions_sess` VALUES (5, '7e2d2161513e25c03ed0828e73c19dad');
INSERT INTO `transactions_sess` VALUES (5, 'b714b4928ede8869e439c58f1306e279');
INSERT INTO `transactions_sess` VALUES (6, '73ad9d6573f8251cf2916559eabb7003');
INSERT INTO `transactions_sess` VALUES (6, '7e2d2161513e25c03ed0828e73c19dad');
INSERT INTO `transactions_sess` VALUES (6, 'b714b4928ede8869e439c58f1306e279');
INSERT INTO `transactions_sess` VALUES (7, '73ad9d6573f8251cf2916559eabb7003');
INSERT INTO `transactions_sess` VALUES (7, '7e2d2161513e25c03ed0828e73c19dad');
INSERT INTO `transactions_sess` VALUES (7, 'b714b4928ede8869e439c58f1306e279');

-- --------------------------------------------------------

-- 
-- Структура таблицы `usermenus`
-- 

DROP TABLE IF EXISTS `usermenus`;
CREATE TABLE IF NOT EXISTS `usermenus` (
  `usermenu_id` int(10) unsigned NOT NULL auto_increment,
  `lang_version_id` int(10) unsigned NOT NULL default '0',
  `usermenu_name` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`usermenu_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

-- 
-- Дамп данных таблицы `usermenus`
-- 

INSERT INTO `usermenus` VALUES (1, 1, 'Дополнительное демо-меню');

-- --------------------------------------------------------

-- 
-- Структура таблицы `usermenus_data`
-- 

DROP TABLE IF EXISTS `usermenus_data`;
CREATE TABLE IF NOT EXISTS `usermenus_data` (
  `item_id` int(10) unsigned NOT NULL auto_increment,
  `usermenu_id` int(10) unsigned NOT NULL default '0',
  `item_showorder` int(10) unsigned NOT NULL default '0',
  `item_name` varchar(255) NOT NULL default '',
  `item_pic_active` varchar(255) NOT NULL default '',
  `item_pic_inactive` varchar(255) NOT NULL default '',
  `item_url_selected` enum('true','false') NOT NULL default 'false',
  `item_url` varchar(255) NOT NULL default '',
  `item_node_id` int(10) unsigned NOT NULL default '0',
  `item_child` enum('true','false') NOT NULL default 'false',
  PRIMARY KEY  (`item_id`),
  KEY `usermenu_id` (`usermenu_id`),
  KEY `item_showorder` (`item_showorder`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

-- 
-- Дамп данных таблицы `usermenus_data`
-- 

INSERT INTO `usermenus_data` VALUES (1, 1, 1, 'Проектирование зданий', '', '', 'false', '', 15, '');
INSERT INTO `usermenus_data` VALUES (2, 1, 2, 'Разработка дизайн-проекта', '', '', 'false', '', 16, '');
INSERT INTO `usermenus_data` VALUES (3, 1, 3, 'Реконструкция зданий', '', '', 'false', '', 17, '');

-- --------------------------------------------------------

ALTER TABLE `forms` ADD `use_default_email` ENUM( '1', '0' ) NOT NULL DEFAULT '0';


DROP TABLE IF EXISTS `seo_metas`;
CREATE TABLE IF NOT EXISTS `seo_metas` (
  `seo_meta_id` int(11) NOT NULL auto_increment,
  `seo_meta_url` varchar(255) NOT NULL,
  `seo_meta_type` varchar(50) NOT NULL,
  `seo_meta_value` varchar(255) NOT NULL,
  `owner_id` int(11) default '0',
  PRIMARY KEY  (`seo_meta_id`),
  UNIQUE KEY `seo_meta_url_2` (`seo_meta_url`,`seo_meta_type`),
  KEY `seo_meta_type` (`seo_meta_type`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

-- 
-- Дамп данных таблицы `seo_metas`
-- 

INSERT INTO `seo_metas` VALUES (1, '', 'page_title', '', 0);
INSERT INTO `seo_metas` VALUES (2, '', 'meta_title', '', 0);
INSERT INTO `seo_metas` VALUES (3, '', 'meta_keywords', '', 0);
INSERT INTO `seo_metas` VALUES (4, '', 'meta_description', '', 0);

INSERT INTO `extensions` VALUES (79, 'seo', 'SEO', 'false', 'false', 'true', 'true', 'Студия дизайна Obsudim', '1.0', '14.03.2012', 'false', '');
 